/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.teleporter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.lib.api.MachineInformation;
import mcjty.lib.entity.GenericEnergyReceiverTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import mcjty.rftools.blocks.teleporter.DialingDeviceTileEntity;
import mcjty.rftools.blocks.teleporter.GuiMatterTransmitter;
import mcjty.rftools.blocks.teleporter.MatterReceiverTileEntity;
import mcjty.rftools.blocks.teleporter.TeleportConfiguration;
import mcjty.rftools.blocks.teleporter.TeleportDestination;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import mcjty.rftools.blocks.teleporter.TeleportationTools;
import mcjty.rftools.varia.RFToolsTools;
import mcjty.typed.Type;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MatterTransmitterTileEntity
extends GenericEnergyReceiverTileEntity
implements MachineInformation,
ITickable {
    public static final String CMD_SETNAME = "setName";
    public static final String CMD_ADDPLAYER = "addPlayer";
    public static final String CMD_DELPLAYER = "delPlayer";
    public static final String CMD_SETPRIVATE = "setAccess";
    public static final String CMD_SETBEAM = "setBeam";
    public static final String CMD_GETPLAYERS = "getPlayers";
    public static final String CLIENTCMD_GETPLAYERS = "getPlayers";
    private static final String[] TAGS = new String[]{"dim", "coord", "name"};
    private static final String[] TAG_DESCRIPTIONS = new String[]{"The dimension this transmitter is dialed too", "The coordinate this transmitter is dialed too", "The name of the destination"};
    private TeleportDestination teleportDestination = null;
    private Integer teleportId = null;
    private boolean once = false;
    private String name = null;
    private boolean privateAccess = false;
    private boolean beamHidden = false;
    private Set<String> allowedPlayers = new HashSet<String>();
    private int status = 0;
    private String teleportingPlayer = null;
    private int teleportTimer = 0;
    private int cooldownTimer = 0;
    private int totalTicks;
    private int goodTicks;
    private int badTicks;
    private int rfPerTick = 0;
    private int checkReceiverStatusCounter = 20;
    private AxisAlignedBB beamBox = null;

    public MatterTransmitterTileEntity() {
        super(TeleportConfiguration.TRANSMITTER_MAXENERGY, TeleportConfiguration.TRANSMITTER_RECEIVEPERTICK);
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.markDirtyClient();
    }

    public boolean isPrivateAccess() {
        return this.privateAccess;
    }

    public void setPrivateAccess(boolean privateAccess) {
        this.privateAccess = privateAccess;
        this.markDirtyClient();
    }

    public boolean isBeamHidden() {
        return this.beamHidden;
    }

    public void setBeamHidden(boolean b) {
        this.beamHidden = b;
        this.markDirtyClient();
    }

    public boolean isOnce() {
        return this.once;
    }

    public int getTagCount() {
        return TAGS.length;
    }

    public String getTagName(int index) {
        return TAGS[index];
    }

    public String getTagDescription(int index) {
        return TAG_DESCRIPTIONS[index];
    }

    public String getData(int index, long millis) {
        TeleportDestination destination = this.getTeleportDestination();
        if (destination == null) {
            return "<not dialed>";
        }
        switch (index) {
            case 0: {
                return Integer.toString(destination.getDimension());
            }
            case 1: {
                return destination.getCoordinate().toString();
            }
            case 2: {
                return destination.getName();
            }
        }
        return null;
    }

    public boolean checkAccess(String player) {
        if (!this.privateAccess) {
            return true;
        }
        return this.allowedPlayers.contains(player);
    }

    public int getStatus() {
        return this.status;
    }

    public List<String> getAllowedPlayers() {
        return new ArrayList<String>(this.allowedPlayers);
    }

    public void addPlayer(String player) {
        if (!this.allowedPlayers.contains(player)) {
            this.allowedPlayers.add(player);
            this.markDirtyClient();
        }
    }

    public void delPlayer(String player) {
        if (this.allowedPlayers.contains(player)) {
            this.allowedPlayers.remove(player);
            this.markDirtyClient();
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.teleportTimer = tagCompound.func_74762_e("tpTimer");
        this.cooldownTimer = tagCompound.func_74762_e("cooldownTimer");
        this.totalTicks = tagCompound.func_74762_e("totalTicks");
        this.goodTicks = tagCompound.func_74762_e("goodTicks");
        this.badTicks = tagCompound.func_74762_e("badTicks");
        this.teleportingPlayer = tagCompound.func_74779_i("tpPlayer");
        if (this.teleportingPlayer.isEmpty()) {
            this.teleportingPlayer = null;
        }
        this.status = tagCompound.func_74762_e("status");
        this.rfPerTick = tagCompound.func_74762_e("rfPerTick");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.name = tagCompound.func_74779_i("tpName");
        BlockPos c = BlockPosTools.readFromNBT((NBTTagCompound)tagCompound, (String)"dest");
        if (c == null) {
            this.teleportDestination = null;
        } else {
            int dim = tagCompound.func_74762_e("dim");
            this.teleportDestination = new TeleportDestination(c, dim);
        }
        this.teleportId = tagCompound.func_74764_b("destId") ? Integer.valueOf(tagCompound.func_74762_e("destId")) : null;
        this.privateAccess = tagCompound.func_74767_n("private");
        this.beamHidden = tagCompound.func_74767_n("hideBeam");
        this.once = tagCompound.func_74767_n("once");
        this.allowedPlayers.clear();
        NBTTagList playerList = tagCompound.func_150295_c("players", 8);
        if (playerList != null) {
            for (int i = 0; i < playerList.func_74745_c(); ++i) {
                String player = playerList.func_150307_f(i);
                this.allowedPlayers.add(player);
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("tpTimer", this.teleportTimer);
        tagCompound.func_74768_a("cooldownTimer", this.cooldownTimer);
        tagCompound.func_74768_a("totalTicks", this.totalTicks);
        tagCompound.func_74768_a("goodTicks", this.goodTicks);
        tagCompound.func_74768_a("badTicks", this.badTicks);
        if (this.teleportingPlayer != null) {
            tagCompound.func_74778_a("tpPlayer", this.teleportingPlayer);
        }
        tagCompound.func_74768_a("status", this.status);
        tagCompound.func_74768_a("rfPerTick", this.rfPerTick);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        BlockPos c;
        super.writeRestorableToNBT(tagCompound);
        if (this.name != null && !this.name.isEmpty()) {
            tagCompound.func_74778_a("tpName", this.name);
        }
        if (this.teleportDestination != null && (c = this.teleportDestination.getCoordinate()) != null) {
            BlockPosTools.writeToNBT((NBTTagCompound)tagCompound, (String)"dest", (BlockPos)c);
            tagCompound.func_74768_a("dim", this.teleportDestination.getDimension());
        }
        if (this.teleportId != null) {
            tagCompound.func_74768_a("destId", this.teleportId.intValue());
        }
        tagCompound.func_74757_a("private", this.privateAccess);
        tagCompound.func_74757_a("hideBeam", this.beamHidden);
        tagCompound.func_74757_a("once", this.once);
        NBTTagList playerTagList = new NBTTagList();
        for (String player : this.allowedPlayers) {
            playerTagList.func_74742_a((NBTBase)new NBTTagString(player));
        }
        tagCompound.func_74782_a("players", (NBTBase)playerTagList);
    }

    public boolean isDialed() {
        return this.teleportId != null || this.teleportDestination != null;
    }

    public Integer getTeleportId() {
        if (this.isDialed() && this.teleportId == null) {
            this.getTeleportDestination();
        }
        return this.teleportId;
    }

    public TeleportDestination getTeleportDestination() {
        if (this.teleportId != null) {
            TeleportDestinations teleportDestinations = TeleportDestinations.getDestinations(this.func_145831_w());
            GlobalCoordinate gc = teleportDestinations.getCoordinateForId(this.teleportId);
            if (gc == null) {
                return null;
            }
            return teleportDestinations.getDestination(gc.getCoordinate(), gc.getDimension());
        }
        return this.teleportDestination;
    }

    public void setTeleportDestination(TeleportDestination teleportDestination, boolean once) {
        this.teleportDestination = null;
        this.teleportId = null;
        this.once = once;
        if (teleportDestination != null) {
            TeleportDestinations destinations = TeleportDestinations.getDestinations(this.func_145831_w());
            Integer id = destinations.getIdForCoordinate(new GlobalCoordinate(teleportDestination.getCoordinate(), teleportDestination.getDimension()));
            if (id == null) {
                this.teleportDestination = teleportDestination;
            } else {
                this.teleportId = id;
            }
        }
        this.markDirtyClient();
    }

    private void consumeIdlePower() {
        if (TeleportConfiguration.rfMatterIdleTick > 0 && this.teleportingPlayer == null) {
            if (this.getEnergyStored() >= TeleportConfiguration.rfMatterIdleTick) {
                this.consumeEnergy(TeleportConfiguration.rfMatterIdleTick);
            } else {
                this.setTeleportDestination(null, false);
            }
        }
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        if (this.isDialed()) {
            this.consumeIdlePower();
            --this.checkReceiverStatusCounter;
            if (this.checkReceiverStatusCounter <= 0) {
                this.checkReceiverStatusCounter = 20;
                int newstatus = DialingDeviceTileEntity.isDestinationAnalyzerAvailable(this.func_145831_w(), this.func_174877_v()) ? this.checkReceiverStatus() : 0;
                if (newstatus != this.status) {
                    this.status = newstatus;
                    this.markDirtyClient();
                }
            }
        }
        if (this.isCoolingDown()) {
            return;
        }
        if (this.teleportingPlayer == null) {
            if (this.isDestinationValid()) {
                this.searchForNearestPlayer();
            }
        } else if (this.teleportDestination == null && this.teleportId == null) {
            EntityPlayer player = this.func_145831_w().func_72924_a(this.teleportingPlayer);
            if (player != null) {
                Logging.warn((EntityPlayer)player, (String)"The destination vanished! Aborting.");
            }
            this.clearTeleport(80);
        } else if (this.isPlayerOutsideBeam()) {
            this.clearTeleport(80);
        } else {
            int rf = this.rfPerTick;
            if (this.getEnergyStored() < rf) {
                this.handleEnergyShortage();
            } else {
                this.func_70296_d();
                this.consumeEnergy(rf);
                ++this.goodTicks;
                --this.teleportTimer;
                if (this.teleportTimer <= 0) {
                    this.performTeleport();
                }
            }
        }
    }

    private int checkReceiverStatus() {
        TileEntity tileEntity;
        BlockPos c;
        boolean exists;
        TeleportDestination destination = this.getTeleportDestination();
        if (destination == null) {
            return 1;
        }
        int dimension = destination.getDimension();
        WorldServer w = DimensionManager.getWorld((int)dimension);
        if (w == null) {
            if (TeleportConfiguration.matterTransmitterLoadWorld == -1) {
                return 2;
            }
            w = this.func_145831_w().func_73046_m().func_71218_a(dimension);
            this.checkReceiverStatusCounter = TeleportConfiguration.matterTransmitterLoadWorld;
        }
        if (!(exists = RFToolsTools.chunkLoaded((World)w, c = destination.getCoordinate()))) {
            if (TeleportConfiguration.matterTransmitterLoadChunk == -1) {
                return 2;
            }
            this.checkReceiverStatusCounter = TeleportConfiguration.matterTransmitterLoadChunk;
        }
        if (!((tileEntity = w.func_175625_s(c)) instanceof MatterReceiverTileEntity)) {
            return 1;
        }
        MatterReceiverTileEntity matterReceiverTileEntity = (MatterReceiverTileEntity)tileEntity;
        int status = matterReceiverTileEntity.checkStatus();
        return status == 0 ? 0 : 1;
    }

    private void clearTeleport(int cooldown) {
        this.func_70296_d();
        TeleportationTools.applyBadEffectIfNeeded(this.func_145831_w().func_72924_a(this.teleportingPlayer), 0, this.badTicks, this.totalTicks, false);
        this.cooldownTimer = cooldown;
        this.teleportingPlayer = null;
    }

    private boolean isDestinationValid() {
        return this.teleportId != null || this.teleportDestination != null && this.teleportDestination.isValid();
    }

    private boolean isCoolingDown() {
        this.func_70296_d();
        --this.cooldownTimer;
        if (this.cooldownTimer > 0) {
            return true;
        }
        this.cooldownTimer = 0;
        return false;
    }

    private void searchForNearestPlayer() {
        List l;
        Entity nearestPlayer;
        if (this.beamBox == null) {
            int xCoord = this.func_174877_v().func_177958_n();
            int yCoord = this.func_174877_v().func_177956_o();
            int zCoord = this.func_174877_v().func_177952_p();
            this.beamBox = new AxisAlignedBB((double)xCoord, (double)(yCoord + 1), (double)zCoord, (double)(xCoord + 1), (double)(yCoord + 3), (double)(zCoord + 1));
        }
        if ((nearestPlayer = this.findNearestPlayer(l = this.func_145831_w().func_72872_a(EntityPlayer.class, this.beamBox))) == null) {
            this.cooldownTimer = 5;
            return;
        }
        AxisAlignedBB playerBB = nearestPlayer.func_174813_aQ();
        if (playerBB == null) {
            this.cooldownTimer = 5;
            return;
        }
        if (playerBB.func_72326_a(this.beamBox)) {
            this.startTeleportation(nearestPlayer);
        } else {
            this.cooldownTimer = 5;
        }
    }

    private Entity findNearestPlayer(List<Entity> l) {
        Entity nearestPlayer = null;
        double dmax = Double.MAX_VALUE;
        for (Entity entity : l) {
            double d1;
            EntityPlayer entityPlayer;
            if (!(entity instanceof EntityPlayer) || (entityPlayer = (EntityPlayer)entity).func_184218_aH() || entityPlayer.func_184207_aI() || entityPlayer.func_70005_c_() == null || this.isPrivateAccess() && !this.allowedPlayers.contains(entityPlayer.func_70005_c_()) || !((d1 = entity.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 1.5, (double)this.func_174877_v().func_177952_p() + 0.5)) <= dmax)) continue;
            nearestPlayer = entity;
            dmax = d1;
        }
        return nearestPlayer;
    }

    private void performTeleport() {
        boolean boostNeeded;
        EntityPlayer player;
        boolean boosted;
        if (!this.isDestinationStillValid()) {
            EntityPlayer player2 = this.func_145831_w().func_72924_a(this.teleportingPlayer);
            if (player2 != null) {
                TeleportationTools.applyBadEffectIfNeeded(player2, 10, this.badTicks, this.totalTicks, false);
                Logging.warn((EntityPlayer)player2, (String)"Missing destination!");
            }
            this.clearTeleport(200);
            return;
        }
        TeleportDestination dest = this.getTeleportDestination();
        if (this.once) {
            this.setTeleportDestination(null, false);
        }
        if ((boosted = DialingDeviceTileEntity.isMatterBoosterAvailable(this.func_145831_w(), this.func_174877_v())) && this.getEnergyStored() < TeleportConfiguration.rfBoostedTeleport) {
            boosted = false;
        }
        if ((player = this.func_145831_w().func_72924_a(this.teleportingPlayer)) != null && (boostNeeded = TeleportationTools.performTeleport(player, dest, this.badTicks, this.totalTicks, boosted))) {
            this.consumeEnergy(TeleportConfiguration.rfBoostedTeleport);
        }
        this.teleportingPlayer = null;
    }

    private boolean isDestinationStillValid() {
        TeleportDestination dest = this.getTeleportDestination();
        return TeleportDestinations.getDestinations(this.func_145831_w()).isDestinationValid(dest);
    }

    private void handleEnergyShortage() {
        this.func_70296_d();
        ++this.badTicks;
        if (TeleportationTools.mustInterrupt(this.badTicks, this.totalTicks)) {
            EntityPlayer player = this.func_145831_w().func_72924_a(this.teleportingPlayer);
            if (player != null) {
                Logging.warn((EntityPlayer)player, (String)"Power failure during transit!");
            }
            this.clearTeleport(200);
        }
    }

    private boolean isPlayerOutsideBeam() {
        EntityPlayer player = this.func_145831_w().func_72924_a(this.teleportingPlayer);
        if (player == null) {
            return true;
        }
        AxisAlignedBB playerBB = player.func_174813_aQ();
        if (playerBB == null) {
            return true;
        }
        if (!playerBB.func_72326_a(this.beamBox)) {
            Logging.message((EntityPlayer)player, (String)"Teleportation was interrupted!");
            return true;
        }
        return false;
    }

    public void startTeleportation(Entity entity) {
        if (this.cooldownTimer > 0) {
            return;
        }
        if (this.teleportingPlayer != null) {
            return;
        }
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (player.func_184218_aH() || player.func_184207_aI()) {
            this.cooldownTimer = 80;
            return;
        }
        TeleportDestination dest = this.teleportDestination;
        if (this.teleportId != null) {
            dest = this.getTeleportDestination();
        }
        if (dest != null && dest.isValid()) {
            int dstId;
            int cost = TeleportationTools.calculateRFCost(this.func_145831_w(), this.func_174877_v(), dest);
            cost = (int)((float)cost * (4.0f - this.getInfusedFactor()) / 4.0f);
            if (this.getEnergyStored() < cost) {
                Logging.warn((EntityPlayer)player, (String)"Not enough power to start the teleport!");
                this.cooldownTimer = 80;
                return;
            }
            int srcId = this.func_145831_w().field_73011_w.getDimension();
            if (!TeleportationTools.checkValidTeleport(player, srcId, dstId = dest.getDimension())) {
                this.cooldownTimer = 80;
                return;
            }
            Logging.message((EntityPlayer)player, (String)"Start teleportation...");
            this.teleportingPlayer = player.func_70005_c_();
            this.teleportTimer = TeleportationTools.calculateTime(this.func_145831_w(), this.func_174877_v(), dest);
            this.teleportTimer = (int)((float)this.teleportTimer * (1.2f - this.getInfusedFactor()) / 1.2f);
            int rf = TeleportConfiguration.rfTeleportPerTick;
            rf = (int)((float)rf * (4.0f - this.getInfusedFactor()) / 4.0f);
            int totalRfUsed = cost + rf * (this.teleportTimer + 1);
            this.rfPerTick = totalRfUsed / (this.teleportTimer + 1);
            this.totalTicks = this.teleportTimer;
            this.goodTicks = 0;
            this.badTicks = 0;
        } else {
            Logging.warn((EntityPlayer)player, (String)"Something is wrong with the destination!");
        }
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SETNAME.equals(command)) {
            this.setName(args.get("name").getString());
            return true;
        }
        if (CMD_SETPRIVATE.equals(command)) {
            this.setPrivateAccess(args.get("private").getBoolean());
            return true;
        }
        if (CMD_SETBEAM.equals(command)) {
            this.setBeamHidden(args.get("hide").getBoolean());
            return true;
        }
        if (CMD_ADDPLAYER.equals(command)) {
            this.addPlayer(args.get("player").getString());
            return true;
        }
        if (CMD_DELPLAYER.equals(command)) {
            this.delPlayer(args.get("player").getString());
            return true;
        }
        return false;
    }

    @Nonnull
    public <T> List<T> executeWithResultList(String command, Map<String, Argument> args, Type<T> type) {
        List rc = super.executeWithResultList(command, args, type);
        if (!rc.isEmpty()) {
            return rc;
        }
        if ("getPlayers".equals(command)) {
            return type.convert(this.getAllowedPlayers());
        }
        return Collections.emptyList();
    }

    public <T> boolean execute(String command, List<T> list, Type<T> type) {
        boolean rc = super.execute(command, list, type);
        if (rc) {
            return true;
        }
        if ("getPlayers".equals(command)) {
            GuiMatterTransmitter.storeAllowedPlayersForClient(Type.STRING.convert(list));
            return true;
        }
        return false;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v(), this.func_174877_v().func_177982_a(1, 4, 1));
    }
}

