/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.teleporter;

import mcjty.lib.container.GenericItemBlock;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.TeleportationTools;
import mcjty.rftools.blocks.teleporter.MatterReceiverTileEntity;
import mcjty.rftools.blocks.teleporter.MatterTransmitterTileEntity;
import mcjty.rftools.blocks.teleporter.TeleportDestination;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class SimpleDialerItemBlock
extends GenericItemBlock {
    public SimpleDialerItemBlock(Block block) {
        super(block);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        TileEntity te = world.func_175625_s(pos);
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if (te instanceof MatterTransmitterTileEntity) {
            if (!world.field_72995_K) {
                MatterTransmitterTileEntity matterTransmitterTileEntity = (MatterTransmitterTileEntity)te;
                if (!matterTransmitterTileEntity.checkAccess(player.func_70005_c_())) {
                    Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "You have no access to this matter transmitter!"));
                    return EnumActionResult.FAIL;
                }
                tagCompound.func_74768_a("transX", matterTransmitterTileEntity.func_174877_v().func_177958_n());
                tagCompound.func_74768_a("transY", matterTransmitterTileEntity.func_174877_v().func_177956_o());
                tagCompound.func_74768_a("transZ", matterTransmitterTileEntity.func_174877_v().func_177952_p());
                tagCompound.func_74768_a("transDim", world.field_73011_w.getDimension());
                if (matterTransmitterTileEntity.isDialed()) {
                    Integer id = matterTransmitterTileEntity.getTeleportId();
                    boolean access = this.checkReceiverAccess(player, world, id);
                    if (!access) {
                        Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "You have no access to the matter receiver!"));
                        return EnumActionResult.FAIL;
                    }
                    tagCompound.func_74768_a("receiver", id.intValue());
                    Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "Receiver set!"));
                }
                Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "Transmitter set!"));
            }
        } else if (te instanceof MatterReceiverTileEntity) {
            if (!world.field_72995_K) {
                MatterReceiverTileEntity matterReceiverTileEntity = (MatterReceiverTileEntity)te;
                Integer id = matterReceiverTileEntity.getOrCalculateID();
                boolean access = this.checkReceiverAccess(player, world, id);
                if (!access) {
                    Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "You have no access to this matter receiver!"));
                    return EnumActionResult.FAIL;
                }
                tagCompound.func_74768_a("receiver", id.intValue());
                Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "Receiver set!"));
            }
        } else {
            return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
        }
        stack.func_77982_d(tagCompound);
        return EnumActionResult.SUCCESS;
    }

    private boolean checkReceiverAccess(EntityPlayer player, World world, Integer id) {
        MatterReceiverTileEntity matterReceiverTileEntity;
        TileEntity recTe;
        World worldForDimension;
        TeleportDestination destination;
        boolean access = true;
        TeleportDestinations destinations = TeleportDestinations.getDestinations(world);
        GlobalCoordinate coordinate = destinations.getCoordinateForId(id);
        if (coordinate != null && (destination = destinations.getDestination(coordinate)) != null && (worldForDimension = TeleportationTools.getWorldForDimension((int)destination.getDimension())) != null && (recTe = worldForDimension.func_175625_s(destination.getCoordinate())) instanceof MatterReceiverTileEntity && !(matterReceiverTileEntity = (MatterReceiverTileEntity)recTe).checkAccess(player.func_70005_c_())) {
            access = false;
        }
        return access;
    }
}

