/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.teleporter;

import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.SoundTools;
import mcjty.rftools.ModSounds;
import mcjty.rftools.blocks.environmental.NoTeleportAreaManager;
import mcjty.rftools.blocks.teleporter.DialingDeviceTileEntity;
import mcjty.rftools.blocks.teleporter.MatterReceiverTileEntity;
import mcjty.rftools.blocks.teleporter.MatterTransmitterTileEntity;
import mcjty.rftools.blocks.teleporter.TeleportConfiguration;
import mcjty.rftools.blocks.teleporter.TeleportDestination;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class TeleportationTools {
    public static final int STATUS_OK = 0;
    public static final int STATUS_WARN = 1;
    public static final int STATUS_UNKNOWN = 2;
    public static Potion confusion;
    public static Potion harm;
    public static Potion wither;

    public static void getPotions() {
        if (confusion == null) {
            confusion = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation("nausea"));
            harm = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation("instant_damage"));
            wither = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation("wither"));
        }
    }

    public static void applyEffectForSeverity(EntityPlayer player, int severity, boolean boostNeeded) {
        TeleportationTools.getPotions();
        switch (severity) {
            case 1: {
                if (!boostNeeded) break;
                player.func_70690_d(new PotionEffect(confusion, 100));
                player.func_70690_d(new PotionEffect(harm, 5));
                break;
            }
            case 2: {
                player.func_70690_d(new PotionEffect(harm, 100));
                break;
            }
            case 3: {
                player.func_70690_d(new PotionEffect(harm, 100));
                player.func_70097_a(DamageSource.field_76377_j, 0.5f);
                break;
            }
            case 4: {
                player.func_70690_d(new PotionEffect(harm, 200));
                player.func_70097_a(DamageSource.field_76377_j, 0.5f);
                break;
            }
            case 5: {
                player.func_70690_d(new PotionEffect(harm, 200));
                player.func_70097_a(DamageSource.field_76377_j, 1.0f);
                break;
            }
            case 6: {
                player.func_70690_d(new PotionEffect(harm, 300));
                player.func_70097_a(DamageSource.field_76377_j, 1.0f);
                break;
            }
            case 7: {
                player.func_70690_d(new PotionEffect(harm, 300));
                player.func_70690_d(new PotionEffect(wither, 200));
                player.func_70097_a(DamageSource.field_76377_j, 2.0f);
                break;
            }
            case 8: {
                player.func_70690_d(new PotionEffect(harm, 400));
                player.func_70690_d(new PotionEffect(wither, 300));
                player.func_70097_a(DamageSource.field_76377_j, 2.0f);
                break;
            }
            case 9: {
                player.func_70690_d(new PotionEffect(harm, 400));
                player.func_70690_d(new PotionEffect(wither, 400));
                player.func_70097_a(DamageSource.field_76377_j, 3.0f);
                break;
            }
            case 10: {
                player.func_70690_d(new PotionEffect(harm, 500));
                player.func_70690_d(new PotionEffect(wither, 500));
                player.func_70097_a(DamageSource.field_76377_j, 3.0f);
            }
        }
    }

    public static int calculateRFCost(World world, BlockPos c1, TeleportDestination teleportDestination) {
        if (world.field_73011_w.getDimension() != teleportDestination.getDimension()) {
            return TeleportConfiguration.rfStartTeleportBaseDim;
        }
        BlockPos c2 = teleportDestination.getCoordinate();
        double dist = new Vec3d((double)c1.func_177958_n(), (double)c1.func_177956_o(), (double)c1.func_177952_p()).func_72438_d(new Vec3d((double)c2.func_177958_n(), (double)c2.func_177956_o(), (double)c2.func_177952_p()));
        int rf = TeleportConfiguration.rfStartTeleportBaseLocal + (int)((double)TeleportConfiguration.rfStartTeleportDist * dist);
        if (rf > TeleportConfiguration.rfStartTeleportBaseDim) {
            rf = TeleportConfiguration.rfStartTeleportBaseDim;
        }
        return rf;
    }

    public static int calculateTime(World world, BlockPos c1, TeleportDestination teleportDestination) {
        if (world.field_73011_w.getDimension() != teleportDestination.getDimension()) {
            return TeleportConfiguration.timeTeleportBaseDim;
        }
        BlockPos c2 = teleportDestination.getCoordinate();
        double dist = new Vec3d((double)c1.func_177958_n(), (double)c1.func_177956_o(), (double)c1.func_177952_p()).func_72438_d(new Vec3d((double)c2.func_177958_n(), (double)c2.func_177956_o(), (double)c2.func_177952_p()));
        int time = TeleportConfiguration.timeTeleportBaseLocal + (int)((double)TeleportConfiguration.timeTeleportDist * dist / 1000.0);
        if (time > TeleportConfiguration.timeTeleportBaseDim) {
            time = TeleportConfiguration.timeTeleportBaseDim;
        }
        return time;
    }

    public static boolean performTeleport(EntityPlayer player, TeleportDestination dest, int bad, int good, boolean boosted) {
        BlockPos c = dest.getCoordinate();
        BlockPos old = new BlockPos((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        int oldId = player.func_130014_f_().field_73011_w.getDimension();
        if (!TeleportationTools.allowTeleport((Entity)player, oldId, old, dest.getDimension(), dest.getCoordinate())) {
            return false;
        }
        if (oldId != dest.getDimension()) {
            mcjty.lib.varia.TeleportationTools.teleportToDimension((EntityPlayer)player, (int)dest.getDimension(), (double)((double)c.func_177958_n() + 0.5), (double)((double)c.func_177956_o() + 1.5), (double)((double)c.func_177952_p() + 0.5));
        } else {
            player.func_70634_a((double)c.func_177958_n() + 0.5, (double)(c.func_177956_o() + 1), (double)c.func_177952_p() + 0.5);
        }
        if (TeleportConfiguration.whooshMessage) {
            Logging.message((EntityPlayer)player, (String)"Whoosh!");
        }
        boolean boostNeeded = false;
        int severity = TeleportationTools.consumeReceiverEnergy(player, dest.getCoordinate(), dest.getDimension());
        if (severity > 0 && boosted) {
            boostNeeded = true;
            severity = 1;
        }
        if ((severity = TeleportationTools.applyBadEffectIfNeeded(player, severity, bad, good, boostNeeded)) <= 0 && (double)TeleportConfiguration.teleportVolume >= 0.01) {
            SoundTools.playSound((World)player.func_130014_f_(), (SoundEvent)ModSounds.whoosh, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (double)TeleportConfiguration.teleportVolume, (double)1.0);
        }
        if (TeleportConfiguration.logTeleportUsages) {
            Logging.log((String)("Teleport: Player " + player.func_70005_c_() + " from " + old + " (dim " + oldId + ") to " + dest.getCoordinate() + " (dim " + dest.getDimension() + ") with severity " + severity));
        }
        return boostNeeded;
    }

    public static int dial(World worldObj, DialingDeviceTileEntity dialingDeviceTileEntity, String player, BlockPos transmitter, int transDim, BlockPos coordinate, int dimension, boolean once) {
        World transWorld = mcjty.lib.varia.TeleportationTools.getWorldForDimension((int)transDim);
        if (transWorld == null) {
            return 256;
        }
        MatterTransmitterTileEntity transmitterTileEntity = (MatterTransmitterTileEntity)transWorld.func_175625_s(transmitter);
        if (transmitterTileEntity == null) {
            return 1024;
        }
        if (player != null && !transmitterTileEntity.checkAccess(player)) {
            return 32;
        }
        if (coordinate == null) {
            transmitterTileEntity.setTeleportDestination(null, false);
            return 128;
        }
        TeleportDestination teleportDestination = TeleportationTools.findDestination(worldObj, coordinate, dimension);
        if (teleportDestination == null) {
            return 4;
        }
        BlockPos c = teleportDestination.getCoordinate();
        World recWorld = mcjty.lib.varia.TeleportationTools.getWorldForDimension((int)teleportDestination.getDimension());
        if (recWorld == null && (recWorld = worldObj.func_73046_m().func_71218_a(teleportDestination.getDimension())) == null) {
            return 4;
        }
        TileEntity tileEntity = recWorld.func_175625_s(c);
        if (!(tileEntity instanceof MatterReceiverTileEntity)) {
            return 4;
        }
        MatterReceiverTileEntity matterReceiverTileEntity = (MatterReceiverTileEntity)tileEntity;
        matterReceiverTileEntity.updateDestination();
        if (player != null && !matterReceiverTileEntity.checkAccess(player)) {
            return 64;
        }
        if (!TeleportationTools.checkBeam(transmitter, transWorld, 1, 4, 2)) {
            return 2;
        }
        if (dialingDeviceTileEntity != null) {
            int cost = TeleportConfiguration.rfPerDial;
            cost = (int)((float)cost * (2.0f - dialingDeviceTileEntity.getInfusedFactor()) / 2.0f);
            if (dialingDeviceTileEntity.getEnergyStored() < cost) {
                return 8;
            }
            dialingDeviceTileEntity.consumeEnergy(cost);
        }
        transmitterTileEntity.setTeleportDestination(teleportDestination, once);
        return 0;
    }

    private static int consumeReceiverEnergy(EntityPlayer player, BlockPos c, int dimension) {
        WorldServer world = DimensionManager.getWorld((int)dimension);
        TileEntity te = world.func_175625_s(c);
        if (!(te instanceof MatterReceiverTileEntity)) {
            Logging.warn((EntityPlayer)player, (String)"Something went wrong with the destination!");
            return 0;
        }
        MatterReceiverTileEntity matterReceiverTileEntity = (MatterReceiverTileEntity)te;
        int rf = TeleportConfiguration.rfPerTeleportReceiver;
        if ((rf = (int)((float)rf * (2.0f - matterReceiverTileEntity.getInfusedFactor()) / 2.0f)) <= 0) {
            return 0;
        }
        int extracted = rf;
        if (rf > matterReceiverTileEntity.getEnergyStored()) {
            extracted = matterReceiverTileEntity.getEnergyStored();
        }
        matterReceiverTileEntity.consumeEnergy(rf);
        int remainingRf = matterReceiverTileEntity.getEnergyStored();
        if (remainingRf <= 1) {
            Logging.warn((EntityPlayer)player, (String)"The matter receiver has run out of power!");
        } else if (remainingRf < TeleportConfiguration.RECEIVER_MAXENERGY / 10) {
            Logging.warn((EntityPlayer)player, (String)"The matter receiver is getting very low on power!");
        } else if (remainingRf < TeleportConfiguration.RECEIVER_MAXENERGY / 5) {
            Logging.warn((EntityPlayer)player, (String)"The matter receiver is getting low on power!");
        }
        return 10 - extracted * 10 / rf;
    }

    public static int calculateSeverity(int bad, int total) {
        if (total == 0) {
            total = 1;
        }
        int severity = bad * 10 / total;
        if (TeleportationTools.mustInterrupt(bad, total)) {
            severity += 2;
        }
        if (severity > 10) {
            severity = 10;
        }
        return severity;
    }

    public static int applyBadEffectIfNeeded(EntityPlayer player, int severity, int bad, int total, boolean boostNeeded) {
        if (player == null) {
            return 0;
        }
        if ((severity += TeleportationTools.calculateSeverity(bad, total)) > 10) {
            severity = 10;
        }
        if (severity <= 0) {
            return 0;
        }
        if ((double)TeleportConfiguration.teleportErrorVolume >= 0.01) {
            SoundTools.playSound((World)player.func_130014_f_(), (SoundEvent)ModSounds.error, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (double)TeleportConfiguration.teleportVolume, (double)1.0);
        }
        TeleportationTools.applyEffectForSeverity(player, severity, boostNeeded);
        return severity;
    }

    public static boolean mustInterrupt(int bad, int total) {
        return bad > total / 2;
    }

    public static boolean allowTeleport(Entity entity, int sourceDim, BlockPos source, int destDim, BlockPos dest) {
        if (NoTeleportAreaManager.isTeleportPrevented(entity, new GlobalCoordinate(source, sourceDim))) {
            return false;
        }
        return !NoTeleportAreaManager.isTeleportPrevented(entity, new GlobalCoordinate(dest, destDim));
    }

    public static TeleportDestination findDestination(World worldObj, BlockPos coordinate, int dimension) {
        TeleportDestinations destinations = TeleportDestinations.getDestinations(worldObj);
        return destinations.getDestination(coordinate, dimension);
    }

    public static boolean checkBeam(BlockPos c, World world, int dy1, int dy2, int errory) {
        for (int dy = dy1; dy <= dy2; ++dy) {
            BlockPos pos = new BlockPos(c.func_177958_n(), c.func_177956_o() + dy, c.func_177952_p());
            IBlockState state = world.func_180495_p(pos);
            Block b = state.func_177230_c();
            if (b.isAir(state, (IBlockAccess)world, pos)) continue;
            if (dy > errory) break;
            return false;
        }
        return true;
    }

    public static boolean checkValidTeleport(EntityPlayer player, int srcId, int dstId) {
        if (TeleportConfiguration.preventInterdimensionalTeleports && srcId == dstId) {
            Logging.warn((EntityPlayer)player, (String)"Teleportation in the same dimension is not allowed!");
            return false;
        }
        if (TeleportConfiguration.getBlacklistedTeleportationDestinations().contains(dstId)) {
            Logging.warn((EntityPlayer)player, (String)"Teleportation to that dimension is not allowed!");
            return false;
        }
        if (TeleportConfiguration.getBlacklistedTeleportationSources().contains(srcId)) {
            Logging.warn((EntityPlayer)player, (String)"Teleportation from this dimension is not allowed!");
            return false;
        }
        return true;
    }
}

