/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.integration.computers;

import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.prefab.AbstractManagedEnvironment;
import mcjty.lib.integration.computers.AbstractOCDriver;
import mcjty.rftools.blocks.teleporter.MatterTransmitterTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MatterTransmitterDriver {

    public static class OCDriver
    extends AbstractOCDriver {
        public OCDriver() {
            super("rftools_matter_transmitter", MatterTransmitterTileEntity.class);
        }

        public AbstractManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing side, TileEntity tile) {
            return new InternalManagedEnvironment((MatterTransmitterTileEntity)tile);
        }

        public static class InternalManagedEnvironment
        extends AbstractOCDriver.InternalManagedEnvironment<MatterTransmitterTileEntity> {
            public InternalManagedEnvironment(MatterTransmitterTileEntity tile) {
                super((Object)tile, "rftools_matter_transmitter");
            }

            @Callback(doc="function():number; Get the currently stored energy")
            public Object[] getEnergy(Context c, Arguments a) {
                return new Object[]{((MatterTransmitterTileEntity)((Object)this.tile)).getEnergyStored()};
            }

            @Callback(doc="function():number; Get the maximum stored energy")
            public Object[] getMaxEnergy(Context c, Arguments a) {
                return new Object[]{((MatterTransmitterTileEntity)((Object)this.tile)).getMaxEnergyStored()};
            }

            @Callback(doc="function():string; Get the current name")
            public Object[] getName(Context c, Arguments a) {
                return new Object[]{((MatterTransmitterTileEntity)((Object)this.tile)).getName()};
            }

            @Callback(doc="function(name:string); Set the current name")
            public Object[] setName(Context c, Arguments a) {
                String name = a.checkString(0);
                ((MatterTransmitterTileEntity)((Object)this.tile)).setName(name);
                return new Object[0];
            }

            @Callback(doc="function(hide:bool); Set whether the beam should be hidden or not")
            public Object[] hideBeam(Context c, Arguments a) {
                ((MatterTransmitterTileEntity)((Object)this.tile)).setBeamHidden(a.checkBoolean(0));
                return new Object[0];
            }

            @Callback(doc="function():bool; Returns whether the beam is hidden or not")
            public Object[] isBeamHidden(Context c, Arguments a) {
                return new Object[]{((MatterTransmitterTileEntity)((Object)this.tile)).isBeamHidden()};
            }

            @Callback(doc="function():bool; Returns whether a destination is dialed or not")
            public Object[] isDialed(Context c, Arguments a) {
                return new Object[]{((MatterTransmitterTileEntity)((Object)this.tile)).isDialed()};
            }

            public int priority() {
                return 4;
            }
        }
    }
}

