/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.builder;

import java.awt.Rectangle;
import java.io.IOException;
import java.util.List;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.gui.RenderHelper;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.network.Argument;
import mcjty.rftools.blocks.builder.BuilderConfiguration;
import mcjty.rftools.blocks.shaper.ScannerConfiguration;
import mcjty.rftools.items.builder.PacketUpdateNBTItemInventoryShape;
import mcjty.rftools.items.builder.ShapeCardItem;
import mcjty.rftools.items.builder.ShapeCardType;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.shapes.IShapeParentGui;
import mcjty.rftools.shapes.PacketUpdateNBTShapeCard;
import mcjty.rftools.shapes.Shape;
import mcjty.rftools.shapes.ShapeID;
import mcjty.rftools.shapes.ShapeRenderer;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiShapeCard
extends GuiScreen
implements IShapeParentGui {
    protected int xSize = 360;
    protected int ySize = 160;
    private int guiLeft;
    private int guiTop;
    private boolean isQuarryCard;
    private ChoiceLabel shapeLabel;
    private ChoiceLabel solidLabel;
    private TextField dimX;
    private TextField dimY;
    private TextField dimZ;
    private TextField offsetX;
    private TextField offsetY;
    private TextField offsetZ;
    private Window window;
    private Label blocksLabel;
    private Panel voidPanel;
    private ToggleButton stone;
    private ToggleButton cobble;
    private ToggleButton dirt;
    private ToggleButton gravel;
    private ToggleButton sand;
    private ToggleButton netherrack;
    private ToggleButton endstone;
    private ToggleButton oredict;
    public final boolean fromTE;
    public static BlockPos fromTEPos = null;
    public static int fromTEStackSlot = 0;
    public static GuiScreen returnGui = null;
    private ShapeID shapeID = null;
    private ShapeRenderer shapeRenderer = null;
    private static int updateCounter = 20;

    public GuiShapeCard(boolean fromTE) {
        this.fromTE = fromTE;
    }

    private ShapeRenderer getShapeRenderer() {
        if (this.shapeID == null) {
            this.shapeID = this.getShapeID();
        } else if (!this.shapeID.equals(this.getShapeID())) {
            this.shapeID = this.getShapeID();
            this.shapeRenderer = null;
        }
        if (this.shapeRenderer == null) {
            this.shapeRenderer = new ShapeRenderer(this.shapeID);
            this.shapeRenderer.initView(this.getPreviewLeft(), this.guiTop);
        }
        return this.shapeRenderer;
    }

    private ShapeID getShapeID() {
        ItemStack stackToEdit = this.getStackToEdit();
        return new ShapeID(0, null, ShapeCardItem.getScanId(stackToEdit), false, ShapeCardItem.isSolid(stackToEdit));
    }

    public boolean func_73868_f() {
        return false;
    }

    private ItemStack getStackToEdit() {
        if (this.fromTE) {
            TileEntity te = this.field_146297_k.field_71441_e.func_175625_s(fromTEPos);
            if (te instanceof IInventory) {
                return ((IInventory)te).func_70301_a(fromTEStackSlot);
            }
            return ItemStack.field_190927_a;
        }
        return this.field_146297_k.field_71439_g.func_184586_b(EnumHand.MAIN_HAND);
    }

    @Override
    public int getPreviewLeft() {
        return this.guiLeft + 104;
    }

    @Override
    public int getPreviewTop() {
        return this.guiTop - 5 + (this.isQuarryCard ? 0 : 10);
    }

    public void func_73866_w_() {
        Panel toplevel;
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        ItemStack heldItem = this.getStackToEdit();
        if (heldItem.func_190926_b()) {
            return;
        }
        this.isQuarryCard = ShapeCardType.fromDamage(heldItem.func_77952_i()).isQuarry();
        if (this.isQuarryCard) {
            this.ySize = 188;
        }
        this.getShapeRenderer().initView(this.getPreviewLeft(), this.guiTop);
        this.shapeLabel = ((ChoiceLabel)((ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).setDesiredWidth(100)).setDesiredHeight(16)).addChoices(new String[]{Shape.SHAPE_BOX.getDescription(), Shape.SHAPE_TOPDOME.getDescription(), Shape.SHAPE_BOTTOMDOME.getDescription(), Shape.SHAPE_SPHERE.getDescription(), Shape.SHAPE_CYLINDER.getDescription(), Shape.SHAPE_CAPPEDCYLINDER.getDescription(), Shape.SHAPE_PRISM.getDescription(), Shape.SHAPE_TORUS.getDescription(), Shape.SHAPE_CONE.getDescription(), Shape.SHAPE_HEART.getDescription(), Shape.SHAPE_COMPOSITION.getDescription(), Shape.SHAPE_SCAN.getDescription()}).addChoiceEvent((parent, newChoice) -> this.updateSettings());
        this.solidLabel = ((ChoiceLabel)((ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).setDesiredWidth(50)).setDesiredHeight(16)).addChoices(new String[]{"Hollow", "Solid"}).addChoiceEvent((parent, newChoice) -> this.updateSettings());
        Panel shapePanel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout()).addChild((Widget)this.shapeLabel)).addChild((Widget)this.solidLabel);
        Shape shape = ShapeCardItem.getShape(heldItem);
        this.shapeLabel.setChoice(shape.getDescription());
        boolean solid = ShapeCardItem.isSolid(heldItem);
        this.solidLabel.setChoice(solid ? "Solid" : "Hollow");
        this.blocksLabel = new Label(this.field_146297_k, (Gui)this).setText("# ").setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT);
        this.blocksLabel.setDesiredWidth(100).setDesiredHeight(16);
        Panel modePanel = (Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new VerticalLayout()).setDesiredWidth(170)).addChild((Widget)shapePanel)).addChild((Widget)this.blocksLabel);
        BlockPos dim = ShapeCardItem.getDimension(heldItem);
        BlockPos offset = ShapeCardItem.getOffset(heldItem);
        this.dimX = new TextField(this.field_146297_k, (Gui)this).addTextEvent((parent, newText) -> {
            if (this.isTorus()) {
                this.dimZ.setText(newText);
            }
            this.updateSettings();
        }).setText(String.valueOf(dim.func_177958_n()));
        this.dimY = new TextField(this.field_146297_k, (Gui)this).addTextEvent((parent, newText) -> this.updateSettings()).setText(String.valueOf(dim.func_177956_o()));
        this.dimZ = new TextField(this.field_146297_k, (Gui)this).addTextEvent((parent, newText) -> this.updateSettings()).setText(String.valueOf(dim.func_177952_p()));
        Panel dimPanel = (Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout().setHorizontalMargin(0)).addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Dim:").setHorizontalAlignment(HorizontalAlignment.ALIGN_RIGHT).setDesiredWidth(40))).setDesiredHeight(18)).addChild((Widget)this.dimX)).addChild((Widget)this.dimY)).addChild((Widget)this.dimZ);
        this.offsetX = new TextField(this.field_146297_k, (Gui)this).addTextEvent((parent, newText) -> this.updateSettings()).setText(String.valueOf(offset.func_177958_n()));
        this.offsetY = new TextField(this.field_146297_k, (Gui)this).addTextEvent((parent, newText) -> this.updateSettings()).setText(String.valueOf(offset.func_177956_o()));
        this.offsetZ = new TextField(this.field_146297_k, (Gui)this).addTextEvent((parent, newText) -> this.updateSettings()).setText(String.valueOf(offset.func_177952_p()));
        Panel offsetPanel = (Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout().setHorizontalMargin(0)).addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Offset:").setHorizontalAlignment(HorizontalAlignment.ALIGN_RIGHT).setDesiredWidth(40))).setDesiredHeight(18)).addChild((Widget)this.offsetX)).addChild((Widget)this.offsetY)).addChild((Widget)this.offsetZ);
        Panel settingsPanel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((VerticalLayout)((VerticalLayout)new VerticalLayout().setSpacing(1)).setVerticalMargin(1)).setHorizontalMargin(0)).addChild((Widget)dimPanel)).addChild((Widget)offsetPanel);
        int k = (this.field_146294_l - this.xSize) / 2;
        int l = (this.field_146295_m - this.ySize) / 2;
        Panel modeSettingsPanel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new VerticalLayout().setHorizontalMargin(0)).addChild((Widget)modePanel)).addChild((Widget)settingsPanel);
        modeSettingsPanel.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(0, 0, 180, 160));
        if (this.isQuarryCard) {
            this.setupVoidPanel(heldItem);
            toplevel = (Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).setFilledRectThickness(2)).addChild((Widget)modeSettingsPanel)).addChild((Widget)this.voidPanel);
        } else {
            toplevel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).setFilledRectThickness(2)).addChild((Widget)modeSettingsPanel);
        }
        toplevel.setBounds(new Rectangle(k, l, this.xSize, this.ySize));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
    }

    private void setupVoidPanel(ItemStack heldItem) {
        this.voidPanel = (Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout()).setDesiredHeight(26)).setFilledRectThickness(-2)).setFilledBackground(StyleConfig.colorListBackground);
        this.voidPanel.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(5, 155, 350, 26));
        Label label = new Label(this.field_146297_k, (Gui)this).setText("Void:");
        this.stone = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.field_146297_k, (Gui)this).setDesiredWidth(20)).setDesiredHeight(20)).setTooltips(new String[]{"Void stone"})).addButtonEvent(widget -> this.updateVoidSettings());
        this.cobble = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.field_146297_k, (Gui)this).setDesiredWidth(20)).setDesiredHeight(20)).setTooltips(new String[]{"Void cobble"})).addButtonEvent(widget -> this.updateVoidSettings());
        this.dirt = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.field_146297_k, (Gui)this).setDesiredWidth(20)).setDesiredHeight(20)).setTooltips(new String[]{"Void dirt"})).addButtonEvent(widget -> this.updateVoidSettings());
        this.gravel = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.field_146297_k, (Gui)this).setDesiredWidth(20)).setDesiredHeight(20)).setTooltips(new String[]{"Void gravel"})).addButtonEvent(widget -> this.updateVoidSettings());
        this.sand = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.field_146297_k, (Gui)this).setDesiredWidth(20)).setDesiredHeight(20)).setTooltips(new String[]{"Void sand"})).addButtonEvent(widget -> this.updateVoidSettings());
        this.netherrack = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.field_146297_k, (Gui)this).setDesiredWidth(20)).setDesiredHeight(20)).setTooltips(new String[]{"Void netherrack"})).addButtonEvent(widget -> this.updateVoidSettings());
        this.endstone = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.field_146297_k, (Gui)this).setDesiredWidth(20)).setDesiredHeight(20)).setTooltips(new String[]{"Void end stone"})).addButtonEvent(widget -> this.updateVoidSettings());
        this.oredict = ((ToggleButton)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.field_146297_k, (Gui)this).setDesiredWidth(60)).setDesiredHeight(15)).setTooltips(new String[]{"Enable ore dictionary matching"})).setText("Oredict")).setCheckMarker(true).addButtonEvent(widget -> this.updateVoidSettings());
        this.stone.setPressed(ShapeCardItem.isVoiding(heldItem, "stone"));
        this.cobble.setPressed(ShapeCardItem.isVoiding(heldItem, "cobble"));
        this.dirt.setPressed(ShapeCardItem.isVoiding(heldItem, "dirt"));
        this.gravel.setPressed(ShapeCardItem.isVoiding(heldItem, "gravel"));
        this.sand.setPressed(ShapeCardItem.isVoiding(heldItem, "sand"));
        this.netherrack.setPressed(ShapeCardItem.isVoiding(heldItem, "netherrack"));
        this.endstone.setPressed(ShapeCardItem.isVoiding(heldItem, "endstone"));
        this.oredict.setPressed(ShapeCardItem.isOreDictionary(heldItem));
        ((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)this.voidPanel.addChild((Widget)label)).addChild((Widget)this.stone)).addChild((Widget)this.cobble)).addChild((Widget)this.dirt)).addChild((Widget)this.gravel)).addChild((Widget)this.sand)).addChild((Widget)this.netherrack)).addChild((Widget)this.endstone)).addChild((Widget)this.oredict);
    }

    private boolean isTorus() {
        Shape shape = this.getCurrentShape();
        return Shape.SHAPE_TORUS.equals((Object)shape);
    }

    private Shape getCurrentShape() {
        return Shape.getShape(this.shapeLabel.getCurrentChoice());
    }

    private boolean isSolid() {
        return "Solid".equals(this.solidLabel.getCurrentChoice());
    }

    private static int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private void updateSettings() {
        int dx = GuiShapeCard.parseInt(this.dimX.getText());
        int dy = GuiShapeCard.parseInt(this.dimY.getText());
        int dz = GuiShapeCard.parseInt(this.dimZ.getText());
        int max = Math.max(ScannerConfiguration.maxScannerDimension, BuilderConfiguration.maxBuilderDimension);
        if (dx < 0) {
            dx = 0;
        } else if (dx > max) {
            dx = max;
        }
        this.dimX.setText(Integer.toString(dx));
        if (dz < 0) {
            dz = 0;
        } else if (dz > max) {
            dz = max;
        }
        this.dimZ.setText(Integer.toString(dz));
        if (dy < 0) {
            dy = 0;
        } else if (dy > 256) {
            dy = 256;
        }
        this.dimY.setText(Integer.toString(dy));
        if (this.isTorus()) {
            this.dimZ.setText(this.dimX.getText());
        }
        if (this.fromTE) {
            ItemStack stack = this.getStackToEdit();
            if (!stack.func_190926_b()) {
                NBTTagCompound tag = stack.func_77978_p();
                if (tag == null) {
                    tag = new NBTTagCompound();
                }
                ShapeCardItem.setShape(stack, this.getCurrentShape(), this.isSolid());
                ShapeCardItem.setDimension(stack, dx, dy, dz);
                ShapeCardItem.setOffset(stack, GuiShapeCard.parseInt(this.offsetX.getText()), GuiShapeCard.parseInt(this.offsetY.getText()), GuiShapeCard.parseInt(this.offsetZ.getText()));
                RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketUpdateNBTItemInventoryShape(fromTEPos, fromTEStackSlot, tag));
            }
        } else {
            RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketUpdateNBTShapeCard(new Argument("shapenew", this.getCurrentShape().getDescription()), new Argument("solid", this.isSolid()), new Argument("dimX", dx), new Argument("dimY", dy), new Argument("dimZ", dz), new Argument("offsetX", GuiShapeCard.parseInt(this.offsetX.getText())), new Argument("offsetY", GuiShapeCard.parseInt(this.offsetY.getText())), new Argument("offsetZ", GuiShapeCard.parseInt(this.offsetZ.getText()))));
        }
    }

    private void updateVoidSettings() {
        if (this.fromTE) {
            ItemStack stack = this.getStackToEdit();
            if (!stack.func_190926_b()) {
                NBTTagCompound tag = stack.func_77978_p();
                if (tag == null) {
                    tag = new NBTTagCompound();
                }
                tag.func_74757_a("voidstone", this.stone.isPressed());
                tag.func_74757_a("voidcobble", this.cobble.isPressed());
                tag.func_74757_a("voiddirt", this.dirt.isPressed());
                tag.func_74757_a("voidgravel", this.gravel.isPressed());
                tag.func_74757_a("voidsand", this.sand.isPressed());
                tag.func_74757_a("voidnetherrack", this.netherrack.isPressed());
                tag.func_74757_a("voidendstone", this.endstone.isPressed());
                tag.func_74757_a("oredict", this.oredict.isPressed());
                RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketUpdateNBTItemInventoryShape(fromTEPos, fromTEStackSlot, tag));
            }
        } else {
            RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketUpdateNBTShapeCard(new Argument("voidstone", this.stone.isPressed()), new Argument("voidcobble", this.cobble.isPressed()), new Argument("voiddirt", this.dirt.isPressed()), new Argument("voidgravel", this.gravel.isPressed()), new Argument("voidsand", this.sand.isPressed()), new Argument("voidnetherrack", this.netherrack.isPressed()), new Argument("voidendstone", this.endstone.isPressed()), new Argument("oredict", this.oredict.isPressed())));
        }
    }

    protected void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        this.window.mouseClicked(x, y, button);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.window.handleMouseInput();
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        this.getShapeRenderer().handleShapeDragging(x -= this.guiLeft, y -= this.guiTop);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.window.mouseMovedOrUp(mouseX, mouseY, state);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        this.window.keyTyped(typedChar, keyCode);
    }

    public void func_73863_a(int xSize_lo, int ySize_lo, float par3) {
        List tooltips;
        ItemStack stack;
        this.getShapeRenderer().handleMouseWheel();
        super.func_73863_a(xSize_lo, ySize_lo, par3);
        this.dimZ.setEnabled(!this.isTorus());
        if (--updateCounter <= 0) {
            updateCounter = 10;
            int count = this.getShapeRenderer().getCount();
            if (count >= 50000000) {
                this.blocksLabel.setText("#Blocks: ++" + count);
            } else {
                this.blocksLabel.setText("#Blocks: " + count);
            }
        }
        this.window.draw();
        if (this.isQuarryCard) {
            int x = (int)(this.window.getToplevel().getBounds().getX() + this.voidPanel.getBounds().getX()) + 1;
            int y = (int)(this.window.getToplevel().getBounds().getY() + this.voidPanel.getBounds().getY() + this.stone.getBounds().getY()) + 1;
            this.renderVoidBlock(x, y, this.stone, Blocks.field_150348_b);
            this.renderVoidBlock(x, y, this.cobble, Blocks.field_150347_e);
            this.renderVoidBlock(x, y, this.dirt, Blocks.field_150346_d);
            this.renderVoidBlock(x, y, this.gravel, Blocks.field_150351_n);
            this.renderVoidBlock(x, y, this.sand, (Block)Blocks.field_150354_m);
            this.renderVoidBlock(x, y, this.netherrack, Blocks.field_150424_aL);
            this.renderVoidBlock(x, y, this.endstone, Blocks.field_150377_bs);
        }
        if (!(stack = this.getStackToEdit()).func_190926_b()) {
            this.getShapeRenderer().renderShape(this, stack, this.guiLeft, this.guiTop, true, true, true, false);
        }
        if ((tooltips = this.window.getTooltips()) != null) {
            int guiLeft = (this.field_146294_l - this.xSize) / 2;
            int guiTop = (this.field_146295_m - this.ySize) / 2;
            int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            this.drawHoveringText(tooltips, x - guiLeft, y - guiTop, this.field_146297_k.field_71466_p);
        }
    }

    private void renderVoidBlock(int x, int y, ToggleButton button, Block block) {
        RenderHelper.renderObject((Minecraft)Minecraft.func_71410_x(), (int)(x += (int)button.getBounds().getX()), (int)y, (Object)new ItemStack(block), (boolean)button.isPressed());
        if (button.isPressed()) {
            GuiShapeCard.drawLine(x - 1, y - 1, x + 18, y + 18, -65536);
            GuiShapeCard.drawLine(x + 18, y - 1, x - 1, y + 18, -65536);
        }
    }

    private static void drawLine(int x1, int y1, int x2, int y2, int color) {
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179097_i();
        GL11.glLineWidth((float)2.0f);
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
        buffer.func_181662_b((double)x1, (double)y1, 0.0).func_181675_d();
        buffer.func_181662_b((double)x2, (double)y2, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179126_j();
        GlStateManager.func_179084_k();
    }
}

