/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.teleportprobe;

import mcjty.lib.network.Arguments;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.TeleportationTools;
import mcjty.rftools.blocks.teleporter.TeleportDestination;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import mcjty.rftools.items.teleportprobe.AdvancedChargedPorterItem;
import mcjty.rftools.items.teleportprobe.PacketTargetsReady;
import mcjty.rftools.items.teleportprobe.TeleportProbeItem;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PorterTools {
    public static void clearTarget(EntityPlayer player, int index) {
        ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
        if (heldItem.func_190926_b()) {
            return;
        }
        NBTTagCompound tagCompound = heldItem.func_77978_p();
        if (tagCompound == null) {
            return;
        }
        if (tagCompound.func_74764_b("target" + index)) {
            int id = tagCompound.func_74762_e("target" + index);
            if (tagCompound.func_74764_b("target") && tagCompound.func_74762_e("target") == id) {
                tagCompound.func_82580_o("target");
            }
            tagCompound.func_82580_o("target" + index);
        }
    }

    public static void forceTeleport(EntityPlayer player, int dimension, BlockPos pos) {
        boolean probeInOffHand;
        boolean probeInMainHand = !player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() instanceof TeleportProbeItem;
        boolean bl = probeInOffHand = !player.func_184592_cb().func_190926_b() && player.func_184592_cb().func_77973_b() instanceof TeleportProbeItem;
        if (!probeInMainHand && !probeInOffHand) {
            return;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int currentId = player.func_130014_f_().field_73011_w.getDimension();
        if (currentId != dimension) {
            TeleportationTools.teleportToDimension((EntityPlayer)player, (int)dimension, (double)((double)x + 0.5), (double)(y + 1), (double)((double)z + 0.5));
        } else {
            player.func_70634_a((double)x + 0.5, (double)y + 1.5, (double)z + 0.5);
        }
    }

    public static void cycleDestination(EntityPlayer player, boolean next) {
        ItemStack stack = player.func_184614_ca();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof AdvancedChargedPorterItem) {
            int tgt;
            NBTTagCompound tagCompound = stack.func_77978_p();
            if (tagCompound == null) {
                return;
            }
            TeleportDestinations destinations = TeleportDestinations.getDestinations(player.func_130014_f_());
            int curtarget = tagCompound.func_74762_e("target");
            int donext = 0;
            for (int i = 0; i < 16 && (donext = PorterTools.checkTarget(player, tagCompound, destinations, curtarget, donext, tgt = next ? i % 8 : (16 - i) % 8)) != 2; ++i) {
            }
        }
    }

    private static int checkTarget(EntityPlayer playerEntity, NBTTagCompound tagCompound, TeleportDestinations destinations, int curtarget, int donext, int tgt) {
        TeleportDestination destination;
        int target;
        GlobalCoordinate gc;
        if (tagCompound.func_74764_b("target" + tgt) && (gc = destinations.getCoordinateForId(target = tagCompound.func_74762_e("target" + tgt))) != null && (destination = destinations.getDestination(gc)) != null) {
            if (donext == 1) {
                String name = destination.getName() + " (dimension " + destination.getDimension() + ")";
                tagCompound.func_74768_a("target", target);
                TextComponentString component = new TextComponentString(TextFormatting.GREEN + "Target: " + TextFormatting.WHITE + name);
                if (playerEntity != null) {
                    playerEntity.func_146105_b((ITextComponent)component, false);
                }
                donext = 2;
            } else if (target == curtarget) {
                donext = 1;
            }
        }
        return donext;
    }

    public static void returnDestinationInfo(EntityPlayer player, int receiverId) {
        World world = player.func_130014_f_();
        TeleportDestinations destinations = TeleportDestinations.getDestinations(world);
        String name = TeleportDestinations.getDestinationName(destinations, receiverId);
        RFToolsMessages.sendToClient(player, "returnDestinationInfo", Arguments.builder().value(receiverId).value(name));
    }

    public static void setTarget(EntityPlayer player, int target) {
        ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
        if (heldItem.func_190926_b()) {
            return;
        }
        NBTTagCompound tagCompound = heldItem.func_77978_p();
        if (tagCompound == null) {
            return;
        }
        tagCompound.func_74768_a("target", target);
    }

    public static void returnTargets(EntityPlayer player) {
        int i;
        ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
        if (heldItem.func_190926_b()) {
            return;
        }
        NBTTagCompound tagCompound = heldItem.func_77978_p();
        int target = -1;
        int[] targets = new int[8];
        String[] names = new String[8];
        TeleportDestinations destinations = TeleportDestinations.getDestinations(player.func_130014_f_());
        if (tagCompound != null) {
            target = tagCompound.func_74764_b("target") ? tagCompound.func_74762_e("target") : -1;
            for (i = 0; i < 8; ++i) {
                names[i] = "";
                if (tagCompound.func_74764_b("target" + i)) {
                    TeleportDestination destination;
                    targets[i] = tagCompound.func_74762_e("target" + i);
                    GlobalCoordinate gc = destinations.getCoordinateForId(targets[i]);
                    if (gc == null || (destination = destinations.getDestination(gc)) == null) continue;
                    names[i] = destination.getName() + " (dimension " + destination.getDimension() + ")";
                    continue;
                }
                targets[i] = -1;
            }
        } else {
            for (i = 0; i < 8; ++i) {
                targets[i] = -1;
                names[i] = "";
            }
        }
        PacketTargetsReady msg = new PacketTargetsReady(target, targets, names);
        RFToolsMessages.INSTANCE.sendTo((IMessage)msg, (EntityPlayerMP)player);
    }
}

