/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.mods.forestrybackpacks;

import com.bymarcin.zettaindustries.ZettaIndustries;
import com.bymarcin.zettaindustries.modmanager.IMod;
import com.bymarcin.zettaindustries.mods.forestrybackpacks.backpacks.BasicBackpack;
import com.bymarcin.zettaindustries.mods.forestrybackpacks.backpacks.CreativeBackpack;
import com.bymarcin.zettaindustries.mods.forestrybackpacks.backpacks.ImmersiveEngineeringBackpack;
import com.bymarcin.zettaindustries.mods.forestrybackpacks.backpacks.OCBackpack;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import forestry.api.storage.EnumBackpackType;
import forestry.core.ModuleCore;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ForestyBackpacksMod
implements IMod {
    private static final Set<Item> itemsToRegister = new HashSet<Item>();
    private static final Set<IRecipe> recipesToRegister = new HashSet<IRecipe>();
    static Item creativeBackpackT1;
    static Item creativeBackpackT2;
    static Item immersiveEngineeringBackpackT1;
    static Item immersiveEngineeringBackpackT2;
    static Item OCBackpackT1;
    static Item OCBackpackT2;
    public static ItemStack oc;
    public static ItemStack ie;
    boolean preinit = false;

    @Override
    public void preInit() {
        if (BackpackManager.backpackInterface == null) {
            return;
        }
        creativeBackpackT1 = this.addBackpack(new CreativeBackpack(EnumBackpackType.NORMAL), EnumBackpackType.NORMAL);
        creativeBackpackT2 = this.addBackpack(new CreativeBackpack(EnumBackpackType.WOVEN), EnumBackpackType.WOVEN);
        immersiveEngineeringBackpackT1 = this.addBackpack(new ImmersiveEngineeringBackpack(EnumBackpackType.NORMAL), EnumBackpackType.NORMAL);
        immersiveEngineeringBackpackT2 = this.addBackpack(new ImmersiveEngineeringBackpack(EnumBackpackType.WOVEN), EnumBackpackType.WOVEN);
        OCBackpackT1 = this.addBackpack(new OCBackpack(EnumBackpackType.NORMAL), EnumBackpackType.NORMAL);
        OCBackpackT2 = this.addBackpack(new OCBackpack(EnumBackpackType.WOVEN), EnumBackpackType.WOVEN);
        this.preinit = true;
    }

    @Override
    public void init() {
    }

    @Override
    public void postInit() {
        if (!this.preinit) {
            return;
        }
        if (ie != null) {
            this.addRecipe(immersiveEngineeringBackpackT1, immersiveEngineeringBackpackT2, ie, null);
        }
        if (oc != null) {
            this.addRecipe(OCBackpackT1, OCBackpackT2, oc, null);
        }
    }

    @SubscribeEvent
    public void onRecipeRegister(RegistryEvent.Register<IRecipe> event) {
        ie = GameRegistry.makeItemStack((String)"ImmersiveEngineering:material", (int)4, (int)1, (String)"");
        oc = GameRegistry.makeItemStack((String)"OpenComputers:item", (int)1, (int)96, (String)"");
        if (ie != null) {
            this.addRecipe(immersiveEngineeringBackpackT1, immersiveEngineeringBackpackT2, ie, (IForgeRegistry<IRecipe>)event.getRegistry());
        }
        if (oc != null) {
            this.addRecipe(OCBackpackT1, OCBackpackT2, oc, (IForgeRegistry<IRecipe>)event.getRegistry());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onModelRegister(ModelRegistryEvent event) {
        for (Item item : itemsToRegister) {
            ZettaIndustries.proxy.registermodel(item, 0);
        }
    }

    @SubscribeEvent
    public void onItemRegister(RegistryEvent.Register<Item> event) {
        for (Item item : itemsToRegister) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
    }

    private Item addBackpack(BasicBackpack backpack, EnumBackpackType type) {
        Item backpakItem = BackpackManager.backpackInterface.createBackpack(backpack.getUniqueName(), type);
        backpakItem.func_77637_a(ZettaIndustries.tabZettaIndustries);
        backpakItem.setRegistryName(backpack.getKey());
        itemsToRegister.add(backpakItem);
        return backpakItem;
    }

    private void addRecipe(Item backpackT1, Item backpackT2, ItemStack crafting, IForgeRegistry<IRecipe> registry) {
        if (registry != null) {
            registry.register(new ShapedOreRecipe(backpackT1.getRegistryName(), new ItemStack(backpackT1), new Object[]{"X#X", "VYV", "X#X", Character.valueOf('#'), Blocks.field_150325_L, Character.valueOf('X'), Items.field_151007_F, Character.valueOf('V'), crafting, Character.valueOf('Y'), Blocks.field_150486_ae}).setRegistryName(backpackT1.getRegistryName()));
        } else {
            RecipeManagers.carpenterManager.addRecipe(200, FluidRegistry.getFluidStack((String)"water", (int)1000), null, new ItemStack(backpackT2), new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), Items.field_151045_i, Character.valueOf('W'), ModuleCore.getItems().craftingMaterial.getSilkWisp(), Character.valueOf('T'), backpackT1});
        }
    }

    static {
        oc = null;
        ie = null;
    }
}

