/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.Profiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.lwjgl.opengl.GL11;
import vazkii.botania.api.lexicon.ILexicon;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.mana.ICreativeManaProvider;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.recipe.RecipeManaInfusion;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.api.wiki.IWikiProvider;
import vazkii.botania.api.wiki.WikiHooks;
import vazkii.botania.client.core.handler.ItemsRemainingRenderHandler;
import vazkii.botania.client.core.handler.MultiblockRenderHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileAltar;
import vazkii.botania.common.block.tile.TileRuneAltar;
import vazkii.botania.common.block.tile.corporea.TileCorporeaCrystalCube;
import vazkii.botania.common.block.tile.corporea.TileCorporeaIndex;
import vazkii.botania.common.block.tile.mana.TilePool;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.item.ItemCraftingHalo;
import vazkii.botania.common.item.ItemSextant;
import vazkii.botania.common.item.ItemTwigWand;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.bauble.ItemDodgeRing;
import vazkii.botania.common.item.equipment.bauble.ItemFlightTiara;
import vazkii.botania.common.item.equipment.bauble.ItemMonocle;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="botania")
public final class HUDHandler {
    public static final ResourceLocation manaBar = new ResourceLocation("botania:textures/gui/manaHud.png");

    private HUDHandler() {
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onDrawScreenPre(RenderGameOverlayEvent.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        Profiler profiler = mc.field_71424_I;
        if (event.getType() == RenderGameOverlayEvent.ElementType.HEALTH) {
            ItemStack ring;
            profiler.func_76320_a("botania-hud");
            IBaublesItemHandler baublesInv = BaublesApi.getBaublesHandler((EntityPlayer)mc.field_71439_g);
            ItemStack headpiece = baublesInv.getStackInSlot(4);
            if (!headpiece.func_190926_b() && headpiece.func_77973_b() == ModItems.flightTiara) {
                profiler.func_76320_a("flugelTiara");
                ItemFlightTiara.renderHUD(event.getResolution(), (EntityPlayer)mc.field_71439_g, headpiece);
                profiler.func_76319_b();
            }
            if (!(ring = baublesInv.getStackInSlot(1)).func_190926_b() && ring.func_77973_b() instanceof ItemDodgeRing || !(ring = baublesInv.getStackInSlot(2)).func_190926_b() && ring.func_77973_b() instanceof ItemDodgeRing) {
                profiler.func_76320_a("dodgeRing");
                ItemDodgeRing.renderHUD(event.getResolution(), (EntityPlayer)mc.field_71439_g, ring, event.getPartialTicks());
                profiler.func_76319_b();
            }
            profiler.func_76319_b();
        }
    }

    @SubscribeEvent
    public static void onDrawScreenPost(RenderGameOverlayEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        Profiler profiler = mc.field_71424_I;
        ItemStack main = mc.field_71439_g.func_184614_ca();
        ItemStack offhand = mc.field_71439_g.func_184592_cb();
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            profiler.func_76320_a("botania-hud");
            RayTraceResult pos = mc.field_71476_x;
            if (pos != null) {
                TileEntity tile;
                IBlockState state = pos.field_72313_a == RayTraceResult.Type.BLOCK ? mc.field_71441_e.func_180495_p(pos.func_178782_a()) : null;
                Block block = state == null ? null : state.func_177230_c();
                TileEntity tileEntity = tile = pos.field_72313_a == RayTraceResult.Type.BLOCK ? mc.field_71441_e.func_175625_s(pos.func_178782_a()) : null;
                if (PlayerHelper.hasAnyHeldItem((EntityPlayer)mc.field_71439_g)) {
                    if (pos != null && PlayerHelper.hasHeldItem((EntityPlayer)mc.field_71439_g, ModItems.twigWand)) {
                        HUDHandler.renderWandModeDisplay(PlayerHelper.getFirstHeldItem((EntityPlayer)mc.field_71439_g, ModItems.twigWand), event.getResolution());
                        if (block instanceof IWandHUD) {
                            profiler.func_76320_a("wandItem");
                            ((IWandHUD)block).renderHUD(mc, event.getResolution(), (World)mc.field_71441_e, pos.func_178782_a());
                            profiler.func_76319_b();
                        }
                    } else if (block != null && PlayerHelper.hasHeldItemClass((EntityPlayer)mc.field_71439_g, ILexicon.class)) {
                        HUDHandler.drawLexiconHUD(PlayerHelper.getFirstHeldItemClass((EntityPlayer)mc.field_71439_g, ILexicon.class), state, pos, event.getResolution());
                    }
                    if (tile != null && tile instanceof TilePool && !mc.field_71439_g.func_184614_ca().func_190926_b()) {
                        HUDHandler.renderPoolRecipeHUD(event.getResolution(), (TilePool)tile, mc.field_71439_g.func_184614_ca());
                    }
                }
                if (tile != null && tile instanceof TileAltar) {
                    ((TileAltar)tile).renderHUD(mc, event.getResolution());
                } else if (tile != null && tile instanceof TileRuneAltar) {
                    ((TileRuneAltar)tile).renderHUD(mc, event.getResolution());
                }
                if (tile != null && tile instanceof TileCorporeaCrystalCube) {
                    HUDHandler.renderCrystalCubeHUD(event.getResolution(), (TileCorporeaCrystalCube)tile);
                }
            }
            TileCorporeaIndex.getInputHandler();
            if (!TileCorporeaIndex.InputHandler.getNearbyIndexes((EntityPlayer)mc.field_71439_g).isEmpty() && mc.field_71462_r != null && mc.field_71462_r instanceof GuiChat) {
                profiler.func_76320_a("nearIndex");
                HUDHandler.renderNearIndexDisplay(event.getResolution());
                profiler.func_76319_b();
            }
            if (MultiblockRenderHandler.currentMultiblock != null && MultiblockRenderHandler.anchor == null) {
                profiler.func_76320_a("multiblockRightClick");
                String s = I18n.func_135052_a((String)"botaniamisc.rightClickToAnchor", (Object[])new Object[0]);
                mc.field_71466_p.func_175063_a(s, (float)(event.getResolution().func_78326_a() / 2 - mc.field_71466_p.func_78256_a(s) / 2), (float)(event.getResolution().func_78328_b() / 2 - 30), 0xFFFFFF);
                profiler.func_76319_b();
            }
            if (!main.func_190926_b() && main.func_77973_b() instanceof ItemCraftingHalo) {
                profiler.func_76320_a("craftingHalo_main");
                ItemCraftingHalo.renderHUD(event.getResolution(), (EntityPlayer)mc.field_71439_g, main);
                profiler.func_76319_b();
            } else if (!offhand.func_190926_b() && offhand.func_77973_b() instanceof ItemCraftingHalo) {
                profiler.func_76320_a("craftingHalo_off");
                ItemCraftingHalo.renderHUD(event.getResolution(), (EntityPlayer)mc.field_71439_g, offhand);
                profiler.func_76319_b();
            }
            if (!main.func_190926_b() && main.func_77973_b() instanceof ItemSextant) {
                profiler.func_76320_a("sextant");
                ItemSextant.renderHUD(event.getResolution(), (EntityPlayer)mc.field_71439_g, main);
                profiler.func_76319_b();
            }
            if (Botania.proxy.isClientPlayerWearingMonocle()) {
                profiler.func_76320_a("monocle");
                ItemMonocle.renderHUD(event.getResolution(), (EntityPlayer)mc.field_71439_g);
                profiler.func_76319_b();
            }
            profiler.func_76320_a("manaBar");
            EntityPlayerSP player = mc.field_71439_g;
            if (!player.func_175149_v()) {
                int invSize;
                int totalMana = 0;
                int totalMaxMana = 0;
                boolean anyRequest = false;
                boolean creative = false;
                IItemHandler mainInv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                IBaublesItemHandler baublesInv = BaublesApi.getBaublesHandler((EntityPlayer)player);
                int size = invSize = mainInv.getSlots();
                if (baublesInv != null) {
                    size += baublesInv.getSlots();
                }
                for (int i = 0; i < size; ++i) {
                    Item item;
                    boolean useBaubles = i >= invSize;
                    Object inv = useBaubles ? baublesInv : mainInv;
                    ItemStack stack = inv.getStackInSlot(i - (useBaubles ? invSize : 0));
                    if (stack.func_190926_b() || !((item = stack.func_77973_b()) instanceof IManaUsingItem)) continue;
                    anyRequest = anyRequest || ((IManaUsingItem)item).usesMana(stack);
                }
                List<ItemStack> items = ManaItemHandler.getManaItems((EntityPlayer)player);
                for (ItemStack stack : items) {
                    Item item = stack.func_77973_b();
                    if (!((IManaItem)item).isNoExport(stack)) {
                        totalMana += ((IManaItem)item).getMana(stack);
                        totalMaxMana += ((IManaItem)item).getMaxMana(stack);
                    }
                    if (!(item instanceof ICreativeManaProvider) || !((ICreativeManaProvider)item).isCreative(stack)) continue;
                    creative = true;
                }
                Map<Integer, ItemStack> baubles = ManaItemHandler.getManaBaubles((EntityPlayer)player);
                for (Map.Entry<Integer, ItemStack> entry : baubles.entrySet()) {
                    ItemStack stack = entry.getValue();
                    Item item = stack.func_77973_b();
                    if (!((IManaItem)item).isNoExport(stack)) {
                        totalMana += ((IManaItem)item).getMana(stack);
                        totalMaxMana += ((IManaItem)item).getMaxMana(stack);
                    }
                    if (!(item instanceof ICreativeManaProvider) || !((ICreativeManaProvider)item).isCreative(stack)) continue;
                    creative = true;
                }
                if (anyRequest) {
                    HUDHandler.renderManaInvBar(event.getResolution(), creative, totalMana, totalMaxMana);
                }
            }
            profiler.func_76318_c("itemsRemaining");
            ItemsRemainingRenderHandler.render(event.getResolution(), event.getPartialTicks());
            profiler.func_76319_b();
            profiler.func_76319_b();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private static void renderWandModeDisplay(ItemStack stack, ScaledResolution res) {
        Minecraft mc = Minecraft.func_71410_x();
        Profiler profiler = mc.field_71424_I;
        profiler.func_76320_a("wandMode");
        int ticks = mc.field_71456_v.field_92017_k;
        if ((ticks -= 15) > 0) {
            int alpha = Math.min(255, (int)((float)ticks * 256.0f / 10.0f));
            int color = 52224 + (alpha << 24);
            String disp = I18n.func_135052_a((String)ItemTwigWand.getModeString(stack), (Object[])new Object[0]);
            int x = res.func_78326_a() / 2 - mc.field_71466_p.func_78256_a(disp) / 2;
            int y = res.func_78328_b() - 70;
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            mc.field_71466_p.func_175063_a(disp, (float)x, (float)y, color);
            GlStateManager.func_179084_k();
        }
        profiler.func_76319_b();
    }

    private static void renderManaInvBar(ScaledResolution res, boolean hasCreative, int totalMana, int totalMaxMana) {
        Minecraft mc = Minecraft.func_71410_x();
        int width = 182;
        int x = res.func_78326_a() / 2 - width / 2;
        int y = res.func_78328_b() - ConfigHandler.manaBarHeight;
        if (!hasCreative) {
            width = totalMaxMana == 0 ? 0 : (int)((double)width * ((double)totalMana / (double)totalMaxMana));
        }
        if (width == 0) {
            if (totalMana > 0) {
                width = 1;
            } else {
                return;
            }
        }
        Color color = new Color(Color.HSBtoRGB(0.55f, (float)Math.min(1.0, Math.sin((double)System.currentTimeMillis() / 200.0) * 0.5 + 1.0), 1.0f));
        GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)(255 - color.getRed())));
        mc.field_71446_o.func_110577_a(manaBar);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        RenderHelper.drawTexturedModalRect(x, y, 0.0f, 0, 251, width, 5);
        GlStateManager.func_179084_k();
        GL11.glColor4ub((byte)-1, (byte)-1, (byte)-1, (byte)-1);
    }

    private static void renderPoolRecipeHUD(ScaledResolution res, TilePool tile, ItemStack stack) {
        Minecraft mc = Minecraft.func_71410_x();
        Profiler profiler = mc.field_71424_I;
        profiler.func_76320_a("poolRecipe");
        RecipeManaInfusion recipe = TilePool.getMatchingRecipe(stack, tile.func_145831_w().func_180495_p(tile.func_174877_v().func_177977_b()));
        if (recipe != null) {
            int x = res.func_78326_a() / 2 - 11;
            int y = res.func_78328_b() / 2 + 10;
            int u = tile.getCurrentMana() >= recipe.getManaToConsume() ? 0 : 22;
            int v = mc.field_71439_g.func_70005_c_().equals("haighyorkie") && mc.field_71439_g.func_70093_af() ? 23 : 8;
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            mc.field_71446_o.func_110577_a(manaBar);
            RenderHelper.drawTexturedModalRect(x, y, 0.0f, u, v, 22, 15);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            net.minecraft.client.renderer.RenderHelper.func_74520_c();
            mc.func_175599_af().func_180450_b(stack, x - 20, y);
            mc.func_175599_af().func_180450_b(recipe.getOutput(), x + 26, y);
            mc.func_175599_af().func_175030_a(mc.field_71466_p, recipe.getOutput(), x + 26, y);
            net.minecraft.client.renderer.RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179084_k();
        }
        profiler.func_76319_b();
    }

    private static void renderCrystalCubeHUD(ScaledResolution res, TileCorporeaCrystalCube tile) {
        Minecraft mc = Minecraft.func_71410_x();
        Profiler profiler = mc.field_71424_I;
        profiler.func_76320_a("crystalCube");
        ItemStack target = tile.getRequestTarget();
        if (!target.func_190926_b()) {
            String s1 = target.func_82833_r();
            String s2 = tile.getItemCount() + "x";
            int strlen = Math.max(mc.field_71466_p.func_78256_a(s1), mc.field_71466_p.func_78256_a(s2));
            int w = res.func_78326_a();
            int h = res.func_78328_b();
            Gui.func_73734_a((int)(w / 2 + 8), (int)(h / 2 - 12), (int)(w / 2 + strlen + 32), (int)(h / 2 + 10), (int)0x44000000);
            Gui.func_73734_a((int)(w / 2 + 6), (int)(h / 2 - 14), (int)(w / 2 + strlen + 34), (int)(h / 2 + 12), (int)0x44000000);
            mc.field_71466_p.func_175063_a(target.func_82833_r(), (float)(w / 2 + 30), (float)(h / 2 - 10), 0x6666FF);
            mc.field_71466_p.func_175063_a(tile.getItemCount() + "x", (float)(w / 2 + 30), (float)(h / 2), 0xFFFFFF);
            net.minecraft.client.renderer.RenderHelper.func_74520_c();
            GlStateManager.func_179091_B();
            mc.func_175599_af().func_180450_b(target, w / 2 + 10, h / 2 - 10);
            net.minecraft.client.renderer.RenderHelper.func_74518_a();
        }
        profiler.func_76319_b();
    }

    private static void drawLexiconHUD(ItemStack stack, IBlockState state, RayTraceResult pos, ScaledResolution res) {
        LexiconEntry entry;
        Minecraft mc = Minecraft.func_71410_x();
        Block block = state.func_177230_c();
        Profiler profiler = mc.field_71424_I;
        profiler.func_76320_a("lexicon");
        FontRenderer font = mc.field_71466_p;
        boolean draw = false;
        String drawStr = "";
        String secondLine = "";
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        int sx = res.func_78326_a() / 2 - 17;
        int sy = res.func_78328_b() / 2 + 2;
        if (block instanceof ILexiconable && (entry = ((ILexiconable)block).getEntry((World)mc.field_71441_e, pos.func_178782_a(), (EntityPlayer)mc.field_71439_g, stack)) != null) {
            if (!((ILexicon)stack.func_77973_b()).isKnowledgeUnlocked(stack, entry.getKnowledgeType())) {
                font = mc.field_71464_q;
            }
            drawStr = I18n.func_135052_a((String)entry.getUnlocalizedName(), (Object[])new Object[0]);
            secondLine = TextFormatting.ITALIC + I18n.func_135052_a((String)entry.getTagline(), (Object[])new Object[0]);
            draw = true;
        }
        if (!draw && pos.field_72308_g == null) {
            IWikiProvider provider;
            String url;
            profiler.func_76320_a("wikiLookup");
            if (!(block.isAir(state, (IBlockAccess)mc.field_71441_e, pos.func_178782_a()) || block instanceof BlockLiquid || (url = (provider = WikiHooks.getWikiFor(block)).getWikiURL((World)mc.field_71441_e, pos, (EntityPlayer)mc.field_71439_g)) == null || url.isEmpty())) {
                String name = provider.getBlockName((World)mc.field_71441_e, pos, (EntityPlayer)mc.field_71439_g);
                String wikiName = provider.getWikiName((World)mc.field_71441_e, pos, (EntityPlayer)mc.field_71439_g);
                drawStr = name + " @ " + TextFormatting.AQUA + wikiName;
                draw = true;
            }
            profiler.func_76319_b();
        }
        if (draw) {
            if (!mc.field_71439_g.func_70093_af()) {
                drawStr = "?";
                secondLine = "";
                font = mc.field_71466_p;
            }
            mc.func_175599_af().func_175042_a(new ItemStack(ModItems.lexicon), sx, sy);
            GlStateManager.func_179140_f();
            font.func_175063_a(drawStr, (float)(sx + 20), (float)(sy + 4), -1);
            font.func_175063_a(secondLine, (float)(sx + 20), (float)(sy + 14), -5592406);
            if (!mc.field_71439_g.func_70093_af()) {
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
                mc.field_71466_p.func_175063_a(TextFormatting.BOLD + mc.field_71474_y.field_74311_E.getDisplayName(), (float)((sx + 10) * 2 - 16), (float)((sy + 8) * 2 + 20), -1);
                GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)1.0f);
            }
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        profiler.func_76319_b();
    }

    private static void renderNearIndexDisplay(ScaledResolution res) {
        Minecraft mc = Minecraft.func_71410_x();
        String txt0 = I18n.func_135052_a((String)"botaniamisc.nearIndex0", (Object[])new Object[0]);
        String txt1 = TextFormatting.GRAY + I18n.func_135052_a((String)"botaniamisc.nearIndex1", (Object[])new Object[0]);
        String txt2 = TextFormatting.GRAY + I18n.func_135052_a((String)"botaniamisc.nearIndex2", (Object[])new Object[0]);
        int l = Math.max(mc.field_71466_p.func_78256_a(txt0), Math.max(mc.field_71466_p.func_78256_a(txt1), mc.field_71466_p.func_78256_a(txt2))) + 20;
        int x = res.func_78326_a() - l - 20;
        int y = res.func_78328_b() - 60;
        Gui.func_73734_a((int)(x - 6), (int)(y - 6), (int)(x + l + 6), (int)(y + 37), (int)0x44000000);
        Gui.func_73734_a((int)(x - 4), (int)(y - 4), (int)(x + l + 4), (int)(y + 35), (int)0x44000000);
        net.minecraft.client.renderer.RenderHelper.func_74520_c();
        GlStateManager.func_179091_B();
        mc.func_175599_af().func_180450_b(new ItemStack(ModBlocks.corporeaIndex), x, y + 10);
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
        mc.field_71466_p.func_175063_a(txt0, (float)(x + 20), (float)y, 0xFFFFFF);
        mc.field_71466_p.func_175063_a(txt1, (float)(x + 20), (float)(y + 14), 0xFFFFFF);
        mc.field_71466_p.func_175063_a(txt2, (float)(x + 20), (float)(y + 24), 0xFFFFFF);
    }

    public static void drawSimpleManaHUD(int color, int mana, int maxMana, String name, ScaledResolution res) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        Minecraft mc = Minecraft.func_71410_x();
        int x = res.func_78326_a() / 2 - mc.field_71466_p.func_78256_a(name) / 2;
        int y = res.func_78328_b() / 2 + 10;
        mc.field_71466_p.func_175063_a(name, (float)x, (float)y, color);
        x = res.func_78326_a() / 2 - 51;
        HUDHandler.renderManaBar(x, y += 10, color, mana < 0 ? 0.5f : 1.0f, mana, maxMana);
        if (mana < 0) {
            String text = I18n.func_135052_a((String)"botaniamisc.statusUnknown", (Object[])new Object[0]);
            x = res.func_78326_a() / 2 - mc.field_71466_p.func_78256_a(text) / 2;
            mc.field_71466_p.func_78276_b(text, x, --y, color);
        }
        GlStateManager.func_179084_k();
    }

    public static void drawComplexManaHUD(int color, int mana, int maxMana, String name, ScaledResolution res, ItemStack bindDisplay, boolean properlyBound) {
        HUDHandler.drawSimpleManaHUD(color, mana, maxMana, name, res);
        Minecraft mc = Minecraft.func_71410_x();
        int x = res.func_78326_a() / 2 + 55;
        int y = res.func_78328_b() / 2 + 12;
        net.minecraft.client.renderer.RenderHelper.func_74520_c();
        GlStateManager.func_179091_B();
        mc.func_175599_af().func_180450_b(bindDisplay, x, y);
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
        GlStateManager.func_179097_i();
        if (properlyBound) {
            mc.field_71466_p.func_175063_a("\u2714", (float)(x + 10), (float)(y + 9), 19456);
            mc.field_71466_p.func_175063_a("\u2714", (float)(x + 10), (float)(y + 8), 774669);
        } else {
            mc.field_71466_p.func_175063_a("\u2718", (float)(x + 10), (float)(y + 9), 0x4C0000);
            mc.field_71466_p.func_175063_a("\u2718", (float)(x + 10), (float)(y + 8), 13764621);
        }
        GlStateManager.func_179126_j();
    }

    public static void renderManaBar(int x, int y, int color, float alpha, int mana, int maxMana) {
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        mc.field_71446_o.func_110577_a(manaBar);
        RenderHelper.drawTexturedModalRect(x, y, 0.0f, 0, 0, 102, 5);
        int manaPercentage = Math.max(0, (int)((double)mana / (double)maxMana * 100.0));
        if (manaPercentage == 0 && mana > 0) {
            manaPercentage = 1;
        }
        RenderHelper.drawTexturedModalRect(x + 1, y + 1, 0.0f, 0, 5, 100, 3);
        Color color_ = new Color(color);
        GL11.glColor4ub((byte)((byte)color_.getRed()), (byte)((byte)color_.getGreen()), (byte)((byte)color_.getBlue()), (byte)((byte)(255.0f * alpha)));
        RenderHelper.drawTexturedModalRect(x + 1, y + 1, 0.0f, 0, 5, Math.min(100, manaPercentage), 3);
        GL11.glColor4ub((byte)-1, (byte)-1, (byte)-1, (byte)-1);
    }
}

