/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.TileCocoon;
import vazkii.botania.common.lexicon.LexiconData;

public class BlockCocoon
extends BlockMod
implements ILexiconable {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.875, 0.8125);

    protected BlockCocoon() {
        super(Material.field_151580_n, "cocoon");
        this.func_149711_c(3.0f);
        this.func_149752_b(50.0f);
        this.func_149672_a(SoundType.field_185854_g);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return AABB;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity e) {
        if (!world.field_72995_K && e instanceof EntityItem) {
            EntityItem item = (EntityItem)e;
            ItemStack stack = item.func_92059_d();
            this.addStack(world, pos, stack, false);
            if (stack.func_190926_b()) {
                item.func_70106_y();
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing s, float xs, float ys, float zs) {
        ItemStack stack = player.func_184586_b(hand);
        Item item = stack.func_77973_b();
        return this.addStack(world, pos, stack, player.field_71075_bZ.field_75098_d);
    }

    private boolean addStack(World world, BlockPos pos, ItemStack stack, boolean creative) {
        TileCocoon cocoon = (TileCocoon)world.func_175625_s(pos);
        Item item = stack.func_77973_b();
        if (cocoon != null && (item == Items.field_151166_bC || item == Items.field_185161_cS)) {
            if (!world.field_72995_K) {
                if (item == Items.field_151166_bC && cocoon.emeraldsGiven < 20) {
                    if (!creative) {
                        stack.func_190918_g(1);
                    }
                    ++cocoon.emeraldsGiven;
                    ((WorldServer)world).func_175739_a(EnumParticleTypes.VILLAGER_HAPPY, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, 1, 0.0, 0.0, 0.0, 0.5, new int[0]);
                } else if (item == Items.field_185161_cS && cocoon.chorusFruitGiven < 20) {
                    if (!creative) {
                        stack.func_190918_g(1);
                    }
                    ++cocoon.chorusFruitGiven;
                    ((WorldServer)world).func_175739_a(EnumParticleTypes.PORTAL, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 32, 0.0, 0.0, 0.0, 0.5, new int[0]);
                }
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, @Nonnull Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, @Nonnull IBlockState state, EntityPlayer player) {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileCocoon();
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.cocoon;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return side.func_176740_k() == EnumFacing.Axis.Y ? BlockFaceShape.CENTER_BIG : BlockFaceShape.MIDDLE_POLE_THICK;
    }
}

