/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCommandBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.wand.ICoordBoundItem;
import vazkii.botania.api.wand.ITileBound;
import vazkii.botania.api.wand.IWandBindable;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.BlockPistonRelay;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileEnchanter;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.Item16Colors;
import vazkii.botania.common.item.ModItems;

public class ItemTwigWand
extends Item16Colors
implements ICoordBoundItem {
    private static final String TAG_COLOR1 = "color1";
    private static final String TAG_COLOR2 = "color2";
    private static final String TAG_BOUND_TILE_X = "boundTileX";
    private static final String TAG_BOUND_TILE_Y = "boundTileY";
    private static final String TAG_BOUND_TILE_Z = "boundTileZ";
    private static final String TAG_BIND_MODE = "bindMode";
    private static final BlockPos UNBOUND_POS = new BlockPos(0, -1, 0);

    public ItemTwigWand() {
        super("twigWand");
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("botania", "bindmode"), (stack, worldIn, entityIn) -> ItemTwigWand.getBindMode(stack) ? 1.0f : 0.0f);
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float par8, float par9, float par10) {
        ItemStack stack = player.func_184586_b(hand);
        Block block = world.func_180495_p(pos).func_177230_c();
        BlockPos boundPos = ItemTwigWand.getBoundTile(stack);
        TileEntity boundTile = world.func_175625_s(boundPos);
        if (player.func_70093_af()) {
            if (boundPos.func_177956_o() != -1 && !pos.equals((Object)boundPos)) {
                if (boundTile instanceof IWandBindable) {
                    if (((IWandBindable)boundTile).bindTo(player, stack, pos, side)) {
                        Vector3 orig = new Vector3((double)boundPos.func_177958_n() + 0.5, (double)boundPos.func_177956_o() + 0.5, (double)boundPos.func_177952_p() + 0.5);
                        Vector3 end = new Vector3((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                        ItemTwigWand.doParticleBeam(world, orig, end);
                        VanillaPacketDispatcher.dispatchTEToNearbyPlayers(world, boundPos);
                        ItemTwigWand.setBoundTile(stack, UNBOUND_POS);
                    }
                    return EnumActionResult.SUCCESS;
                }
                ItemTwigWand.setBoundTile(stack, UNBOUND_POS);
            }
            if (player.func_175151_a(pos, side, stack) && (!(block instanceof BlockCommandBlock) || player.func_189808_dh()) && block.rotateBlock(world, pos, side)) {
                player.func_184609_a(hand);
                return EnumActionResult.SUCCESS;
            }
        }
        if (block == Blocks.field_150368_y && ConfigHandler.enchanterEnabled) {
            EnumFacing.Axis axis = null;
            if (TileEnchanter.canEnchanterExist(world, pos, EnumFacing.Axis.X)) {
                axis = EnumFacing.Axis.X;
            } else if (TileEnchanter.canEnchanterExist(world, pos, EnumFacing.Axis.Z)) {
                axis = EnumFacing.Axis.Z;
            }
            if (axis != null) {
                if (!world.field_72995_K) {
                    world.func_180501_a(pos, ModBlocks.enchanter.func_176223_P().func_177226_a(BotaniaStateProps.ENCHANTER_DIRECTION, (Comparable)axis), 3);
                    world.func_184133_a(null, pos, ModSounds.enchanterForm, SoundCategory.BLOCKS, 0.5f, 0.6f);
                    PlayerHelper.grantCriterion((EntityPlayerMP)player, new ResourceLocation("botania", "main/enchanter_make"), "code_triggered");
                } else {
                    for (int i = 0; i < 50; ++i) {
                        float red = (float)Math.random();
                        float green = (float)Math.random();
                        float blue = (float)Math.random();
                        double x = (Math.random() - 0.5) * 6.0;
                        double y = (Math.random() - 0.5) * 6.0;
                        double z = (Math.random() - 0.5) * 6.0;
                        float velMul = 0.07f;
                        Botania.proxy.wispFX((double)pos.func_177958_n() + 0.5 + x, (double)pos.func_177956_o() + 0.5 + y, (double)pos.func_177952_p() + 0.5 + z, red, green, blue, (float)Math.random() * 0.15f + 0.15f, (float)(-x) * velMul, (float)(-y) * velMul, (float)(-z) * velMul);
                    }
                }
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.PASS;
        }
        if (block instanceof IWandable) {
            boolean wanded;
            TileEntity tile = world.func_175625_s(pos);
            boolean bindable = tile instanceof IWandBindable;
            if (ItemTwigWand.getBindMode(stack) && bindable && player.func_70093_af() && ((IWandBindable)tile).canSelect(player, stack, pos, side)) {
                if (boundPos.equals((Object)pos)) {
                    ItemTwigWand.setBoundTile(stack, UNBOUND_POS);
                } else {
                    ItemTwigWand.setBoundTile(stack, pos);
                }
                if (world.field_72995_K) {
                    player.func_184609_a(hand);
                    player.func_184185_a(ModSounds.ding, 0.11f, 1.0f);
                }
                wanded = true;
            } else {
                wanded = ((IWandable)block).onUsedByWand(player, stack, world, pos, side);
                if (wanded && world.field_72995_K) {
                    player.func_184609_a(hand);
                }
            }
            return wanded ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
        }
        if (((BlockPistonRelay)ModBlocks.pistonRelay).playerPositions.containsKey(player.func_110124_au()) && !world.field_72995_K) {
            BlockPistonRelay.DimWithPos bindPos = ((BlockPistonRelay)ModBlocks.pistonRelay).playerPositions.get(player.func_110124_au());
            BlockPistonRelay.DimWithPos currentPos = new BlockPistonRelay.DimWithPos(world.field_73011_w.getDimension(), pos);
            ((BlockPistonRelay)ModBlocks.pistonRelay).playerPositions.remove(player.func_110124_au());
            ((BlockPistonRelay)ModBlocks.pistonRelay).mappedPositions.put(bindPos, currentPos);
            BlockPistonRelay.WorldData.get(world).func_76185_a();
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, ModSounds.ding, SoundCategory.PLAYERS, 1.0f, 1.0f);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public static void doParticleBeam(World world, Vector3 orig, Vector3 end) {
        if (!world.field_72995_K) {
            return;
        }
        Vector3 diff = end.subtract(orig);
        Vector3 movement = diff.normalize().multiply(0.05);
        int iters = (int)(diff.mag() / movement.mag());
        float huePer = 1.0f / (float)iters;
        float hueSum = (float)Math.random();
        Vector3 currentPos = orig;
        for (int i = 0; i < iters; ++i) {
            float hue = (float)i * huePer + hueSum;
            Color color = Color.getHSBColor(hue, 1.0f, 1.0f);
            float r = (float)color.getRed() / 255.0f;
            float g = (float)color.getGreen() / 255.0f;
            float b = (float)color.getBlue() / 255.0f;
            Botania.proxy.setSparkleFXNoClip(true);
            Botania.proxy.sparkleFX(currentPos.x, currentPos.y, currentPos.z, r, g, b, 0.5f, 4);
            Botania.proxy.setSparkleFXNoClip(false);
            currentPos = currentPos.add(movement);
        }
    }

    public void func_77663_a(ItemStack par1ItemStack, World world, Entity par3Entity, int par4, boolean par5) {
        BlockPos coords = ItemTwigWand.getBoundTile(par1ItemStack);
        TileEntity tile = world.func_175625_s(coords);
        if (tile == null || !(tile instanceof IWandBindable)) {
            ItemTwigWand.setBoundTile(par1ItemStack, UNBOUND_POS);
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            if (!world.field_72995_K) {
                ItemTwigWand.setBindMode(stack, !ItemTwigWand.getBindMode(stack));
            } else {
                player.func_184185_a(ModSounds.ding, 0.1f, 1.0f);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    @Override
    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> stacks) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < 16; ++i) {
                stacks.add((Object)ItemTwigWand.forColors(i, i));
            }
        }
    }

    @Override
    @Nonnull
    public String func_77667_c(ItemStack par1ItemStack) {
        return this.getUnlocalizedNameLazy(par1ItemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag flags) {
        list.add(I18n.func_135052_a((String)ItemTwigWand.getModeString(stack), (Object[])new Object[0]));
    }

    @Nonnull
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.RARE;
    }

    public static ItemStack forColors(int color1, int color2) {
        ItemStack stack = new ItemStack(ModItems.twigWand);
        ItemNBTHelper.setInt(stack, TAG_COLOR1, color1);
        ItemNBTHelper.setInt(stack, TAG_COLOR2, color2);
        return stack;
    }

    public static int getColor1(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_COLOR1, 0);
    }

    public static int getColor2(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_COLOR2, 0);
    }

    public static void setBoundTile(ItemStack stack, BlockPos pos) {
        ItemNBTHelper.setInt(stack, TAG_BOUND_TILE_X, pos.func_177958_n());
        ItemNBTHelper.setInt(stack, TAG_BOUND_TILE_Y, pos.func_177956_o());
        ItemNBTHelper.setInt(stack, TAG_BOUND_TILE_Z, pos.func_177952_p());
    }

    public static BlockPos getBoundTile(ItemStack stack) {
        int x = ItemNBTHelper.getInt(stack, TAG_BOUND_TILE_X, 0);
        int y = ItemNBTHelper.getInt(stack, TAG_BOUND_TILE_Y, -1);
        int z = ItemNBTHelper.getInt(stack, TAG_BOUND_TILE_Z, 0);
        return new BlockPos(x, y, z);
    }

    public static boolean getBindMode(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_BIND_MODE, true);
    }

    public static void setBindMode(ItemStack stack, boolean bindMode) {
        ItemNBTHelper.setBoolean(stack, TAG_BIND_MODE, bindMode);
    }

    public static String getModeString(ItemStack stack) {
        return "botaniamisc.wandMode." + (ItemTwigWand.getBindMode(stack) ? "bind" : "function");
    }

    @Override
    public BlockPos getBinding(ItemStack stack) {
        TileEntity tile;
        BlockPos bound = ItemTwigWand.getBoundTile(stack);
        if (bound.func_177956_o() != -1) {
            return bound;
        }
        RayTraceResult pos = Minecraft.func_71410_x().field_71476_x;
        if (pos != null && pos.field_72313_a == RayTraceResult.Type.BLOCK && (tile = Minecraft.func_71410_x().field_71441_e.func_175625_s(pos.func_178782_a())) != null && tile instanceof ITileBound) {
            BlockPos coords = ((ITileBound)tile).getBinding();
            return coords;
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }
}

