/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.api.data;

import elec332.core.api.data.IExternalSaveHandler;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;

public class SaveHandlerWrapper
implements IExternalSaveHandler {
    private final IExternalSaveHandler[] saveHandlers;
    private final String name;

    public static SaveHandlerWrapper wrap(String name, IExternalSaveHandler ... handlers) {
        return new SaveHandlerWrapper(name, handlers);
    }

    private SaveHandlerWrapper(String name, IExternalSaveHandler[] saveHandlers) {
        this.saveHandlers = saveHandlers;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void load(ISaveHandler saveHandler, WorldInfo info, NBTTagCompound tag) {
        for (IExternalSaveHandler saveHandler1 : this.saveHandlers) {
            saveHandler1.load(saveHandler, info, tag.func_74775_l(saveHandler1.getName()));
        }
    }

    @Override
    @Nullable
    public NBTTagCompound save(ISaveHandler saveHandler, WorldInfo info) {
        NBTTagCompound ret = new NBTTagCompound();
        for (IExternalSaveHandler saveHandler1 : this.saveHandlers) {
            NBTTagCompound tag = saveHandler1.save(saveHandler, info);
            if (tag == null) continue;
            ret.func_74782_a(saveHandler1.getName(), (NBTBase)tag);
        }
        return ret;
    }

    @Override
    public void nullifyData() {
        for (IExternalSaveHandler saveHandler : this.saveHandlers) {
            saveHandler.nullifyData();
        }
    }
}

