/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.api.structure;

import elec332.core.api.util.Area;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public interface ISchematic {
    default public Block getBlock(BlockPos pos) {
        return this.getBlock(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public Block getBlock(int var1, int var2, int var3);

    public NBTTagCompound getTileData(int var1, int var2, int var3, int var4, int var5, int var6);

    public NBTTagCompound getTileData(int var1, int var2, int var3);

    default public byte getMetaData(BlockPos pos) {
        return this.getMetadata(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public byte getMetadata(int var1, int var2, int var3);

    default public IBlockState getBlockState(BlockPos pos) {
        return this.getBlock(pos).func_176203_a((int)this.getMetaData(pos));
    }

    public short getBlockLength();

    public short getBlockWidth();

    public short getBlockHeight();

    default public short getHorizon() {
        return 0;
    }

    default public Area getAreaFromWorldCoordinates(int x, int y, int z) {
        int maxZ;
        int minZ;
        int maxX;
        int minX;
        short width = this.getBlockWidth();
        short height = this.getBlockHeight();
        short length = this.getBlockLength();
        short horizon = this.getHorizon();
        if (width % 2 == 0) {
            minX = x + 1 - width / 2;
            maxX = x + width / 2;
        } else {
            minX = x - (width - 1) / 2;
            maxX = x + (width - 1) / 2;
        }
        int minY = y - horizon;
        int maxY = y - horizon + height;
        if (length % 2 == 0) {
            minZ = z + 1 - length / 2;
            maxZ = z + length / 2;
        } else {
            minZ = z - (length - 1) / 2;
            maxZ = z + (length - 1) / 2;
        }
        return new Area(minX, minY, minZ, maxX, maxY, maxZ);
    }
}

