/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.client.model.map;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import elec332.core.api.client.model.map.IBakedModelMetaRotationMap;
import elec332.core.api.client.model.map.IBakedModelRotationMap;
import elec332.core.client.model.map.AbstractModelRotationMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BakedModelMetaRotationMap<M extends IBakedModel>
extends AbstractModelRotationMap<M>
implements IBakedModelMetaRotationMap<M> {
    private final Map<Integer, Map<ModelRotation, M>> map = Maps.newHashMap();

    public BakedModelMetaRotationMap() {
        this(false, true);
    }

    public BakedModelMetaRotationMap(boolean x, boolean y) {
        super(x, y);
    }

    @Override
    public M get() {
        return this.forMeta(0);
    }

    @Override
    public M forMeta(int meta) {
        return this.forMetaAndRotation(meta, ModelRotation.X0_Y0);
    }

    @Override
    public void setModelForMeta(int meta, M model) {
        this.setModelForMetaAndRotation(meta, ModelRotation.X0_Y0, model);
    }

    @Override
    public M forRotation(ModelRotation rotation) throws IBakedModelRotationMap.RotationNotSupportedException {
        return this.forMetaAndRotation(0, rotation);
    }

    @Override
    public void setModel(ModelRotation rotation, M model) throws IBakedModelRotationMap.RotationNotSupportedException {
        this.setModelForMetaAndRotation(0, rotation, model);
    }

    @Override
    public M forMetaAndRotation(int meta, ModelRotation rotation) throws IBakedModelRotationMap.RotationNotSupportedException {
        Map<ModelRotation, M> map = this.map.get(meta);
        if (map == null) {
            if (meta == Short.MAX_VALUE) {
                map = this.map.get(0);
            }
            if (map == null) {
                throw new IllegalArgumentException("There is no model for meta " + meta);
            }
        }
        this.checkRotation(rotation);
        return (M)((IBakedModel)map.get(rotation));
    }

    @Override
    public void setModelForMetaAndRotation(int meta, ModelRotation rotation, M model) throws IBakedModelRotationMap.RotationNotSupportedException {
        this.checkRotation(rotation);
        EnumMap models = this.map.get(meta);
        if (models == null) {
            models = Maps.newEnumMap(ModelRotation.class);
            this.map.put(meta, models);
        }
        models.put(rotation, model);
    }

    @Override
    public void setModelsForRotation(int meta, IBakedModelRotationMap<M> modelMap) throws IBakedModelRotationMap.RotationNotSupportedException {
        ArrayList list = Lists.newArrayList();
        for (ModelRotation rotation : ModelRotation.values()) {
            if (modelMap.isRotationSupported(rotation)) {
                if (!this.isRotationSupported(rotation)) {
                    throw new IllegalArgumentException();
                }
                list.add(rotation);
                continue;
            }
            if (!this.isRotationSupported(rotation)) continue;
            throw new IllegalArgumentException();
        }
        EnumMap modelRotationMap = Maps.newEnumMap(ModelRotation.class);
        for (ModelRotation rotation : list) {
            modelRotationMap.put(rotation, modelMap.forRotation(rotation));
        }
        this.map.put(meta, modelRotationMap);
    }
}

