/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.compat.forestry;

import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleArea;
import forestry.api.genetics.IAlleleBoolean;
import forestry.api.genetics.IAlleleFloat;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAlleleTolerance;
import forestry.apiculture.flowers.FlowerProvider;
import forestry.core.genetics.alleles.AlleleHelper;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.core.genetics.alleles.IAlleleValue;
import java.lang.reflect.Field;
import net.minecraft.util.math.Vec3i;

public class ForestryAlleles {
    public static final IAlleleBeeEffect EFFECT_NONE;
    public static final IAlleleBoolean TRUE_RECESSIVE;
    public static final IAlleleBoolean FALSE_RECESSIVE;
    public static final IAlleleInteger LIFESPAN_SHORTEST;
    public static final IAlleleInteger LIFESPAN_SHORTER;
    public static final IAlleleInteger LIFESPAN_SHORT;
    public static final IAlleleInteger LIFESPAN_SHORTENED;
    public static final IAlleleInteger LIFESPAN_NORMAL;
    public static final IAlleleInteger LIFESPAN_ELONGATED;
    public static final IAlleleInteger LIFESPAN_LONG;
    public static final IAlleleInteger LIFESPAN_LONGER;
    public static final IAlleleInteger LIFESPAN_LONGEST;
    public static final IAlleleFloat SPEED_SLOWEST;
    public static final IAlleleFloat SPEED_SLOWER;
    public static final IAlleleFloat SPEED_SLOW;
    public static final IAlleleFloat SPEED_NORMAL;
    public static final IAlleleFloat SPEED_FAST;
    public static final IAlleleFloat SPEED_FASTER;
    public static final IAlleleFloat SPEED_FASTEST;
    public static final IAlleleTolerance TOLERANCE_NONE;
    public static final IAlleleTolerance TOLERANCE_BOTH_1;
    public static final IAlleleTolerance TOLERANCE_BOTH_2;
    public static final IAlleleTolerance TOLERANCE_BOTH_3;
    public static final IAlleleTolerance TOLERANCE_BOTH_4;
    public static final IAlleleTolerance TOLERANCE_BOTH_5;
    public static final IAlleleTolerance TOLERANCE_UP_1;
    public static final IAlleleTolerance TOLERANCE_UP_2;
    public static final IAlleleTolerance TOLERANCE_UP_3;
    public static final IAlleleTolerance TOLERANCE_UP_4;
    public static final IAlleleTolerance TOLERANCE_UP_5;
    public static final IAlleleTolerance TOLERANCE_DOWN_1;
    public static final IAlleleTolerance TOLERANCE_DOWN_2;
    public static final IAlleleTolerance TOLERANCE_DOWN_3;
    public static final IAlleleTolerance TOLERANCE_DOWN_4;
    public static final IAlleleTolerance TOLERANCE_DOWN_5;
    public static final IAlleleInteger FLOWERING_SLOWEST;
    public static final IAlleleInteger FLOWERING_SLOWER;
    public static final IAlleleInteger FLOWERING_SLOW;
    public static final IAlleleInteger FLOWERING_AVERAGE;
    public static final IAlleleInteger FLOWERING_FAST;
    public static final IAlleleInteger FLOWERING_FASTER;
    public static final IAlleleInteger FLOWERING_FASTEST;
    public static final IAlleleInteger FLOWERING_MAXIMUM;
    public static final IAlleleArea TERRITORY_AVERAGE;
    public static final IAlleleArea TERRITORY_LARGE;
    public static final IAlleleArea TERRITORY_LARGER;
    public static final IAlleleArea TERRITORY_LARGEST;
    public static final IAlleleInteger FERTILITY_LOW;
    public static final IAlleleInteger FERTILITY_NORMAL;
    public static final IAlleleInteger FERTILITY_HIGH;
    public static final IAlleleInteger FERTILITY_MAXIMUM;
    public static final IAlleleFlowers FLOWERS_VANILLA;
    public static final IAlleleFlowers FLOWERS_NETHER;
    public static final IAlleleFlowers FLOWERS_CACTI;
    public static final IAlleleFlowers FLOWERS_MUSHROOMS;
    public static final IAlleleFlowers FLOWERS_END;
    public static final IAlleleFlowers FLOWERS_JUNGLE;
    public static final IAlleleFlowers FLOWERS_SNOW;
    public static final IAlleleFlowers FLOWERS_WHEAT;
    public static final IAlleleFlowers FLOWERS_GOURD;
    private static final AlleleHelper alleleHelper;
    private static IAllele[] cache;

    private static IAllele getForestryAllele(String name) {
        return AlleleManager.alleleRegistry.getAllele("forestry." + name);
    }

    private static IAlleleFlowers getAlleleFl(IAlleleValue<FlowerProvider> flowerProviderIAlleleValue) {
        return (IAlleleFlowers)ForestryAlleles.getAllele(EnumBeeChromosome.FLOWER_PROVIDER, flowerProviderIAlleleValue);
    }

    private static IAlleleArea getAlleleA(IAlleleValue<Vec3i> areaIAlleleValue) {
        return (IAlleleArea)ForestryAlleles.getAllele(EnumBeeChromosome.TERRITORY, areaIAlleleValue);
    }

    private static IAlleleInteger getAlleleFlower(IAlleleValue<Integer> integerIAlleleValue) {
        return (IAlleleInteger)ForestryAlleles.getAllele(EnumBeeChromosome.FLOWERING, integerIAlleleValue);
    }

    private static IAlleleInteger getAlleleFertility(IAlleleValue<Integer> integerIAlleleValue) {
        return (IAlleleInteger)ForestryAlleles.getAllele(EnumBeeChromosome.FERTILITY, integerIAlleleValue);
    }

    private static IAlleleTolerance getAlleleT(IAlleleValue<EnumTolerance> toleranceIAlleleValue) {
        return (IAlleleTolerance)ForestryAlleles.getAllele(EnumBeeChromosome.HUMIDITY_TOLERANCE, toleranceIAlleleValue);
    }

    private static IAllele getAllele(EnumBeeChromosome chromosome, IAlleleValue value) {
        alleleHelper.set(cache, (Enum)chromosome, value);
        return cache[chromosome.ordinal()];
    }

    static void dummyLoad() {
    }

    static {
        try {
            Field f = AlleleHelper.class.getDeclaredField("instance");
            f.setAccessible(true);
            alleleHelper = (AlleleHelper)f.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        cache = new IAllele[EnumBeeChromosome.values().length];
        EFFECT_NONE = (IAlleleBeeEffect)ForestryAlleles.getForestryAllele("effectNone");
        TRUE_RECESSIVE = (IAlleleBoolean)ForestryAlleles.getForestryAllele("boolTrue");
        FALSE_RECESSIVE = (IAlleleBoolean)ForestryAlleles.getForestryAllele("boolFalse");
        LIFESPAN_SHORTEST = (IAlleleInteger)ForestryAlleles.getForestryAllele("lifespanShortest");
        LIFESPAN_SHORTER = (IAlleleInteger)ForestryAlleles.getForestryAllele("lifespanShorter");
        LIFESPAN_SHORT = (IAlleleInteger)ForestryAlleles.getForestryAllele("lifespanShort");
        LIFESPAN_SHORTENED = (IAlleleInteger)ForestryAlleles.getForestryAllele("lifespanShortened");
        LIFESPAN_NORMAL = (IAlleleInteger)ForestryAlleles.getForestryAllele("lifespanNormal");
        LIFESPAN_ELONGATED = (IAlleleInteger)ForestryAlleles.getForestryAllele("lifespanElongated");
        LIFESPAN_LONG = (IAlleleInteger)ForestryAlleles.getForestryAllele("lifespanLong");
        LIFESPAN_LONGER = (IAlleleInteger)ForestryAlleles.getForestryAllele("lifespanLonger");
        LIFESPAN_LONGEST = (IAlleleInteger)ForestryAlleles.getForestryAllele("lifespanLongest");
        SPEED_SLOWEST = (IAlleleFloat)ForestryAlleles.getForestryAllele("speedSlowest");
        SPEED_SLOWER = (IAlleleFloat)ForestryAlleles.getForestryAllele("speedSlower");
        SPEED_SLOW = (IAlleleFloat)ForestryAlleles.getForestryAllele("speedSlow");
        SPEED_NORMAL = (IAlleleFloat)ForestryAlleles.getForestryAllele("speedNormal");
        SPEED_FAST = (IAlleleFloat)ForestryAlleles.getForestryAllele("speedFast");
        SPEED_FASTER = (IAlleleFloat)ForestryAlleles.getForestryAllele("speedFaster");
        SPEED_FASTEST = (IAlleleFloat)ForestryAlleles.getForestryAllele("speedFastest");
        TOLERANCE_NONE = ForestryAlleles.getAlleleT((IAlleleValue<EnumTolerance>)EnumAllele.Tolerance.NONE);
        TOLERANCE_UP_1 = ForestryAlleles.getAlleleT((IAlleleValue<EnumTolerance>)EnumAllele.Tolerance.UP_1);
        TOLERANCE_UP_2 = ForestryAlleles.getAlleleT((IAlleleValue<EnumTolerance>)EnumAllele.Tolerance.UP_2);
        TOLERANCE_UP_3 = ForestryAlleles.getAlleleT((IAlleleValue<EnumTolerance>)EnumAllele.Tolerance.UP_3);
        TOLERANCE_UP_4 = ForestryAlleles.getAlleleT((IAlleleValue<EnumTolerance>)EnumAllele.Tolerance.UP_4);
        TOLERANCE_UP_5 = ForestryAlleles.getAlleleT((IAlleleValue<EnumTolerance>)EnumAllele.Tolerance.UP_5);
        TOLERANCE_DOWN_1 = ForestryAlleles.getAlleleT((IAlleleValue<EnumTolerance>)EnumAllele.Tolerance.DOWN_1);
        TOLERANCE_DOWN_2 = ForestryAlleles.getAlleleT((IAlleleValue<EnumTolerance>)EnumAllele.Tolerance.DOWN_2);
        TOLERANCE_DOWN_3 = ForestryAlleles.getAlleleT((IAlleleValue<EnumTolerance>)EnumAllele.Tolerance.DOWN_3);
        TOLERANCE_DOWN_4 = ForestryAlleles.getAlleleT((IAlleleValue<EnumTolerance>)EnumAllele.Tolerance.DOWN_4);
        TOLERANCE_DOWN_5 = ForestryAlleles.getAlleleT((IAlleleValue<EnumTolerance>)EnumAllele.Tolerance.DOWN_5);
        TOLERANCE_BOTH_1 = ForestryAlleles.getAlleleT((IAlleleValue<EnumTolerance>)EnumAllele.Tolerance.BOTH_1);
        TOLERANCE_BOTH_2 = ForestryAlleles.getAlleleT((IAlleleValue<EnumTolerance>)EnumAllele.Tolerance.BOTH_2);
        TOLERANCE_BOTH_3 = ForestryAlleles.getAlleleT((IAlleleValue<EnumTolerance>)EnumAllele.Tolerance.BOTH_3);
        TOLERANCE_BOTH_4 = ForestryAlleles.getAlleleT((IAlleleValue<EnumTolerance>)EnumAllele.Tolerance.BOTH_4);
        TOLERANCE_BOTH_5 = ForestryAlleles.getAlleleT((IAlleleValue<EnumTolerance>)EnumAllele.Tolerance.BOTH_5);
        FLOWERING_SLOWEST = ForestryAlleles.getAlleleFlower((IAlleleValue<Integer>)EnumAllele.Flowering.SLOWEST);
        FLOWERING_SLOWER = ForestryAlleles.getAlleleFlower((IAlleleValue<Integer>)EnumAllele.Flowering.SLOWER);
        FLOWERING_SLOW = ForestryAlleles.getAlleleFlower((IAlleleValue<Integer>)EnumAllele.Flowering.SLOW);
        FLOWERING_AVERAGE = ForestryAlleles.getAlleleFlower((IAlleleValue<Integer>)EnumAllele.Flowering.AVERAGE);
        FLOWERING_FAST = ForestryAlleles.getAlleleFlower((IAlleleValue<Integer>)EnumAllele.Flowering.FAST);
        FLOWERING_FASTER = ForestryAlleles.getAlleleFlower((IAlleleValue<Integer>)EnumAllele.Flowering.FASTER);
        FLOWERING_FASTEST = ForestryAlleles.getAlleleFlower((IAlleleValue<Integer>)EnumAllele.Flowering.FASTEST);
        FLOWERING_MAXIMUM = ForestryAlleles.getAlleleFlower((IAlleleValue<Integer>)EnumAllele.Flowering.MAXIMUM);
        TERRITORY_AVERAGE = ForestryAlleles.getAlleleA((IAlleleValue<Vec3i>)EnumAllele.Territory.AVERAGE);
        TERRITORY_LARGE = ForestryAlleles.getAlleleA((IAlleleValue<Vec3i>)EnumAllele.Territory.LARGE);
        TERRITORY_LARGER = ForestryAlleles.getAlleleA((IAlleleValue<Vec3i>)EnumAllele.Territory.LARGER);
        TERRITORY_LARGEST = ForestryAlleles.getAlleleA((IAlleleValue<Vec3i>)EnumAllele.Territory.LARGEST);
        FERTILITY_LOW = ForestryAlleles.getAlleleFertility((IAlleleValue<Integer>)EnumAllele.Fertility.LOW);
        FERTILITY_NORMAL = ForestryAlleles.getAlleleFertility((IAlleleValue<Integer>)EnumAllele.Fertility.NORMAL);
        FERTILITY_HIGH = ForestryAlleles.getAlleleFertility((IAlleleValue<Integer>)EnumAllele.Fertility.HIGH);
        FERTILITY_MAXIMUM = ForestryAlleles.getAlleleFertility((IAlleleValue<Integer>)EnumAllele.Fertility.MAXIMUM);
        FLOWERS_VANILLA = ForestryAlleles.getAlleleFl((IAlleleValue<FlowerProvider>)EnumAllele.Flowers.VANILLA);
        FLOWERS_NETHER = ForestryAlleles.getAlleleFl((IAlleleValue<FlowerProvider>)EnumAllele.Flowers.NETHER);
        FLOWERS_CACTI = ForestryAlleles.getAlleleFl((IAlleleValue<FlowerProvider>)EnumAllele.Flowers.CACTI);
        FLOWERS_MUSHROOMS = ForestryAlleles.getAlleleFl((IAlleleValue<FlowerProvider>)EnumAllele.Flowers.MUSHROOMS);
        FLOWERS_END = ForestryAlleles.getAlleleFl((IAlleleValue<FlowerProvider>)EnumAllele.Flowers.END);
        FLOWERS_JUNGLE = ForestryAlleles.getAlleleFl((IAlleleValue<FlowerProvider>)EnumAllele.Flowers.JUNGLE);
        FLOWERS_SNOW = ForestryAlleles.getAlleleFl((IAlleleValue<FlowerProvider>)EnumAllele.Flowers.SNOW);
        FLOWERS_WHEAT = ForestryAlleles.getAlleleFl((IAlleleValue<FlowerProvider>)EnumAllele.Flowers.WHEAT);
        FLOWERS_GOURD = ForestryAlleles.getAlleleFl((IAlleleValue<FlowerProvider>)EnumAllele.Flowers.GOURD);
    }
}

