/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.compat.forestry.bee;

import com.google.common.collect.Maps;
import elec332.core.compat.forestry.ForestryCompatHandler;
import elec332.core.compat.forestry.bee.IHiveEnum;
import elec332.core.tile.AbstractBlock;
import forestry.api.apiculture.hives.HiveManager;
import forestry.api.apiculture.hives.IHiveDescription;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public abstract class BlockHive<T extends Enum<T>>
extends AbstractBlock {
    private PropertyEnum<T> PROPERTY;
    @Nonnull
    private final T defaultT;
    private Map<Integer, T> metaToObject;

    public BlockHive() {
        this(null);
    }

    public BlockHive(@Nullable T defaultT) {
        super(new HiveMaterial());
        this.func_149715_a(0.4f);
        this.func_149711_c(2.5f);
        this.metaToObject = Maps.newHashMap();
        for (Enum t : (Enum[])this.getHiveTypes().getEnumConstants()) {
            this.metaToObject.put(((IHiveEnum)((Object)t)).getMeta(), t);
            for (IHiveDescription desc : ((IHiveEnum)((Object)t)).getHiveDescriptions()) {
                HiveManager.hiveRegistry.registerHive(((IHiveEnum)((Object)t)).getUid(desc), desc);
            }
        }
        if (defaultT == null) {
            defaultT = ((Enum[])this.getHiveTypes().getEnumConstants())[0];
        }
        this.defaultT = defaultT;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(this.PROPERTY, defaultT));
        this.func_149647_a(ForestryCompatHandler.getForestryBeeTab());
        for (int i = 0; i < 4; ++i) {
            this.setHarvestLevel("scoop", 0);
        }
    }

    public ItemBlock createItemBlock() {
        ItemBlock itemBlock = new ItemBlock(this){
            private final String unlName;
            {
                this.unlName = "tile." + BlockHive.this.getRegistryName().toString().toLowerCase().replace(":", ".") + ".";
            }

            public int func_77647_b(int damage) {
                Enum t = (Enum)BlockHive.this.metaToObject.get(damage);
                if (t == null) {
                    damage = ((IHiveEnum)((Object)BlockHive.this.defaultT)).getMeta();
                }
                return damage;
            }

            @Nonnull
            public String func_77667_c(ItemStack stack) {
                return this.unlName + ((IHiveEnum)((Object)((Enum)BlockHive.this.metaToObject.get(this.func_77647_b(stack.func_77952_i()))))).func_176610_l();
            }
        };
        itemBlock.setRegistryName(this.getRegistryName());
        itemBlock.func_77627_a(true);
        return itemBlock;
    }

    @Nonnull
    public abstract Class<T> getHiveTypes();

    @Nonnull
    public PropertyEnum<T> getProperty() {
        if (this.PROPERTY == null) {
            this.PROPERTY = PropertyEnum.func_177709_a((String)"hivetype", this.getHiveTypes());
        }
        return this.PROPERTY;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.getProperty()});
    }

    public int func_176201_c(IBlockState state) {
        return ((IHiveEnum)((Object)((Enum)((Object)state.func_177229_b(this.PROPERTY))))).getMeta();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        Enum t = (Enum)this.metaToObject.get(meta);
        if (t == null) {
            t = this.defaultT;
        }
        return this.getStateFromHive(t);
    }

    @Nonnull
    public IBlockState getStateFromHive(@Nonnull T t) {
        return this.func_176223_P().func_177226_a(this.PROPERTY, t);
    }

    @Nonnull
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        return ((IHiveEnum)((Object)((Enum)((Object)state.func_177229_b(this.PROPERTY))))).getDrops(world, pos, state, fortune);
    }

    @Override
    public void getSubBlocksC(@Nonnull Item item, List<ItemStack> subBlocks, CreativeTabs creativeTab) {
        for (Enum t : this.metaToObject.values()) {
            if (!((IHiveEnum)((Object)t)).showInTab()) continue;
            subBlocks.add(new ItemStack((Block)this, 1, ((IHiveEnum)((Object)t)).getMeta()));
        }
    }

    public int getLightValue(@Nonnull IBlockState state, IBlockAccess world, @Nonnull BlockPos pos) {
        return ((IHiveEnum)((Object)((Enum)((Object)state.func_177229_b(this.PROPERTY))))).getLight();
    }

    private static class HiveMaterial
    extends Material {
        private HiveMaterial() {
            super(MapColor.field_151665_m);
            this.func_76221_f();
            this.func_76225_o();
        }
    }
}

