/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.mcabstractionlayer.manager;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import elec332.core.abstraction.abstracted.AbstractClassModifier;
import elec332.core.api.annotations.AbstractionMarker;
import elec332.core.api.annotations.CopyMarker;
import elec332.core.asm.IASMClassTransformer;
import elec332.core.main.ElecCore;
import elec332.core.mcabstractionlayer.manager.AbstractionManager;
import elec332.core.util.ASMHelper;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class CompatASMHandler
implements IASMClassTransformer {
    private static final String annType = Type.getDescriptor(AbstractionMarker.class);
    private static final String copyType = Type.getDescriptor(CopyMarker.class);

    @Override
    public String getDeObfuscatedClassName() {
        return "elec332.core.";
    }

    @Override
    public byte[] transformClass(byte[] bytes) {
        ClassNode node = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)node, 0);
        node = this.transformClass(node);
        ClassWriter writer = new ClassWriter(1);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public ClassNode transformClass(ClassNode classNode) {
        AnnotationNode ann = null;
        boolean copy = false;
        if (classNode.visibleAnnotations != null) {
            for (AnnotationNode an : classNode.visibleAnnotations) {
                if (an.desc.equals(annType)) {
                    ann = an;
                }
                if (!an.desc.equals(copyType)) continue;
                copy = true;
            }
        }
        if (ann != null) {
            String mS = (String)ann.values.get(1);
            Object cp = AbstractionManager.getAbstractionLayer();
            Class impl = null;
            ClassReader linkedCLR = null;
            ClassNode cn = new ClassNode();
            linkedCLR.accept((ClassVisitor)cn, 0);
            try {
                Method m = cp.getClass().getDeclaredMethod(mS, new Class[0]);
                impl = (Class)m.invoke(cp, new Object[0]);
                linkedCLR = ASMHelper.getClassReaderFrom(impl);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (linkedCLR == null) {
                throw new RuntimeException();
            }
            if (copy) {
                block5: for (MethodNode mn : cn.methods) {
                    if (mn.visibleAnnotations == null) continue;
                    for (AnnotationNode an : mn.visibleAnnotations) {
                        if (!an.desc.equals(copyType)) continue;
                        AbstractClassModifier.MethodFixer modifier = new AbstractClassModifier.MethodFixer(impl);
                        modifier.modifyMethod(classNode.name, mn);
                        classNode.methods.add(mn);
                        continue block5;
                    }
                }
                return classNode;
            }
            cn.name = classNode.name;
            return cn;
        }
        HashMap rep = Maps.newHashMap();
        block7: for (MethodNode mn : classNode.methods) {
            if (mn.visibleAnnotations == null) continue;
            String m = null;
            for (AnnotationNode an : mn.visibleAnnotations) {
                if (!an.desc.equals(annType)) continue;
                m = (String)an.values.get(1);
                break;
            }
            if (Strings.isNullOrEmpty(m)) continue;
            try {
                String[] fiS = m.split(":");
                if (fiS.length < 1 || fiS.length > 2) {
                    throw new IllegalArgumentException();
                }
                String methodN = fiS.length == 2 ? fiS[1] : mn.name;
                m = fiS[0];
                Method me = AbstractionManager.getAbstractionLayer().getClass().getDeclaredMethod(m, new Class[0]);
                Class clz = (Class)me.invoke(AbstractionManager.getAbstractionLayer(), new Object[0]);
                ClassReader cr = ASMHelper.getClassReaderFrom(clz);
                ClassNode cn = new ClassNode();
                cr.accept((ClassVisitor)cn, 0);
                for (MethodNode mnI : cn.methods) {
                    if (!mnI.name.equals(methodN) || !mnI.desc.equals(mn.desc)) continue;
                    MethodNode nn = new MethodNode(327680, mnI.access, mn.name, mnI.desc, mnI.signature, mnI.exceptions.toArray(new String[0]));
                    mnI.accept((MethodVisitor)nn);
                    mnI = nn;
                    mnI.access = mn.access;
                    mnI.localVariables.remove(0);
                    for (int i = 0; i < mnI.instructions.size(); ++i) {
                        AbstractInsnNode ain = mnI.instructions.get(i);
                        if (!(ain instanceof VarInsnNode)) continue;
                        --((VarInsnNode)ain).var;
                    }
                    for (LocalVariableNode lv : mnI.localVariables) {
                        --lv.index;
                    }
                    rep.put(mn, mnI);
                    continue block7;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        classNode.methods.replaceAll(methodNode -> {
            if (rep.containsKey(methodNode)) {
                return (MethodNode)rep.get(methodNode);
            }
            return methodNode;
        });
        if (ElecCore.developmentEnvironment) {
            // empty if block
        }
        return classNode;
    }
}

