/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.tile;

import com.google.common.collect.Lists;
import elec332.core.main.ElecCore;
import elec332.core.tile.TileEntityBase;
import elec332.core.util.BlockStateHelper;
import elec332.core.world.WorldHelper;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileBase
extends TileEntityBase {
    public static void setWorld(TileEntity tile, World world) {
        tile.func_145834_a(world);
    }

    public void func_145829_t() {
        super.func_145829_t();
        ElecCore.tickHandler.registerCall(new Runnable(){

            @Override
            public void run() {
                if (WorldHelper.chunkLoaded(TileBase.this.func_145831_w(), TileBase.this.func_174877_v())) {
                    TileBase.this.onTileLoaded();
                }
            }
        }, this.func_145831_w());
    }

    public void func_145843_s() {
        if (!this.func_145837_r()) {
            super.func_145843_s();
            this.onTileUnloaded();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.onTileUnloaded();
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.readItemStackNBT(tagCompound);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        this.writeToItemStack(tagCompound);
        return tagCompound;
    }

    public void readItemStackNBT(NBTTagCompound tagCompound) {
    }

    public void writeToItemStack(NBTTagCompound tagCompound) {
    }

    public void onTileLoaded() {
    }

    public void onTileUnloaded() {
    }

    @Deprecated
    public void notifyNeighboursOfDataChange() {
        this.func_70296_d();
        WorldHelper.notifyNeighborsOfStateChange(this.func_145831_w(), this.func_174877_v(), this.field_145854_h);
    }

    public EnumFacing getTileFacing() {
        return (EnumFacing)this.func_145838_q().func_176203_a(this.func_145832_p()).func_177229_b(BlockStateHelper.FACING_NORMAL.getProperty());
    }

    public boolean timeCheck() {
        return this.func_145831_w().func_82737_E() % 32L == 0L;
    }

    public int getLightOpacity() {
        return 0;
    }

    public int getLightValue() {
        return 0;
    }

    public void onBlockRemoved() {
    }

    public void onBlockAdded() {
    }

    public void onBlockPlacedBy(EntityLivingBase entityLiving, ItemStack stack) {
        if (stack.func_77942_o()) {
            this.readItemStackNBT(stack.func_77978_p());
        }
    }

    public void onNeighborBlockChange(Block block) {
    }

    public void onNeighborTileChange(BlockPos neighbor) {
    }

    public boolean onBlockActivated(IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public void onBlockClicked(EntityPlayer player) {
    }

    public List<ItemStack> getDrops(int fortune) {
        return Lists.newArrayList((Object[])new ItemStack[]{this.itemStackFromNBTTile()});
    }

    public boolean onWrenched(EnumFacing forgeDirection) {
        if (forgeDirection != EnumFacing.UP && forgeDirection != EnumFacing.DOWN || this.canFaceUpOrDown()) {
            this.setFacing(forgeDirection);
            this.func_70296_d();
            this.syncData();
            this.reRenderBlock();
        }
        return false;
    }

    public boolean canFaceUpOrDown() {
        return false;
    }

    protected ItemStack itemStackFromNBTTile() {
        NBTTagCompound compound = new NBTTagCompound();
        ItemStack ret = new ItemStack(this.func_145838_q(), 1, this.func_145832_p());
        this.writeToItemStack(compound);
        ret.func_77982_d(compound);
        return ret;
    }

    public void setFacing(EnumFacing facing) {
        WorldHelper.setBlockState(this.func_145831_w(), this.field_174879_c, this.func_145838_q().func_176194_O().func_177621_b().func_177226_a(BlockStateHelper.FACING_NORMAL.getProperty(), (Comparable)facing), 3);
        this.notifyNeighborsOfChange();
    }
}

