/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import elec332.core.api.registry.ISingleObjectRegistry;
import elec332.core.api.registry.SimpleRegistries;
import elec332.core.handler.ModEventHandler;
import elec332.core.server.ServerHelper;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.command.ICommand;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;

public class CommandHelper {
    private static final ISingleObjectRegistry<ICommand> serverCommandRegistry;
    private static final ISingleObjectRegistry<ICommand> clientCommandRegistry;

    public static ISingleObjectRegistry<ICommand> getServerCommandRegistry() {
        return serverCommandRegistry;
    }

    public static ISingleObjectRegistry<ICommand> getClientCommandRegistry() {
        return clientCommandRegistry;
    }

    static {
        clientCommandRegistry = FMLCommonHandler.instance().getSide().isClient() ? new ISingleObjectRegistry<ICommand>(){

            @Override
            public boolean register(ICommand command) {
                ClientCommandHandler.instance.func_71560_a(command);
                return true;
            }

            @Override
            public Set<ICommand> getAllRegisteredObjects() {
                return Sets.newHashSet(ClientCommandHandler.instance.func_71555_a().values());
            }
        } : SimpleRegistries.emptySingleObjectRegistry();
        final ArrayList commands = Lists.newArrayList();
        serverCommandRegistry = new ISingleObjectRegistry<ICommand>(){

            @Override
            public boolean register(ICommand command) {
                commands.add(command);
                return true;
            }

            @Override
            public Set<ICommand> getAllRegisteredObjects() {
                MinecraftServer server = ServerHelper.instance.getMinecraftServer();
                return server == null ? ImmutableSet.of() : Sets.newHashSet(server.field_71321_q.func_71555_a().values());
            }
        };
        ModEventHandler.registerCallback(new ModEventHandler.Callback(){

            @Override
            public void onEvent(FMLStateEvent event) {
                if (event instanceof FMLServerStartingEvent) {
                    for (ICommand command : commands) {
                        ((FMLServerStartingEvent)event).registerServerCommand(command);
                    }
                }
            }
        });
    }
}

