/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.util;

import elec332.core.main.ElecCore;
import elec332.core.util.FileHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FileUtils;

public class IOUtil {
    @Nonnull
    public static InputStream getFromResource(@Nonnull ResourceLocation resourceLocation) throws IOException {
        String location = "/assets/" + resourceLocation.func_110624_b() + "/" + resourceLocation.func_110623_a();
        InputStream ret = FileHelper.class.getResourceAsStream(location);
        if (ret != null) {
            return ret;
        }
        throw new FileNotFoundException(location);
    }

    public static <T> T readWithPossibleBackup(@Nonnull File file, @Nonnull IObjectIO<T> io) {
        boolean b = false;
        try {
            File backup = IOUtil.getBackupFile(file);
            if (!file.exists()) {
                if (!backup.exists()) {
                    return io.returnOnReadFail();
                }
                b = true;
                return io.read(backup);
            }
            return io.read(file);
        }
        catch (IOException e) {
            try {
                ElecCore.logger.error("Error reading file, something weird must have happened when you last shutdown MC, unfortunately, some game data will probably be lost. Fixing file now....");
                String date = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date());
                File newFile = new File(file.getCanonicalPath() + "_errored_" + date);
                FileUtils.moveFile((File)file, (File)newFile);
                if (file.exists()) {
                    file.delete();
                }
                File backup = IOUtil.getBackupFile(file);
                if (b) {
                    return io.returnOnReadFail();
                }
                return io.read(backup);
            }
            catch (IOException ex) {
                ElecCore.logger.info("Failed to read backup file: " + file);
                return io.returnOnReadFail();
            }
        }
    }

    public static <T> void writeWithBackup(@Nonnull File file, @Nonnull T obj, @Nonnull IObjectIO<T> io) {
        File fileNew;
        File fileBack;
        try {
            fileBack = IOUtil.getBackupFile(file);
            fileNew = new File(file.getCanonicalPath() + "_new");
            io.write(fileNew, obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (fileBack.exists()) {
            fileBack.delete();
        }
        file.renameTo(fileBack);
        if (file.exists()) {
            file.delete();
        }
        fileNew.renameTo(file);
        if (fileNew.exists()) {
            fileNew.delete();
        }
    }

    public static File getBackupFile(@Nonnull File file) throws IOException {
        return new File(file.getCanonicalPath() + "_back");
    }

    public static void createFile(@Nonnull File file) throws IOException {
        if (!(file.exists() || file.getParentFile().mkdirs() || file.createNewFile())) {
            throw new IOException();
        }
    }

    public static class NBT {
        private static final IObjectIO<NBTTagCompound> NBTIO = new IObjectIO<NBTTagCompound>(){

            @Override
            public void write(File file, NBTTagCompound obj) throws IOException {
                NBT.write(file, obj);
            }

            @Override
            public NBTTagCompound read(File file) throws IOException {
                return NBT.read(file);
            }

            @Override
            public NBTTagCompound returnOnReadFail() {
                return new NBTTagCompound();
            }
        };

        public static NBTTagCompound readWithPossibleBackup(@Nonnull File file) {
            return IOUtil.readWithPossibleBackup(file, NBTIO);
        }

        public static void writeWithBackup(@Nonnull File file, @Nonnull NBTTagCompound tag) {
            IOUtil.writeWithBackup(file, tag, NBTIO);
        }

        public static void safeWrite(@Nonnull File file, @Nonnull NBTTagCompound tag) throws IOException {
            CompressedStreamTools.func_74793_a((NBTTagCompound)tag, (File)file);
        }

        public static NBTTagCompound read(@Nonnull File file) throws IOException {
            return CompressedStreamTools.func_74797_a((File)file);
        }

        public static void write(@Nonnull File file, @Nonnull NBTTagCompound tag) throws IOException {
            CompressedStreamTools.func_74795_b((NBTTagCompound)tag, (File)file);
        }
    }

    public static interface IObjectIO<T> {
        default public void write(File file, T obj) throws IOException {
            throw new UnsupportedOperationException();
        }

        default public T read(File file) throws IOException {
            throw new UnsupportedOperationException();
        }

        default public T returnOnReadFail() {
            throw new RuntimeException();
        }
    }
}

