/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.util;

import elec332.core.util.FMLUtil;
import javax.annotation.Nonnull;

public enum MCVersion {
    OTHER(""){

        @Override
        public boolean isHigherThan(MCVersion version) {
            return true;
        }

        @Override
        public boolean isLowerThan(MCVersion version) {
            return false;
        }
    }
    ,
    MC_1_10("1.10"),
    MC_1_10_2("1.10.2"),
    MC_1_11("1.11"),
    MC_1_11_2("1.11.2"),
    MC_1_12("1.12"),
    MC_1_12_1("1.12.1");

    private final String name;
    private static MCVersion currentVer;

    private MCVersion(String ver) {
        this.name = ver;
    }

    @Nonnull
    public static MCVersion getCurrentVersion() {
        if (currentVer == null) {
            for (MCVersion m : MCVersion.values()) {
                if (!m.name.equals(FMLUtil.getMcVersion())) continue;
                currentVer = m;
                break;
            }
            if (currentVer == null) {
                currentVer = OTHER;
            }
        }
        return currentVer;
    }

    public boolean isHigherThan(MCVersion version) {
        return this.ordinal() > version.ordinal();
    }

    public boolean isLowerThan(MCVersion version) {
        return version.ordinal() > this.ordinal();
    }
}

