/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.util.recipes;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import elec332.core.api.registry.ICraftingManager;
import elec332.core.util.recipes.ElecCoreFurnaceManager;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeHelper {
    private static final ICraftingManager craftingManager = new ICraftingManager(){
        private final Set<Function<Object, Ingredient>> parsers = Sets.newHashSet();

        @Override
        public Iterable<IRecipe> getRecipes() {
            return CraftingManager.field_193380_a;
        }

        @Override
        public void registerRecipe(IRecipe recipe) {
            ForgeRegistries.RECIPES.register((IForgeRegistryEntry)recipe);
        }

        @Override
        public void registerRecipe(IRecipe recipe, ResourceLocation name) {
            this.registerRecipe((IRecipe)recipe.setRegistryName(name));
        }

        @Override
        public void addShapelessRecipe(ResourceLocation name, ItemStack stack, Object ... recipeComponents) {
            NonNullList ingredients = NonNullList.func_191196_a();
            for (Object o : recipeComponents) {
                ingredients.add((Object)this.parseIngredient(o));
            }
            this.registerRecipe((IRecipe)new ShapelessRecipes(name.toString(), stack, ingredients), name);
        }

        @Override
        public void registerIngredientParser(Function<Object, Ingredient> parser) {
            this.parsers.add(parser);
        }

        private Ingredient parseIngredient(Object o) {
            for (Function<Object, Ingredient> parser : this.parsers) {
                Ingredient ingred = parser.apply(o);
                if (ingred == null) continue;
                return ingred;
            }
            throw new IllegalArgumentException();
        }

        @Override
        public void addRecipe(ResourceLocation name, ItemStack stack, Object ... recipeComponents) {
            String s = "";
            int i = 0;
            int j = 0;
            int k = 0;
            if (recipeComponents[i] instanceof String[]) {
                String[] astring;
                for (String s2 : astring = (String[])recipeComponents[i++]) {
                    ++k;
                    j = s2.length();
                    s = s + s2;
                }
            } else {
                while (recipeComponents[i] instanceof String) {
                    String s1 = (String)recipeComponents[i++];
                    ++k;
                    j = s1.length();
                    s = s + s1;
                }
            }
            HashMap map = Maps.newHashMap();
            while (i < recipeComponents.length) {
                Character character = (Character)recipeComponents[i];
                Ingredient ing = this.parseIngredient(recipeComponents[i + 1]);
                map.put(character, ing);
                i += 2;
            }
            NonNullList ingredients = NonNullList.func_191197_a((int)(j * k), (Object)Ingredient.field_193370_a);
            for (int l = 0; l < j * k; ++l) {
                char c0 = s.charAt(l);
                if (!map.containsKey(Character.valueOf(c0))) continue;
                ingredients.set(l, map.get(Character.valueOf(c0)));
            }
            this.registerRecipe((IRecipe)new ShapedRecipes(name.toString(), j, k, ingredients, stack), name);
        }

        @Override
        public ItemStack findMatchingResult(InventoryCrafting craftMatrix, World world) {
            return CraftingManager.func_82787_a((InventoryCrafting)craftMatrix, (World)world);
        }

        @Override
        public IRecipe findMatchingRecipe(InventoryCrafting craftMatrix, World world) {
            return CraftingManager.func_192413_b((InventoryCrafting)craftMatrix, (World)world);
        }

        @Override
        public List<ItemStack> getRemainingItems(InventoryCrafting craftMatrix, World world) {
            return CraftingManager.func_180303_b((InventoryCrafting)craftMatrix, (World)world);
        }
    };

    public static ICraftingManager getCraftingManager() {
        return craftingManager;
    }

    public static ElecCoreFurnaceManager getFurnaceManager() {
        return ElecCoreFurnaceManager.getInstance();
    }

    private static void registerParsers() {
        craftingManager.registerIngredientParser(o -> o instanceof Item ? Ingredient.func_193367_a((Item)((Item)o)) : null);
        craftingManager.registerIngredientParser(o -> o instanceof Block ? Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Block)o)}) : null);
        craftingManager.registerIngredientParser(o -> o instanceof ItemStack ? Ingredient.func_193369_a((ItemStack[])new ItemStack[]{(ItemStack)o}) : null);
        craftingManager.registerIngredientParser(o -> o instanceof String ? new OreIngredient((String)o) : null);
        craftingManager.registerIngredientParser(o -> o instanceof Ingredient ? (Ingredient)o : null);
    }

    static {
        RecipeHelper.registerParsers();
    }
}

