/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.core;

import com.google.common.base.Stopwatch;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import mod.chiselsandbits.api.APIExceptions;
import mod.chiselsandbits.api.IBitAccess;
import mod.chiselsandbits.api.IBitBrush;
import mod.chiselsandbits.api.ItemType;
import mod.chiselsandbits.api.ModKeyBinding;
import mod.chiselsandbits.bittank.TileEntityBitTank;
import mod.chiselsandbits.bittank.TileEntitySpecialRenderBitTank;
import mod.chiselsandbits.chiseledblock.BlockBitInfo;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.HarvestWorld;
import mod.chiselsandbits.chiseledblock.ItemBlockChiseled;
import mod.chiselsandbits.chiseledblock.NBTBlobConverter;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseledTESR;
import mod.chiselsandbits.chiseledblock.data.BitIterator;
import mod.chiselsandbits.chiseledblock.data.BitLocation;
import mod.chiselsandbits.chiseledblock.data.IntegerBox;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.chiseledblock.data.VoxelBlobStateReference;
import mod.chiselsandbits.chiseledblock.iterators.ChiselIterator;
import mod.chiselsandbits.chiseledblock.iterators.ChiselTypeIterator;
import mod.chiselsandbits.client.BlockColorChisled;
import mod.chiselsandbits.client.CreativeClipboardTab;
import mod.chiselsandbits.client.ItemColorBits;
import mod.chiselsandbits.client.ItemColorChisled;
import mod.chiselsandbits.client.ItemColorPatterns;
import mod.chiselsandbits.client.ModConflictContext;
import mod.chiselsandbits.client.RenderHelper;
import mod.chiselsandbits.client.TapeMeasures;
import mod.chiselsandbits.client.UndoTracker;
import mod.chiselsandbits.client.gui.ChiselsAndBitsMenu;
import mod.chiselsandbits.client.gui.SpriteIconPositioning;
import mod.chiselsandbits.commands.JsonModelExport;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ReflectionWrapper;
import mod.chiselsandbits.helpers.BitOperation;
import mod.chiselsandbits.helpers.ChiselModeManager;
import mod.chiselsandbits.helpers.ChiselToolType;
import mod.chiselsandbits.helpers.DeprecationHelper;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.helpers.ReadyState;
import mod.chiselsandbits.helpers.VoxelRegionSrc;
import mod.chiselsandbits.integration.mcmultipart.MCMultipartProxy;
import mod.chiselsandbits.interfaces.IItemScrollWheel;
import mod.chiselsandbits.interfaces.IPatternItem;
import mod.chiselsandbits.items.ItemChisel;
import mod.chiselsandbits.items.ItemChiseledBit;
import mod.chiselsandbits.modes.ChiselMode;
import mod.chiselsandbits.modes.IToolMode;
import mod.chiselsandbits.modes.PositivePatternMode;
import mod.chiselsandbits.modes.TapeMeasureModes;
import mod.chiselsandbits.network.NetworkRouter;
import mod.chiselsandbits.network.packets.PacketChisel;
import mod.chiselsandbits.network.packets.PacketRotateVoxelBlob;
import mod.chiselsandbits.network.packets.PacketSetColor;
import mod.chiselsandbits.network.packets.PacketSuppressInteraction;
import mod.chiselsandbits.registry.ModItems;
import mod.chiselsandbits.render.SmartModelManager;
import mod.chiselsandbits.render.chiseledblock.tesr.ChisledBlockRenderChunkTESR;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class ClientSide {
    private static final Random RANDOM = new Random();
    public static final ClientSide instance = new ClientSide();
    ReadyState readyState = ReadyState.PENDING_PRE;
    private final HashMap<IToolMode, SpriteIconPositioning> chiselModeIcons = new HashMap();
    private KeyBinding rotateCCW;
    private KeyBinding rotateCW;
    private KeyBinding undo;
    private KeyBinding redo;
    private KeyBinding modeMenu;
    private KeyBinding addToClipboard;
    private KeyBinding pickBit;
    private Stopwatch rotateTimer;
    public final TapeMeasures tapeMeasures = new TapeMeasures();
    public static TextureAtlasSprite undoIcon;
    public static TextureAtlasSprite redoIcon;
    public static TextureAtlasSprite trashIcon;
    public static TextureAtlasSprite swapIcon;
    public static TextureAtlasSprite placeIcon;
    boolean wasDrawing = false;
    private ItemStack previousItem;
    private int previousRotations;
    private Object previousModel;
    private Object previousCacheRef;
    private IntegerBox modelBounds;
    private boolean isVisible = true;
    private boolean isUnplaceable = true;
    private BlockPos lastPartial;
    private BlockPos lastPos;
    int displayStatus = 0;
    private BitLocation drawStart;
    private boolean loopDeath = false;
    private int lastRenderedFrame = Integer.MIN_VALUE;
    @Nonnull
    ChiselToolType lastTool = ChiselToolType.CHISEL;
    @Nonnull
    EnumHand lastHand = EnumHand.MAIN_HAND;

    public KeyBinding getKeyBinding(ModKeyBinding modKeyBinding) {
        switch (modKeyBinding) {
            case ROTATE_CCW: {
                return this.rotateCCW;
            }
            case ROTATE_CW: {
                return this.rotateCW;
            }
            case UNDO: {
                return this.undo;
            }
            case REDO: {
                return this.redo;
            }
            case ADD_TO_CLIPBOARD: {
                return this.addToClipboard;
            }
            case PICK_BIT: {
                return this.pickBit;
            }
        }
        return this.modeMenu;
    }

    public void preinit(ChiselsAndBits mod) {
        this.readyState = this.readyState.updateState(ReadyState.TRIGGER_PRE);
        ChiselsAndBits.registerWithBus(new SmartModelManager());
        ChiselsAndBits.registerWithBus(instance);
    }

    public void init(ChiselsAndBits chiselsandbits) {
        this.readyState = this.readyState.updateState(ReadyState.TRIGGER_INIT);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBlockChiseledTESR.class, (TileEntitySpecialRenderer)new ChisledBlockRenderChunkTESR());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBitTank.class, (TileEntitySpecialRenderer)new TileEntitySpecialRenderBitTank());
        for (ChiselMode chiselMode : ChiselMode.values()) {
            chiselMode.binding = this.registerKeybind(chiselMode.string.toString(), 0, "itemGroup.chiselsandbits", ModConflictContext.HOLDING_CHISEL);
        }
        for (Enum enum_ : PositivePatternMode.values()) {
            ((PositivePatternMode)enum_).binding = this.registerKeybind(((PositivePatternMode)enum_).string.toString(), 0, "itemGroup.chiselsandbits", ModConflictContext.HOLDING_POSTIVEPATTERN);
        }
        for (Enum enum_ : TapeMeasureModes.values()) {
            ((TapeMeasureModes)enum_).binding = this.registerKeybind(((TapeMeasureModes)enum_).string.toString(), 0, "itemGroup.chiselsandbits", ModConflictContext.HOLDING_TAPEMEASURE);
        }
        this.modeMenu = this.registerKeybind("mod.chiselsandbits.other.mode", 56, "itemGroup.chiselsandbits", ModConflictContext.HOLDING_MENUITEM);
        this.rotateCCW = this.registerKeybind("mod.chiselsandbits.other.rotate.ccw", 0, "itemGroup.chiselsandbits", ModConflictContext.HOLDING_ROTATEABLE);
        this.rotateCW = this.registerKeybind("mod.chiselsandbits.other.rotate.cw", 0, "itemGroup.chiselsandbits", ModConflictContext.HOLDING_ROTATEABLE);
        this.pickBit = this.registerKeybind("mod.chiselsandbits.other.pickbit", 0, "itemGroup.chiselsandbits", ModConflictContext.HOLDING_ROTATEABLE);
        this.undo = this.registerKeybind("mod.chiselsandbits.other.undo", 0, "itemGroup.chiselsandbits", (IKeyConflictContext)KeyConflictContext.IN_GAME);
        this.redo = this.registerKeybind("mod.chiselsandbits.other.redo", 0, "itemGroup.chiselsandbits", (IKeyConflictContext)KeyConflictContext.IN_GAME);
        this.addToClipboard = this.registerKeybind("mod.chiselsandbits.other.add_to_clipboard", 0, "itemGroup.chiselsandbits", (IKeyConflictContext)KeyConflictContext.IN_GAME);
        ClientCommandHandler.instance.func_71560_a((ICommand)new JsonModelExport());
    }

    private KeyBinding registerKeybind(String bindingName, int defaultKey, String groupName, IKeyConflictContext context) {
        KeyBinding kb = new KeyBinding(bindingName, context, defaultKey, groupName);
        ClientRegistry.registerKeyBinding((KeyBinding)kb);
        return kb;
    }

    public void postinit(ChiselsAndBits mod) {
        this.readyState = this.readyState.updateState(ReadyState.TRIGGER_POST);
        ModItems modItems = ChiselsAndBits.getItems();
        if (modItems.itemBlockBit != null) {
            Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)new ItemColorBits(), new Item[]{modItems.itemBlockBit});
        }
        if (modItems.itemPositiveprint != null) {
            Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)new ItemColorPatterns(), new Item[]{modItems.itemPositiveprint});
        }
        if (modItems.itemNegativeprint != null) {
            Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)new ItemColorPatterns(), new Item[]{modItems.itemNegativeprint});
        }
        if (modItems.itemMirrorprint != null) {
            Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)new ItemColorPatterns(), new Item[]{modItems.itemMirrorprint});
        }
        for (BlockChiseled blk : ChiselsAndBits.getBlocks().getConversions().values()) {
            Item item = Item.func_150898_a((Block)blk);
            Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)new ItemColorChisled(), new Item[]{item});
            Minecraft.func_71410_x().func_184125_al().func_186722_a((IBlockColor)new BlockColorChisled(), new Block[]{blk});
        }
    }

    public void registerBlockModels() {
        String modId = "chiselsandbits";
        for (BlockChiseled blk : new HashSet<BlockChiseled>(ChiselsAndBits.getBlocks().getConversions().values())) {
            this.registerMesh(blk, new ModelResourceLocation(new ResourceLocation("chiselsandbits", "block_chiseled"), "normal"));
        }
    }

    public void registerItemModels() {
        String modId = "chiselsandbits";
        final ModItems modItems = ChiselsAndBits.getItems();
        this.registerMesh((Item)modItems.itemChiselStone, 0, new ModelResourceLocation(new ResourceLocation("chiselsandbits", "chisel_stone"), "inventory"));
        this.registerMesh((Item)modItems.itemChiselIron, 0, new ModelResourceLocation(new ResourceLocation("chiselsandbits", "chisel_iron"), "inventory"));
        this.registerMesh((Item)modItems.itemChiselGold, 0, new ModelResourceLocation(new ResourceLocation("chiselsandbits", "chisel_gold"), "inventory"));
        this.registerMesh((Item)modItems.itemChiselDiamond, 0, new ModelResourceLocation(new ResourceLocation("chiselsandbits", "chisel_diamond"), "inventory"));
        this.registerMesh(modItems.itemBitBag, 0, new ModelResourceLocation(new ResourceLocation("chiselsandbits", "bit_bag"), "inventory"));
        this.registerMesh(modItems.itemWrench, 0, new ModelResourceLocation(new ResourceLocation("chiselsandbits", "wrench_wood"), "inventory"));
        this.registerMesh(modItems.itemBitSawDiamond, 0, new ModelResourceLocation(new ResourceLocation("chiselsandbits", "bitsaw_diamond"), "inventory"));
        this.registerMesh(modItems.itemTapeMeasure, 0, new ModelResourceLocation(new ResourceLocation("chiselsandbits", "tape_measure"), "inventory"));
        if (ChiselsAndBits.getBlocks().itemBitTank != null) {
            ModelLoader.setCustomMeshDefinition((Item)ChiselsAndBits.getBlocks().itemBitTank, (ItemMeshDefinition)new ItemMeshDefinition(){

                public ModelResourceLocation func_178113_a(ItemStack stack) {
                    return new ModelResourceLocation(new ResourceLocation("chiselsandbits", "bittank"), "inventory");
                }
            });
        }
        if (modItems.itemPositiveprint != null) {
            ModelBakery.registerItemVariants((Item)modItems.itemPositiveprint, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("chiselsandbits", "positiveprint"), new ResourceLocation("chiselsandbits", "positiveprint_written")});
            ModelLoader.setCustomMeshDefinition((Item)modItems.itemPositiveprint, (ItemMeshDefinition)new ItemMeshDefinition(){

                public ModelResourceLocation func_178113_a(ItemStack stack) {
                    return new ModelResourceLocation(new ResourceLocation("chiselsandbits", modItems.itemPositiveprint.isWritten(stack) ? "positiveprint_written_preview" : "positiveprint"), "inventory");
                }
            });
        }
        if (modItems.itemNegativeprint != null) {
            ModelBakery.registerItemVariants((Item)modItems.itemNegativeprint, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("chiselsandbits", "negativeprint"), new ResourceLocation("chiselsandbits", "negativeprint_written")});
            ModelLoader.setCustomMeshDefinition((Item)modItems.itemNegativeprint, (ItemMeshDefinition)new ItemMeshDefinition(){

                public ModelResourceLocation func_178113_a(ItemStack stack) {
                    return new ModelResourceLocation(new ResourceLocation("chiselsandbits", modItems.itemNegativeprint.isWritten(stack) ? "negativeprint_written_preview" : "negativeprint"), "inventory");
                }
            });
        }
        if (modItems.itemMirrorprint != null) {
            ModelBakery.registerItemVariants((Item)modItems.itemMirrorprint, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("chiselsandbits", "mirrorprint"), new ResourceLocation("chiselsandbits", "mirrorprint_written")});
            ModelLoader.setCustomMeshDefinition((Item)modItems.itemMirrorprint, (ItemMeshDefinition)new ItemMeshDefinition(){

                public ModelResourceLocation func_178113_a(ItemStack stack) {
                    return new ModelResourceLocation(new ResourceLocation("chiselsandbits", modItems.itemMirrorprint.isWritten(stack) ? "mirrorprint_written_preview" : "mirrorprint"), "inventory");
                }
            });
        }
        if (modItems.itemBlockBit != null) {
            ModelLoader.setCustomMeshDefinition((Item)modItems.itemBlockBit, (ItemMeshDefinition)new ItemMeshDefinition(){

                public ModelResourceLocation func_178113_a(ItemStack stack) {
                    return new ModelResourceLocation(new ResourceLocation("chiselsandbits", "block_bit"), "inventory");
                }
            });
        }
        for (Item item : new HashSet<Item>(ChiselsAndBits.getBlocks().getItemConversions().values())) {
            this.registerMesh(item, 0, new ModelResourceLocation(new ResourceLocation("chiselsandbits", "block_chiseled"), "inventory"));
        }
    }

    private void registerMesh(Item item, int meta, ModelResourceLocation loctaion) {
        if (item != null) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)loctaion);
        }
    }

    private void registerMesh(final Block blk, final ModelResourceLocation loctaion) {
        if (blk != null) {
            ModelLoader.setCustomStateMapper((Block)blk, (IStateMapper)new IStateMapper(){

                public Map<IBlockState, ModelResourceLocation> func_178130_a(Block blockIn) {
                    HashMap<IBlockState, ModelResourceLocation> map = new HashMap<IBlockState, ModelResourceLocation>();
                    for (IBlockState o : blk.func_176194_O().func_177619_a()) {
                        map.put(o, loctaion);
                    }
                    return map;
                }
            });
        }
    }

    @SubscribeEvent
    void registerIconTextures(TextureStitchEvent.Pre ev) {
        TextureMap map = ev.getMap();
        swapIcon = map.func_174942_a(new ResourceLocation("chiselsandbits", "icons/swap"));
        placeIcon = map.func_174942_a(new ResourceLocation("chiselsandbits", "icons/place"));
        undoIcon = map.func_174942_a(new ResourceLocation("chiselsandbits", "icons/undo"));
        redoIcon = map.func_174942_a(new ResourceLocation("chiselsandbits", "icons/redo"));
        trashIcon = map.func_174942_a(new ResourceLocation("chiselsandbits", "icons/trash"));
        for (ChiselMode chiselMode : ChiselMode.values()) {
            this.loadIcon(map, chiselMode);
        }
        for (Enum enum_ : PositivePatternMode.values()) {
            this.loadIcon(map, (IToolMode)((Object)enum_));
        }
        for (Enum enum_ : TapeMeasureModes.values()) {
            this.loadIcon(map, (IToolMode)((Object)enum_));
        }
    }

    void loadIcon(TextureMap map, IToolMode mode) {
        SpriteIconPositioning sip = new SpriteIconPositioning();
        ResourceLocation sprite = new ResourceLocation("chiselsandbits", "icons/" + mode.name().toLowerCase());
        ResourceLocation png = new ResourceLocation("chiselsandbits", "textures/icons/" + mode.name().toLowerCase() + ".png");
        sip.sprite = map.func_174942_a(sprite);
        try {
            IResource iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(png);
            BufferedImage bi = TextureUtil.func_177053_a((InputStream)iresource.func_110527_b());
            int bottom = 0;
            int right = 0;
            sip.left = bi.getWidth();
            sip.top = bi.getHeight();
            for (int x = 0; x < bi.getWidth(); ++x) {
                for (int y = 0; y < bi.getHeight(); ++y) {
                    int color = bi.getRGB(x, y);
                    int a = color >> 24 & 0xFF;
                    if (a <= 0) continue;
                    sip.left = Math.min(sip.left, (double)x);
                    right = Math.max(right, x);
                    sip.top = Math.min(sip.top, (double)y);
                    bottom = Math.max(bottom, y);
                }
            }
            sip.height = (double)bottom - sip.top + 1.0;
            sip.width = (double)right - sip.left + 1.0;
            sip.left /= (double)bi.getWidth();
            sip.width /= (double)bi.getWidth();
            sip.top /= (double)bi.getHeight();
            sip.height /= (double)bi.getHeight();
        }
        catch (IOException e) {
            sip.height = 1.0;
            sip.width = 1.0;
            sip.left = 0.0;
            sip.top = 0.0;
        }
        this.chiselModeIcons.put(mode, sip);
    }

    public SpriteIconPositioning getIconForMode(IToolMode mode) {
        return this.chiselModeIcons.get(mode);
    }

    @SubscribeEvent
    public void onRenderGUI(RenderGameOverlayEvent.Post event) {
        ScaledResolution res;
        ChiselToolType tool = this.getHeldToolType(this.lastHand);
        RenderGameOverlayEvent.ElementType type = event.getType();
        if (type == RenderGameOverlayEvent.ElementType.ALL && tool != null && tool.hasMenu()) {
            boolean wasVisible = ChiselsAndBitsMenu.instance.isVisible();
            if (this.modeMenu.func_151470_d()) {
                ChiselsAndBitsMenu.instance.actionUsed = false;
                ChiselsAndBitsMenu.instance.raiseVisibility();
            } else {
                if (!ChiselsAndBitsMenu.instance.actionUsed) {
                    if (ChiselsAndBitsMenu.instance.switchTo != null) {
                        instance.playRadialMenu();
                        ChiselModeManager.changeChiselMode(tool, ChiselModeManager.getChiselMode(this.getPlayer(), tool, EnumHand.MAIN_HAND), ChiselsAndBitsMenu.instance.switchTo);
                    }
                    if (ChiselsAndBitsMenu.instance.doAction != null) {
                        instance.playRadialMenu();
                        switch (ChiselsAndBitsMenu.instance.doAction) {
                            case REPLACE_TOGGLE: {
                                ChiselsAndBits.getConfig().replaceingBits = !ChiselsAndBits.getConfig().replaceingBits;
                                ReflectionWrapper.instance.clearHighlightedStack();
                                break;
                            }
                            case UNDO: {
                                UndoTracker.getInstance().undo();
                                break;
                            }
                            case REDO: {
                                UndoTracker.getInstance().redo();
                                break;
                            }
                            case BLACK: 
                            case BLUE: 
                            case BROWN: 
                            case CYAN: 
                            case GRAY: 
                            case GREEN: 
                            case LIGHT_BLUE: 
                            case LIME: 
                            case MAGENTA: 
                            case ORANGE: 
                            case PINK: 
                            case PURPLE: 
                            case RED: 
                            case SILVER: 
                            case WHITE: 
                            case YELLOW: {
                                PacketSetColor setColor = new PacketSetColor();
                                setColor.type = this.getHeldToolType(EnumHand.MAIN_HAND);
                                setColor.newColor = EnumDyeColor.valueOf((String)ChiselsAndBitsMenu.instance.doAction.name());
                                setColor.chatNotification = ChiselsAndBits.getConfig().chatModeNotification;
                                NetworkRouter.instance.sendToServer(setColor);
                                ReflectionWrapper.instance.clearHighlightedStack();
                            }
                        }
                    }
                }
                ChiselsAndBitsMenu.instance.actionUsed = true;
                ChiselsAndBitsMenu.instance.decreaseVisibility();
            }
            if (ChiselsAndBitsMenu.instance.isVisible()) {
                res = event.getResolution();
                ChiselsAndBitsMenu.instance.configure(res.func_78326_a(), res.func_78328_b());
                if (!wasVisible) {
                    if (ChiselsAndBits.getConfig().enableVivecraftCompatibility) {
                        ChiselsAndBitsMenu.instance.field_146297_k.field_71462_r = ChiselsAndBitsMenu.instance;
                    }
                    ChiselsAndBitsMenu.instance.field_146297_k.field_71415_G = false;
                    ChiselsAndBitsMenu.instance.field_146297_k.field_71417_B.func_74373_b();
                }
                if (ChiselsAndBitsMenu.instance.field_146297_k.field_71415_G) {
                    KeyBinding.func_74506_a();
                }
                int k1 = Mouse.getX() * res.func_78326_a() / ChiselsAndBitsMenu.instance.field_146297_k.field_71443_c;
                int l1 = res.func_78328_b() - Mouse.getY() * res.func_78328_b() / ChiselsAndBitsMenu.instance.field_146297_k.field_71440_d - 1;
                ForgeHooksClient.drawScreen((GuiScreen)ChiselsAndBitsMenu.instance, (int)k1, (int)l1, (float)event.getPartialTicks());
            } else if (wasVisible) {
                ChiselsAndBitsMenu.instance.field_146297_k.func_71381_h();
            }
        }
        if (this.undo.func_151468_f()) {
            UndoTracker.getInstance().undo();
        }
        if (this.redo.func_151468_f()) {
            UndoTracker.getInstance().redo();
        }
        if (this.addToClipboard.func_151468_f()) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71476_x != null && mc.field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK) {
                try {
                    IBitAccess access = ChiselsAndBits.getApi().getBitAccess((World)mc.field_71441_e, mc.field_71476_x.func_178782_a());
                    ItemStack is = access.getBitsAsItem(null, ItemType.CHISLED_BLOCK, false);
                    CreativeClipboardTab.addItem(is);
                }
                catch (APIExceptions.CannotBeChiseled access) {
                    // empty catch block
                }
            }
        }
        if (this.pickBit.func_151468_f()) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71476_x != null && mc.field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK) {
                try {
                    ItemStack is;
                    BitLocation bl = new BitLocation(mc.field_71476_x, true, BitOperation.CHISEL);
                    IBitAccess access = ChiselsAndBits.getApi().getBitAccess((World)mc.field_71441_e, bl.getBlockPos());
                    IBitBrush brush = access.getBitAt(bl.getBitX(), bl.getBitY(), bl.getBitZ());
                    if (brush != null && (is = brush.getItemStack(1)) != null) {
                        this.doPick(is);
                    }
                }
                catch (APIExceptions.CannotBeChiseled bl) {
                    // empty catch block
                }
            }
        }
        if (type == RenderGameOverlayEvent.ElementType.HOTBAR && ChiselsAndBits.getConfig().enableToolbarIcons) {
            Minecraft mc = Minecraft.func_71410_x();
            res = event.getResolution();
            if (!mc.field_71439_g.func_175149_v()) {
                GuiIngame sc = mc.field_71456_v;
                for (int slot = 0; slot < 9; ++slot) {
                    ItemStack stack = (ItemStack)mc.field_71439_g.field_71071_by.field_70462_a.get(slot);
                    if (stack == null || !(stack.func_77973_b() instanceof ItemChisel)) continue;
                    ChiselToolType toolType = this.getToolTypeForItemm(stack);
                    IToolMode mode = toolType.getMode(stack);
                    if (!ChiselsAndBits.getConfig().perChiselMode && tool == ChiselToolType.CHISEL) {
                        mode = ChiselModeManager.getChiselMode((EntityPlayer)mc.field_71439_g, ChiselToolType.CHISEL, this.lastHand);
                    }
                    int x = res.func_78326_a() / 2 - 90 + slot * 20 + 2;
                    int y = res.func_78328_b() - 16 - 3;
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
                    TextureAtlasSprite sprite = this.chiselModeIcons.get(mode) == null ? this.getMissingIcon() : this.chiselModeIcons.get((Object)mode).sprite;
                    GlStateManager.func_179147_l();
                    sc.func_175175_a(x + 1, y + 1, sprite, 8, 8);
                    GlStateManager.func_179084_k();
                }
            }
        }
    }

    public void playRadialMenu() {
        float volume = ChiselsAndBits.getConfig().radialMenuVolume;
        if (volume >= 1.0E-4f) {
            PositionedSoundRecord psr = new PositionedSoundRecord(SoundEvents.field_187909_gi, SoundCategory.MASTER, volume, 1.0f, this.getPlayer().func_180425_c());
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)psr);
        }
    }

    private boolean doPick(@Nonnull ItemStack result) {
        EntityPlayer player = this.getPlayer();
        for (int x = 0; x < 9; ++x) {
            ItemStack stack = player.field_71071_by.func_70301_a(x);
            if (stack == null || !stack.func_77969_a(result) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)result)) continue;
            player.field_71071_by.field_70461_c = x;
            return true;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            return false;
        }
        int slot = player.field_71071_by.func_70447_i();
        if (slot < 0 || slot >= 9) {
            slot = player.field_71071_by.field_70461_c;
        }
        player.field_71071_by.func_70299_a(slot, result);
        player.field_71071_by.field_70461_c = slot;
        int j = player.field_71069_bz.field_75151_b.size() - 9 + player.field_71071_by.field_70461_c;
        Minecraft.func_71410_x().field_71442_b.func_78761_a(player.field_71071_by.func_70301_a(player.field_71071_by.field_70461_c), j);
        return true;
    }

    public ChiselToolType getHeldToolType(EnumHand enumHand) {
        EntityPlayer player = this.getPlayer();
        if (player == null) {
            return null;
        }
        ItemStack is = player.func_184586_b(enumHand);
        return this.getToolTypeForItemm(is);
    }

    private ChiselToolType getToolTypeForItemm(ItemStack is) {
        if (is != null && is.func_77973_b() instanceof ItemChisel) {
            return ChiselToolType.CHISEL;
        }
        if (is != null && is.func_77973_b() instanceof ItemChiseledBit) {
            return ChiselToolType.BIT;
        }
        if (is != null && is.func_77973_b() == ChiselsAndBits.getItems().itemTapeMeasure) {
            return ChiselToolType.TAPEMEASURE;
        }
        if (is != null && is.func_77973_b() == ChiselsAndBits.getItems().itemPositiveprint) {
            return ChiselToolType.POSITIVEPATTERN;
        }
        if (is != null && is.func_77973_b() == ChiselsAndBits.getItems().itemNegativeprint) {
            return ChiselToolType.NEGATIVEPATTERN;
        }
        if (is != null && is.func_77973_b() == ChiselsAndBits.getItems().itemMirrorprint) {
            return ChiselToolType.MIRRORPATTERN;
        }
        return null;
    }

    @SubscribeEvent
    public void drawingInteractionPrevention(PlayerInteractEvent.RightClickBlock pie) {
        if (pie.getWorld() != null && pie.getWorld().field_72995_K) {
            ChiselToolType tool = this.getHeldToolType(pie.getHand());
            IToolMode chMode = ChiselModeManager.getChiselMode(this.getPlayer(), tool, pie.getHand());
            BitLocation other = this.getStartPos();
            if ((chMode == ChiselMode.DRAWN_REGION || tool == ChiselToolType.TAPEMEASURE) && other != null) {
                pie.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void interaction(TickEvent.ClientTickEvent event) {
        ChiselToolType tool;
        KeyBinding kb;
        PacketRotateVoxelBlob p;
        if (!this.readyState.isReady()) {
            return;
        }
        if (event.side == Side.CLIENT && event.type == TickEvent.Type.CLIENT && event.phase == TickEvent.Phase.START && !Minecraft.func_71410_x().field_71474_y.field_74312_F.func_151470_d()) {
            ItemChisel.resetDelay();
        }
        if (!this.getToolKey().func_151470_d()) {
            if (this.loopDeath) {
                if (this.drawStart != null) {
                    this.drawStart = null;
                    this.lastHand = EnumHand.MAIN_HAND;
                }
                this.lastTool = ChiselToolType.CHISEL;
            } else {
                this.loopDeath = true;
            }
        } else {
            this.loopDeath = false;
        }
        if (this.rotateCCW.func_151470_d() && (this.rotateTimer == null || this.rotateTimer.elapsed(TimeUnit.MILLISECONDS) > 200L)) {
            this.rotateTimer = Stopwatch.createStarted();
            p = new PacketRotateVoxelBlob();
            p.rotationDirection = 1;
            NetworkRouter.instance.sendToServer(p);
        }
        if (this.rotateCW.func_151470_d() && (this.rotateTimer == null || this.rotateTimer.elapsed(TimeUnit.MILLISECONDS) > 200L)) {
            this.rotateTimer = Stopwatch.createStarted();
            p = new PacketRotateVoxelBlob();
            p.rotationDirection = -1;
            NetworkRouter.instance.sendToServer(p);
        }
        for (ChiselMode chiselMode : ChiselMode.values()) {
            kb = (KeyBinding)chiselMode.binding;
            if (!kb.func_151470_d() || !(tool = this.getHeldToolType(this.lastHand)).isBitOrChisel()) continue;
            ChiselModeManager.changeChiselMode(tool, ChiselModeManager.getChiselMode(this.getPlayer(), tool, this.lastHand), chiselMode);
        }
        for (Enum enum_ : PositivePatternMode.values()) {
            kb = (KeyBinding)((PositivePatternMode)enum_).binding;
            if (!kb.func_151470_d() || (tool = this.getHeldToolType(this.lastHand)) != ChiselToolType.POSITIVEPATTERN) continue;
            ChiselModeManager.changeChiselMode(tool, ChiselModeManager.getChiselMode(this.getPlayer(), tool, this.lastHand), (IToolMode)((Object)enum_));
        }
        for (Enum enum_ : TapeMeasureModes.values()) {
            kb = (KeyBinding)((TapeMeasureModes)enum_).binding;
            if (!kb.func_151470_d() || (tool = this.getHeldToolType(this.lastHand)) != ChiselToolType.TAPEMEASURE) continue;
            ChiselModeManager.changeChiselMode(tool, ChiselModeManager.getChiselMode(this.getPlayer(), tool, this.lastHand), (IToolMode)((Object)enum_));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void drawHighlight(RenderWorldLastEvent event) {
        boolean isDrawing;
        ChiselToolType tool = this.getHeldToolType(this.lastHand);
        IToolMode chMode = ChiselModeManager.getChiselMode(this.getPlayer(), tool, this.lastHand);
        if (chMode == ChiselMode.DRAWN_REGION) {
            tool = this.lastTool;
        }
        this.tapeMeasures.setPreviewMeasure(null, null, chMode, null);
        if (tool != null && tool == ChiselToolType.TAPEMEASURE) {
            EntityPlayer player = this.getPlayer();
            RayTraceResult mop = Minecraft.func_71410_x().field_71476_x;
            World theWorld = player.field_70170_p;
            if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK) {
                BitLocation other;
                BitLocation location = new BitLocation(mop, true, BitOperation.CHISEL);
                if (theWorld.func_175723_af().func_177746_a(location.blockPos) && (other = this.getStartPos()) != null) {
                    this.tapeMeasures.setPreviewMeasure(other, location, chMode, this.getPlayer().func_184586_b(this.lastHand));
                    if (!this.getToolKey().func_151470_d()) {
                        this.tapeMeasures.addMeasure(other, location, chMode, this.getPlayer().func_184586_b(this.lastHand));
                        this.drawStart = null;
                        this.lastHand = EnumHand.MAIN_HAND;
                    }
                }
            }
        }
        this.tapeMeasures.render(event.getPartialTicks());
        boolean bl = isDrawing = (chMode == ChiselMode.DRAWN_REGION || tool == ChiselToolType.TAPEMEASURE) && this.getStartPos() != null;
        if (isDrawing != this.wasDrawing) {
            this.wasDrawing = isDrawing;
            PacketSuppressInteraction packet = new PacketSuppressInteraction();
            packet.newSetting = isDrawing;
            NetworkRouter.instance.sendToServer(packet);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void drawHighlight(DrawBlockHighlightEvent event) {
        ChiselToolType tool = this.getHeldToolType(this.lastHand);
        IToolMode chMode = ChiselModeManager.getChiselMode(this.getPlayer(), tool, this.lastHand);
        if (chMode == ChiselMode.DRAWN_REGION) {
            tool = this.lastTool;
        }
        if (tool != null && tool.isBitOrChisel() && chMode != null) {
            EntityPlayer player = event.getPlayer();
            float partialTicks = event.getPartialTicks();
            RayTraceResult mop = Minecraft.func_71410_x().field_71476_x;
            World theWorld = player.field_70170_p;
            if (mop == null || mop.field_72313_a != RayTraceResult.Type.BLOCK) {
                return;
            }
            boolean showBox = false;
            if (mop.field_72313_a == RayTraceResult.Type.BLOCK) {
                BitLocation location = new BitLocation(mop, true, this.getLastBitOperation(player, this.lastHand, this.getPlayer().func_184586_b(this.lastHand)));
                if (theWorld.func_175723_af().func_177746_a(location.blockPos)) {
                    VoxelBlob vb;
                    IBlockState state = theWorld.func_180495_p(location.blockPos);
                    boolean isChisel = this.getDrawnTool() == ChiselToolType.CHISEL;
                    boolean isBit = this.getHeldToolType(EnumHand.MAIN_HAND) == ChiselToolType.BIT;
                    TileEntityBlockChiseled data = ModUtil.getChiseledTileEntity(theWorld, location.blockPos, false);
                    VoxelRegionSrc region = new VoxelRegionSrc(theWorld, location.blockPos, 1);
                    VoxelBlob voxelBlob = vb = data != null ? data.getBlob() : new VoxelBlob();
                    if (isChisel && data == null) {
                        showBox = true;
                        vb.fill(1);
                    }
                    BitLocation other = this.getStartPos();
                    if (chMode == ChiselMode.DRAWN_REGION && other != null) {
                        ChiselIterator oneEnd = ChiselTypeIterator.create(16, location.bitX, location.bitY, location.bitZ, VoxelBlob.NULL_BLOB, ChiselMode.SINGLE, EnumFacing.UP, tool == ChiselToolType.BIT);
                        ChiselIterator otherEnd = ChiselTypeIterator.create(16, other.bitX, other.bitY, other.bitZ, VoxelBlob.NULL_BLOB, ChiselMode.SINGLE, EnumFacing.UP, tool == ChiselToolType.BIT);
                        AxisAlignedBB a = oneEnd.getBoundingBox(VoxelBlob.NULL_BLOB, false).func_72317_d((double)location.blockPos.func_177958_n(), (double)location.blockPos.func_177956_o(), (double)location.blockPos.func_177952_p());
                        AxisAlignedBB b = otherEnd.getBoundingBox(VoxelBlob.NULL_BLOB, false).func_72317_d((double)other.blockPos.func_177958_n(), (double)other.blockPos.func_177956_o(), (double)other.blockPos.func_177952_p());
                        AxisAlignedBB bb = a.func_111270_a(b);
                        double maxChiseSize = ChiselsAndBits.getConfig().maxDrawnRegionSize + 0.001;
                        if (bb.field_72336_d - bb.field_72340_a <= maxChiseSize && bb.field_72337_e - bb.field_72338_b <= maxChiseSize && bb.field_72334_f - bb.field_72339_c <= maxChiseSize) {
                            RenderHelper.drawSelectionBoundingBoxIfExists(bb, BlockPos.field_177992_a, player, partialTicks, false);
                            if (!this.getToolKey().func_151470_d()) {
                                PacketChisel pc = new PacketChisel(this.getLastBitOperation(player, this.lastHand, player.func_184586_b(this.lastHand)), location, other, EnumFacing.UP, ChiselMode.DRAWN_REGION, this.lastHand);
                                if (pc.doAction(this.getPlayer()) > 0) {
                                    NetworkRouter.instance.sendToServer(pc);
                                    ClientSide.placeSound(theWorld, location.blockPos, 0);
                                }
                                this.drawStart = null;
                                this.lastHand = EnumHand.MAIN_HAND;
                                this.lastTool = ChiselToolType.CHISEL;
                            }
                        }
                    } else {
                        VoxelBlob vx;
                        TileEntityBlockChiseled tebc;
                        TileEntity te = theWorld.func_175625_s(location.blockPos);
                        boolean isBitBlock = te instanceof TileEntityBlockChiseled;
                        boolean isBlockSupported = BlockBitInfo.supportsBlock(state);
                        if (!isBitBlock && !isBlockSupported && (tebc = ModUtil.getChiseledTileEntity(theWorld, location.blockPos, false)) != null && (vx = tebc.getBlob()).get(location.bitX, location.bitY, location.bitZ) != 0) {
                            isBitBlock = true;
                        }
                        if (theWorld.func_175623_d(location.blockPos) || isBitBlock || isBlockSupported) {
                            ChiselIterator i = ChiselTypeIterator.create(16, location.bitX, location.bitY, location.bitZ, region, ChiselMode.castMode(chMode), mop.field_178784_b, !isChisel);
                            AxisAlignedBB bb = i.getBoundingBox(vb, isChisel);
                            RenderHelper.drawSelectionBoundingBoxIfExists(bb, location.blockPos, player, partialTicks, false);
                            showBox = false;
                        } else if (isBit) {
                            VoxelBlob j = new VoxelBlob();
                            j.fill(1);
                            ChiselIterator i = ChiselTypeIterator.create(16, location.bitX, location.bitY, location.bitZ, j, ChiselMode.castMode(chMode), mop.field_178784_b, !isChisel);
                            AxisAlignedBB bb = this.snapToSide(i.getBoundingBox(j, isChisel), mop.field_178784_b);
                            RenderHelper.drawSelectionBoundingBoxIfExists(bb, location.blockPos, player, partialTicks, false);
                        }
                    }
                }
                if (!showBox) {
                    event.setCanceled(true);
                }
            }
        }
    }

    private BitOperation getLastBitOperation(EntityPlayer player, EnumHand lastHand2, ItemStack heldItem) {
        return this.lastTool == ChiselToolType.BIT ? ItemChiseledBit.getBitOperation(player, this.lastHand, player.func_184586_b(this.lastHand)) : BitOperation.CHISEL;
    }

    private AxisAlignedBB snapToSide(AxisAlignedBB boundingBox, EnumFacing sideHit) {
        if (boundingBox != null) {
            switch (sideHit) {
                case DOWN: {
                    return new AxisAlignedBB(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c, boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f);
                }
                case EAST: {
                    return new AxisAlignedBB(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c, boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f);
                }
                case NORTH: {
                    return new AxisAlignedBB(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c, boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c);
                }
                case SOUTH: {
                    return new AxisAlignedBB(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f, boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f);
                }
                case UP: {
                    return new AxisAlignedBB(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c, boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f);
                }
                case WEST: {
                    return new AxisAlignedBB(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c, boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f);
                }
            }
        }
        return boundingBox;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void drawLast(RenderWorldLastEvent event) {
        ++this.lastRenderedFrame;
        if (Minecraft.func_71410_x().field_71474_y.field_74319_N) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        float partialTicks = event.getPartialTicks();
        RayTraceResult mop = Minecraft.func_71410_x().field_71476_x;
        World theWorld = player.field_70170_p;
        ItemStack currentItem = player.func_184614_ca();
        double x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        if (mop == null) {
            return;
        }
        if (ModUtil.isHoldingPattern((EntityPlayer)player)) {
            if (mop.field_72313_a != RayTraceResult.Type.BLOCK) {
                return;
            }
            IToolMode mode = ChiselModeManager.getChiselMode((EntityPlayer)player, ChiselToolType.POSITIVEPATTERN, EnumHand.MAIN_HAND);
            BlockPos pos = mop.func_178782_a();
            BlockPos partial = null;
            IBlockState s = theWorld.func_180495_p(pos);
            if (!(s.func_177230_c() instanceof BlockChiseled || BlockBitInfo.supportsBlock(s) || MCMultipartProxy.proxyMCMultiPart.isMultiPartTileEntity(theWorld, mop.func_178782_a()))) {
                return;
            }
            if (!ChiselsAndBits.getItems().itemNegativeprint.isWritten(currentItem)) {
                return;
            }
            ItemStack item = ChiselsAndBits.getItems().itemNegativeprint.getPatternedItem(currentItem, false);
            if (item == null || !item.func_77942_o()) {
                return;
            }
            int rotations = ModUtil.getRotations((EntityLivingBase)player, ModUtil.getSide(currentItem));
            if (mode == PositivePatternMode.PLACEMENT) {
                this.doGhostForChiseledBlock(x, y, z, theWorld, (EntityPlayer)player, mop, item, item, rotations);
                return;
            }
            if (item != null) {
                Object cacheRef;
                TileEntityBlockChiseled tebc = ModUtil.getChiseledTileEntity(theWorld, pos, false);
                Object object = cacheRef = tebc != null ? tebc : s;
                if (cacheRef instanceof TileEntityBlockChiseled) {
                    cacheRef = ((TileEntityBlockChiseled)cacheRef).getBlobStateReference();
                }
                GlStateManager.func_179143_c((int)519);
                this.showGhost(currentItem, item, mop.func_178782_a(), (EntityPlayer)player, rotations, x, y, z, mop.field_178784_b, partial, cacheRef);
                GlStateManager.func_179143_c((int)515);
            }
        } else if (ModUtil.isHoldingChiseledBlock((EntityPlayer)player)) {
            if (mop.field_72313_a != RayTraceResult.Type.BLOCK) {
                return;
            }
            ItemStack item = currentItem;
            if (!item.func_77942_o()) {
                return;
            }
            int rotations = ModUtil.getRotations((EntityLivingBase)player, ModUtil.getSide(item));
            this.doGhostForChiseledBlock(x, y, z, theWorld, (EntityPlayer)player, mop, currentItem, item, rotations);
        }
    }

    private void doGhostForChiseledBlock(double x, double y, double z, World theWorld, EntityPlayer player, RayTraceResult mop, ItemStack currentItem, ItemStack item, int rotations) {
        BlockPos offset = mop.func_178782_a();
        if (player.func_70093_af()) {
            BitLocation bl = new BitLocation(mop, true, BitOperation.PLACE);
            this.showGhost(currentItem, item, bl.blockPos, player, rotations, x, y, z, mop.field_178784_b, new BlockPos(bl.bitX, bl.bitY, bl.bitZ), null);
        } else {
            TileEntityBlockChiseled tebc;
            boolean canMerge = false;
            if (currentItem.func_77942_o() && (tebc = ModUtil.getChiseledTileEntity(theWorld, offset, true)) != null) {
                VoxelBlob blob = ModUtil.getBlobFromStack(currentItem, (EntityLivingBase)player);
                canMerge = tebc.canMerge(blob);
            }
            BlockPos newOffset = offset;
            Block block = theWorld.func_180495_p(newOffset).func_177230_c();
            if (!(canMerge || player.func_70093_af() || block.func_176200_f((IBlockAccess)theWorld, newOffset))) {
                newOffset = offset.func_177972_a(mop.field_178784_b);
            }
            TileEntity newTarget = theWorld.func_175625_s(newOffset);
            if (theWorld.func_175623_d(newOffset) || theWorld.func_180495_p(newOffset).func_177230_c().func_176200_f((IBlockAccess)theWorld, newOffset) || newTarget instanceof TileEntityBlockChiseled || MCMultipartProxy.proxyMCMultiPart.isMultiPartTileEntity(theWorld, newOffset)) {
                TileEntityBlockChiseled test = ModUtil.getChiseledTileEntity(theWorld, newOffset, false);
                this.showGhost(currentItem, item, newOffset, player, rotations, x, y, z, mop.field_178784_b, null, test == null ? null : test.getBlobStateReference());
            }
        }
    }

    private void showGhost(ItemStack refItem, ItemStack item, BlockPos blockPos, EntityPlayer player, int rotationCount, double x, double y, double z, EnumFacing side, BlockPos partial, Object cacheRef) {
        IBakedModel baked;
        block15: {
            VoxelBlob blob;
            NBTBlobConverter c;
            block16: {
                VoxelBlob pattern;
                block18: {
                    block17: {
                        block14: {
                            baked = null;
                            if (this.previousCacheRef != cacheRef || !this.samePos(this.lastPos, blockPos) || this.previousItem != refItem || this.previousRotations != rotationCount || this.previousModel == null || !this.samePos(this.lastPartial, partial)) break block14;
                            baked = (IBakedModel)this.previousModel;
                            break block15;
                        }
                        int rotations = rotationCount;
                        this.previousItem = refItem;
                        this.previousRotations = rotations;
                        this.previousCacheRef = cacheRef;
                        this.lastPos = blockPos;
                        this.lastPartial = partial;
                        c = new NBTBlobConverter();
                        c.readChisleData(ModUtil.getSubCompound(item, "BlockEntityTag", false), -1);
                        blob = c.getBlob();
                        while (rotations-- > 0) {
                            blob = blob.spin(EnumFacing.Axis.Y);
                        }
                        this.modelBounds = blob.getBounds();
                        if (refItem.func_77973_b() != ChiselsAndBits.getItems().itemNegativeprint) break block16;
                        pattern = blob;
                        if (!(cacheRef instanceof VoxelBlobStateReference)) break block17;
                        blob = ((VoxelBlobStateReference)cacheRef).getVoxelBlob();
                        break block18;
                    }
                    if (!(cacheRef instanceof IBlockState)) break block16;
                    blob = new VoxelBlob();
                    blob.fill(ModUtil.getStateId((IBlockState)cacheRef));
                }
                BitIterator it = new BitIterator();
                while (it.hasNext()) {
                    if (it.getNext(pattern) != 0) continue;
                    it.setNext(blob, 0);
                }
            }
            c.setBlob(blob);
            Block blk = Block.func_149634_a((Item)item.func_77973_b());
            ItemStack is = c.getItemStack(false);
            if (is == null || is.func_77973_b() == null) {
                this.isVisible = false;
            } else {
                baked = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(is);
                baked = baked.func_188617_f().handleItemState(baked, is, player.func_130014_f_(), (EntityLivingBase)player);
                this.previousModel = baked;
                if (this.displayStatus != 0) {
                    GlStateManager.func_187449_e((int)this.displayStatus, (int)1);
                    this.displayStatus = 0;
                }
                if (refItem.func_77973_b() instanceof IPatternItem) {
                    this.isVisible = true;
                } else {
                    this.isVisible = true;
                    boolean bl = this.isUnplaceable = !ItemBlockChiseled.tryPlaceBlockAt(blk, item, player, player.func_130014_f_(), blockPos, side, EnumHand.MAIN_HAND, partial, false);
                }
            }
        }
        if (!this.isVisible) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)((double)blockPos.func_177958_n() - x), (double)((double)blockPos.func_177956_o() - y), (double)((double)blockPos.func_177952_p() - z));
        if (partial != null) {
            BlockPos t = ModUtil.getPartialOffset(side, partial, this.modelBounds);
            double fullScale = 0.0625;
            GlStateManager.func_179137_b((double)((double)t.func_177958_n() * 0.0625), (double)((double)t.func_177956_o() * 0.0625), (double)((double)t.func_177952_p() * 0.0625));
        }
        if (this.displayStatus == 0) {
            this.displayStatus = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_187423_f((int)this.displayStatus, (int)4865);
            RenderHelper.renderGhostModel(baked, player.field_70170_p, blockPos, this.isUnplaceable);
            GlStateManager.func_187415_K();
        } else {
            GlStateManager.func_179148_o((int)this.displayStatus);
        }
        GlStateManager.func_179121_F();
    }

    private boolean samePos(BlockPos lastPartial2, BlockPos partial) {
        if (lastPartial2 == partial) {
            return true;
        }
        if (lastPartial2 == null || partial == null) {
            return false;
        }
        return partial.equals((Object)lastPartial2);
    }

    public EntityPlayer getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public boolean addHitEffects(World world, RayTraceResult target, IBlockState state, ParticleManager effectRenderer) {
        ItemStack hitWith = this.getPlayer().func_184614_ca();
        if (hitWith != null && (hitWith.func_77973_b() instanceof ItemChisel || hitWith.func_77973_b() instanceof ItemChiseledBit)) {
            return true;
        }
        BlockPos pos = target.func_178782_a();
        float boxOffset = 0.1f;
        AxisAlignedBB bb = world.func_180495_p(pos).func_177230_c().func_180640_a(state, world, pos);
        if (bb == null) {
            bb = new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1));
        }
        double x = RANDOM.nextDouble() * (bb.field_72336_d - bb.field_72340_a - (double)0.2f) + (double)0.1f + bb.field_72340_a;
        double y = RANDOM.nextDouble() * (bb.field_72337_e - bb.field_72338_b - (double)0.2f) + (double)0.1f + bb.field_72338_b;
        double z = RANDOM.nextDouble() * (bb.field_72334_f - bb.field_72339_c - (double)0.2f) + (double)0.1f + bb.field_72339_c;
        switch (target.field_178784_b) {
            case DOWN: {
                y = bb.field_72338_b - (double)0.1f;
                break;
            }
            case EAST: {
                x = bb.field_72336_d + (double)0.1f;
                break;
            }
            case NORTH: {
                z = bb.field_72339_c - (double)0.1f;
                break;
            }
            case SOUTH: {
                z = bb.field_72334_f + (double)0.1f;
                break;
            }
            case UP: {
                y = bb.field_72337_e + (double)0.1f;
                break;
            }
            case WEST: {
                x = bb.field_72340_a - (double)0.1f;
                break;
            }
        }
        Particle fx = effectRenderer.func_178927_a(EnumParticleTypes.BLOCK_DUST.func_179348_c(), x, y, z, 0.0, 0.0, 0.0, new int[]{ModUtil.getStateId(state)});
        if (fx != null) {
            fx.func_70543_e(0.2f).func_70541_f(0.6f);
        }
        return true;
    }

    @SubscribeEvent
    public void wheelEvent(MouseEvent me) {
        int dwheel = me.getDwheel();
        if (me.isCanceled() || dwheel == 0) {
            return;
        }
        EntityPlayer player = instance.getPlayer();
        ItemStack is = player.func_184614_ca();
        if (dwheel != 0 && is != null && is.func_77973_b() instanceof IItemScrollWheel && player.func_70093_af()) {
            ((IItemScrollWheel)is.func_77973_b()).scroll(player, is, dwheel);
            me.setCanceled(true);
        }
    }

    public static void placeSound(World world, BlockPos pos, int stateID) {
        IBlockState state = ModUtil.getStateById(stateID);
        Block block = state.func_177230_c();
        world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, DeprecationHelper.getSoundType(block).func_185841_e(), SoundCategory.BLOCKS, (DeprecationHelper.getSoundType(block).func_185843_a() + 1.0f) / 16.0f, DeprecationHelper.getSoundType(block).func_185847_b() * 0.9f, false);
    }

    public static void breakSound(World world, BlockPos pos, int extractedState) {
        IBlockState state = ModUtil.getStateById(extractedState);
        Block block = state.func_177230_c();
        world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, DeprecationHelper.getSoundType(block).func_185845_c(), SoundCategory.BLOCKS, (DeprecationHelper.getSoundType(block).func_185843_a() + 1.0f) / 16.0f, DeprecationHelper.getSoundType(block).func_185847_b() * 0.9f, false);
    }

    public int getLastRenderedFrame() {
        return this.lastRenderedFrame;
    }

    public BitLocation getStartPos() {
        return this.drawStart;
    }

    public void pointAt(@Nonnull ChiselToolType type, @Nonnull BitLocation pos, @Nonnull EnumHand hand) {
        if (this.drawStart == null) {
            this.drawStart = pos;
            this.lastTool = type;
            this.lastHand = hand;
        }
    }

    KeyBinding getToolKey() {
        if (this.lastTool == ChiselToolType.CHISEL) {
            return Minecraft.func_71410_x().field_71474_y.field_74312_F;
        }
        return Minecraft.func_71410_x().field_71474_y.field_74313_G;
    }

    public boolean addBlockDestroyEffects(@Nonnull World world, @Nonnull BlockPos pos, IBlockState state, ParticleManager effectRenderer) {
        if (!state.func_177230_c().isAir(state, (IBlockAccess)world, pos)) {
            state = state.func_185899_b((IBlockAccess)new HarvestWorld(state), pos);
            int StateID = ModUtil.getStateId(state);
            int i = 4;
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    for (int l = 0; l < 4; ++l) {
                        double d0 = (double)pos.func_177958_n() + ((double)j + 0.5) / 4.0;
                        double d1 = (double)pos.func_177956_o() + ((double)k + 0.5) / 4.0;
                        double d2 = (double)pos.func_177952_p() + ((double)l + 0.5) / 4.0;
                        effectRenderer.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), d0, d1, d2, d0 - (double)pos.func_177958_n() - 0.5, d1 - (double)pos.func_177956_o() - 0.5, d2 - (double)pos.func_177952_p() - 0.5, new int[]{StateID});
                    }
                }
            }
        }
        return true;
    }

    public TextureAtlasSprite getMissingIcon() {
        return Minecraft.func_71410_x().func_147117_R().func_174944_f();
    }

    public String getModeKey() {
        return this.getKeyName(this.modeMenu);
    }

    public ChiselToolType getDrawnTool() {
        return this.lastTool;
    }

    public boolean holdingShift() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public String getKeyName(KeyBinding bind) {
        if (bind == null) {
            return LocalStrings.noBind.getLocal();
        }
        if (bind.func_151463_i() == 0 && bind.func_151469_h() != 0) {
            return this.makeMoreFrendly(GameSettings.func_74298_c((int)bind.func_151469_h()));
        }
        if (bind.func_151463_i() == 0) {
            return '\"' + DeprecationHelper.translateToLocal(bind.func_151464_g());
        }
        return this.makeMoreFrendly(bind.getDisplayName());
    }

    private String makeMoreFrendly(String displayName) {
        return displayName.replace("LMENU", LocalStrings.leftAlt.getLocal()).replace("RMENU", LocalStrings.rightAlt.getLocal()).replace("LSHIFT", LocalStrings.leftShift.getLocal()).replace("RSHIFT", LocalStrings.rightShift.getLocal());
    }
}

