/*
 * Decompiled with CFR 0.152.
 */
package c4.colytra.core.util;

import baubles.api.BaublesApi;
import c4.colytra.common.items.ItemElytraBauble;
import c4.colytra.core.util.ConfigHandler;
import c4.colytra.proxy.CommonProxy;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemElytra;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;

public class ColytraUtil {
    public static ItemStack findAnyColytra(EntityLivingBase entityLivingBase) {
        ItemStack bauble;
        ItemStack chestplate = ColytraUtil.findColytraChest(entityLivingBase);
        if (chestplate != ItemStack.field_190927_a) {
            return chestplate;
        }
        if (CommonProxy.baublesLoaded && (bauble = ColytraUtil.findColytraBauble(entityLivingBase)) != ItemStack.field_190927_a) {
            return bauble;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack findColytraChest(EntityLivingBase entityLivingBase) {
        ItemStack chestplate = entityLivingBase.func_184582_a(EntityEquipmentSlot.CHEST);
        if (chestplate.func_77973_b() instanceof ItemElytra || chestplate.func_77942_o() && chestplate.func_77978_p().func_74764_b("Elytra Upgrade")) {
            return chestplate;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean isUsable(ItemStack itemstack) {
        if (itemstack.func_77942_o() && itemstack.func_77978_p().func_74764_b("Elytra Upgrade")) {
            NBTTagCompound compound = itemstack.func_179543_a("Elytra Upgrade");
            int durability = compound.func_74762_e("Durability");
            boolean isActive = compound.func_74762_e("Active") == 1;
            switch (ConfigHandler.durabilityMode) {
                case "Infinite": {
                    return isActive;
                }
                case "Chestplate": {
                    IEnergyStorage energyStorage = (IEnergyStorage)itemstack.getCapability(CapabilityEnergy.ENERGY, null);
                    if (energyStorage != null && energyStorage.getEnergyStored() > 0) {
                        return isActive;
                    }
                    return itemstack.func_77984_f() && itemstack.func_77952_i() < itemstack.func_77958_k() - 1 && isActive;
                }
            }
            return durability > 1 && isActive;
        }
        return itemstack.func_77952_i() < itemstack.func_77958_k() - 1;
    }

    @Optional.Method(modid="baubles")
    public static ItemStack findColytraBauble(EntityLivingBase entity) {
        EntityPlayer player;
        ItemStack stack;
        if (entity instanceof EntityPlayer && (stack = BaublesApi.getBaublesHandler((EntityPlayer)(player = (EntityPlayer)entity)).getStackInSlot(5)).func_77973_b() instanceof ItemElytraBauble) {
            return stack;
        }
        return ItemStack.field_190927_a;
    }
}

