/*
 * Decompiled with CFR 0.152.
 */
package c4.colytra.core.util;

import c4.colytra.Colytra;
import c4.colytra.proxy.CommonProxy;
import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Level;

public class ConfigHandler {
    private static final String CATEGORY_GENERAL = "general";
    public static Configuration cfg;
    private static String[] blacklist;
    private static String[] whitelist;
    public static ArrayList<Item> blacklisted;
    public static ArrayList<Item> whitelisted;
    public static boolean disableBauble;
    public static String durabilityMode;
    public static String itemPermissionMode;
    private static String[] durabilityModeList;

    public static void readConfig() {
        try {
            cfg = CommonProxy.config;
            cfg.load();
            ConfigHandler.initConfig();
        }
        catch (Exception e1) {
            Colytra.logger.log(Level.ERROR, "Problem loading config file!", (Throwable)e1);
        }
        finally {
            if (cfg.hasChanged()) {
                cfg.save();
            }
        }
    }

    private static void initConfig() {
        cfg.addCustomCategoryComment(CATEGORY_GENERAL, "General configuration");
        if (CommonProxy.baublesLoaded) {
            Property prop = cfg.get(CATEGORY_GENERAL, "Disable Bauble", disableBauble);
            prop.setLanguageKey("Disable Bauble");
            prop.setComment("Set to true to disable the elytra bauble [default: " + disableBauble + "]");
            prop.setRequiresMcRestart(true);
            disableBauble = prop.getBoolean(disableBauble);
        }
        itemPermissionMode = cfg.getString("Permission Mode", CATEGORY_GENERAL, itemPermissionMode, "The item permission mode to use for elytra chestplates (Blacklist, Whitelist)", new String[]{"Blacklist", "Whitelist"});
        whitelist = cfg.getStringList("Whitelist", CATEGORY_GENERAL, whitelist, "A list of items that can be attached with an elytra when Whitelist mode is enabled");
        blacklist = cfg.getStringList("Blacklist", CATEGORY_GENERAL, blacklist, "A list of items that cannot be attached with an elytra when Blacklist mode is enabled");
        durabilityMode = cfg.getString("Colytra Durability Mode", CATEGORY_GENERAL, durabilityMode, "How to handle durability for elytras attached to chestplates\nNormal - Elytras on chestplates will use their own durability\nInfinite - Elytras on chestplates will not use any durability\nChestplate - Elytras on chestplates will use chestplate durability", durabilityModeList);
        ConfigHandler.initLists();
    }

    private static void initLists() {
        Item item;
        blacklisted = new ArrayList();
        whitelisted = new ArrayList();
        if (blacklist.length > 0) {
            for (String s : blacklist) {
                item = Item.func_111206_d((String)s);
                if (item == null) continue;
                blacklisted.add(item);
            }
        }
        if (whitelist.length > 0) {
            for (String s : whitelist) {
                item = Item.func_111206_d((String)s);
                if (item == null) continue;
                whitelisted.add(item);
            }
        }
    }

    static {
        blacklist = new String[0];
        whitelist = new String[0];
        disableBauble = false;
        durabilityMode = "Normal";
        itemPermissionMode = "Blacklist";
        durabilityModeList = new String[]{"Normal", "Infinite", "Chestplate"};
    }

    @Mod.EventBusSubscriber
    private static class ConfigChangeHandler {
        private ConfigChangeHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent e) {
            if (e.getModID().equals("colytra")) {
                ConfigHandler.initConfig();
                if (cfg.hasChanged()) {
                    cfg.save();
                }
            }
        }
    }
}

