/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.api.backpack.variant;

import com.google.common.base.Preconditions;
import gr8pefish.ironbackpacks.api.IronBackpacksAPI;
import gr8pefish.ironbackpacks.api.backpack.variant.BackpackSize;
import gr8pefish.ironbackpacks.api.backpack.variant.BackpackSpecialty;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class BackpackType
extends IForgeRegistryEntry.Impl<BackpackType> {
    @Nonnull
    private final ResourceLocation identifier;
    @Nonnegative
    private final int tier;
    @Nonnegative
    private final int baseMaxUpgradePoints;
    private final boolean hasSpecialties;
    @Nonnull
    private final BackpackSize baseBackpackSize;

    public BackpackType(@Nonnull ResourceLocation identifier, @Nonnegative int tier, @Nonnegative int baseMaxUpgradePoints, boolean hasSpecialties, @Nonnull BackpackSize baseBackpackSize) {
        Preconditions.checkNotNull((Object)identifier, (Object)"Identifier cannot be null");
        Preconditions.checkArgument((tier >= 0 ? 1 : 0) != 0, (Object)"Tier cannot be negative");
        Preconditions.checkArgument((baseMaxUpgradePoints >= 0 ? 1 : 0) != 0, (Object)"Max points cannot be negative");
        this.identifier = identifier;
        this.tier = tier;
        this.baseMaxUpgradePoints = baseMaxUpgradePoints;
        this.hasSpecialties = hasSpecialties;
        this.baseBackpackSize = baseBackpackSize;
        this.setRegistryName(identifier);
    }

    public BackpackType(@Nonnull ResourceLocation identifier, @Nonnegative int tier, @Nonnegative int maxPoints, boolean hasSpecialties, @Nonnegative int baseSizeCols, @Nonnegative int baseSizeRows) {
        this(identifier, tier, maxPoints, hasSpecialties, new BackpackSize(baseSizeCols, baseSizeRows));
    }

    @Nonnull
    public ResourceLocation getIdentifier() {
        return this.identifier;
    }

    @Nonnegative
    public int getTier() {
        return this.tier;
    }

    @Nonnegative
    public int getBaseMaxUpgradePoints() {
        return this.baseMaxUpgradePoints;
    }

    public boolean hasSpecialties() {
        return this.hasSpecialties;
    }

    @Nonnull
    public BackpackSize getBaseBackpackSize() {
        return this.baseBackpackSize;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("identifier", (Object)this.identifier).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BackpackType)) {
            return false;
        }
        BackpackType that = (BackpackType)((Object)o);
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean isNull() {
        return this.getIdentifier().equals((Object)IronBackpacksAPI.NULL);
    }

    @Nonnegative
    public int applyUpgradePointModifierFromBackpackSpecialty(@Nonnull BackpackSpecialty specialty, @Nonnegative int pointIncrease) {
        Preconditions.checkNotNull((Object)((Object)specialty), (Object)"specialty cannot be null");
        Preconditions.checkArgument((pointIncrease >= 0 ? 1 : 0) != 0, (Object)"pointIncrease cannot be negative");
        if (specialty == BackpackSpecialty.UPGRADE) {
            return this.baseMaxUpgradePoints + pointIncrease;
        }
        return this.baseMaxUpgradePoints;
    }

    @Nonnegative
    public int applyDefaultUpgradePointModifierFromBackpackSpecialty(@Nonnull BackpackSpecialty specialty) {
        Preconditions.checkNotNull((Object)((Object)specialty), (Object)"Specialty cannot be null.");
        return this.applyUpgradePointModifierFromBackpackSpecialty(specialty, 5);
    }
}

