/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.container;

import com.google.common.base.Preconditions;
import gr8pefish.ironbackpacks.IronBackpacks;
import gr8pefish.ironbackpacks.api.backpack.BackpackInfo;
import gr8pefish.ironbackpacks.api.backpack.IBackpack;
import gr8pefish.ironbackpacks.api.backpack.variant.BackpackSize;
import gr8pefish.ironbackpacks.util.InventoryBlacklist;
import invtweaks.api.container.ChestContainer;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;

@ChestContainer
public class ContainerBackpack
extends Container {
    @Nonnull
    private final BackpackInfo backpackInfo;
    @Nonnull
    private final BackpackSize backpackSize;
    @Nonnull
    private final ItemStack backpackStack;
    private int blocked = -1;

    public ContainerBackpack(@Nonnull ItemStack backpackStack, @Nonnull InventoryPlayer inventoryPlayer, @Nonnull EnumHand hand) {
        Preconditions.checkNotNull((Object)backpackStack, (Object)"backpackStack cannot be null");
        Preconditions.checkNotNull((Object)inventoryPlayer, (Object)"inventoryPlayer cannot be null");
        Preconditions.checkNotNull((Object)hand, (Object)"EnumHand cannot be null");
        BackpackInfo backpackInfo = BackpackInfo.fromStack(backpackStack);
        IItemHandlerModifiable itemHandler = backpackInfo.getInventory();
        Preconditions.checkNotNull((Object)backpackInfo, (Object)"backpackInfo cannot be null");
        Preconditions.checkNotNull((Object)itemHandler, (Object)"itemHandler cannot be null");
        this.backpackInfo = backpackInfo;
        this.backpackStack = backpackStack;
        this.backpackSize = backpackInfo.getVariant().getBackpackSize();
        this.setupSlots(inventoryPlayer, (IItemHandler)itemHandler, hand);
    }

    public boolean func_75145_c(@Nonnull EntityPlayer player) {
        return true;
    }

    public void func_75141_a(int slotID, ItemStack stack) {
        super.func_75141_a(slotID, stack);
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        Slot slot = this.func_75139_a(slotIndex);
        if (!slot.func_82869_a(player)) {
            return slot.func_75211_c();
        }
        if (slotIndex == this.blocked) {
            return ItemStack.field_190927_a;
        }
        if (!slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = slot.func_75211_c();
        ItemStack newStack = stack.func_77946_l();
        if (InventoryBlacklist.INSTANCE.isBlacklisted(slot.func_75211_c())) {
            return ItemStack.field_190927_a;
        }
        if (slotIndex < this.backpackSize.getTotalSize()) {
            if (!this.func_75135_a(stack, this.backpackSize.getTotalSize(), this.field_75151_b.size(), true)) {
                return ItemStack.field_190927_a;
            }
            slot.func_75218_e();
        } else if (!this.func_75135_a(stack, 0, this.backpackSize.getTotalSize(), false)) {
            return ItemStack.field_190927_a;
        }
        if (stack.func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
        } else {
            slot.func_75218_e();
        }
        return slot.func_190901_a(player, newStack);
    }

    @Nonnull
    public ItemStack func_184996_a(int slotId, int button, ClickType flag, EntityPlayer player) {
        if (slotId < 0 || slotId > this.field_75151_b.size()) {
            return super.func_184996_a(slotId, button, flag, player);
        }
        Slot slot = (Slot)this.field_75151_b.get(slotId);
        if (!this.canTake(slotId, slot, button, player, flag)) {
            return slot.func_75211_c();
        }
        return super.func_184996_a(slotId, button, flag, player);
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        if (!(this.backpackStack.func_77973_b() instanceof IBackpack)) {
            IronBackpacks.LOGGER.debug("Attempted to close backpack on non-IBackpack item {}. Changes will not persist.");
            return;
        }
        ((IBackpack)this.backpackStack.func_77973_b()).updateBackpack(this.backpackStack, this.backpackInfo);
    }

    public boolean canTake(int slotId, Slot slot, int button, EntityPlayer player, ClickType clickType) {
        if (slotId == this.blocked) {
            return false;
        }
        if (slotId <= this.backpackSize.getTotalSize() - 1) {
            if (InventoryBlacklist.INSTANCE.isBlacklisted(player.field_71071_by.func_70445_o())) {
                return false;
            }
            if (player.field_71071_by.func_70445_o().func_77973_b() instanceof IBackpack) {
                return false;
            }
        }
        if (clickType == ClickType.SWAP) {
            int hotbarId = this.backpackSize.getTotalSize() + 27 + button;
            if (this.blocked == hotbarId) {
                return false;
            }
            Slot hotbarSlot = this.func_75139_a(hotbarId);
            if (slotId <= this.backpackSize.getTotalSize() - 1) {
                if (InventoryBlacklist.INSTANCE.isBlacklisted(slot.func_75211_c()) || InventoryBlacklist.INSTANCE.isBlacklisted(hotbarSlot.func_75211_c())) {
                    return false;
                }
                if (slot.func_75211_c().func_77973_b() instanceof IBackpack || hotbarSlot.func_75211_c().func_77973_b() instanceof IBackpack) {
                    return false;
                }
            }
        }
        return true;
    }

    @Nonnull
    public String getName() {
        return this.backpackStack.func_82833_r();
    }

    public BackpackSize getBackpackSize() {
        return this.backpackSize;
    }

    private void setupSlots(@Nonnull InventoryPlayer inventoryPlayer, @Nonnull IItemHandler itemHandler, @Nonnull EnumHand hand) {
        Preconditions.checkNotNull((Object)inventoryPlayer, (Object)"inventoryPlayer cannot be null");
        Preconditions.checkNotNull((Object)itemHandler, (Object)"itemHandler cannot be null");
        this.setupBackpackSlots(itemHandler);
        this.setupPlayerSlots(inventoryPlayer, hand);
    }

    private void setupBackpackSlots(@Nonnull IItemHandler itemHandler) {
        Preconditions.checkNotNull((Object)itemHandler, (Object)"itemHandler cannot be null");
        int xOffset = 1 + this.getContainerInvXOffset();
        int yOffset = 1 + this.getBorderTop();
        int y = 0;
        while (y < this.backpackSize.getRows()) {
            for (int x = 0; x < this.backpackSize.getColumns(); ++x) {
                this.func_75146_a((Slot)new SlotItemHandler(itemHandler, x + y * this.backpackSize.getColumns(), xOffset + x * 18, yOffset));
            }
            ++y;
            yOffset += 18;
        }
    }

    private void setupPlayerSlots(@Nonnull InventoryPlayer inventoryPlayer, @Nonnull EnumHand hand) {
        Preconditions.checkNotNull((Object)inventoryPlayer, (Object)"inventoryPlayer cannot be null");
        int xOffset = 1 + this.getPlayerInvXOffset();
        int yOffset = 1 + this.getBorderTop() + this.getContainerInvHeight() + this.getBufferInventory();
        int y = 0;
        while (y < 3) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, x + y * 9 + 9, xOffset + x * 18, yOffset));
            }
            ++y;
            yOffset += 18;
        }
        yOffset += this.getBufferHotbar();
        for (int x = 0; x < 9; ++x) {
            Slot slot = this.func_75146_a(new Slot((IInventory)inventoryPlayer, x, xOffset + x * 18, yOffset){

                public boolean func_82869_a(EntityPlayer playerIn) {
                    return this.field_75222_d != ContainerBackpack.this.blocked;
                }
            });
            if (x != inventoryPlayer.field_70461_c || hand != EnumHand.MAIN_HAND) continue;
            this.blocked = slot.field_75222_d;
        }
    }

    public int getBorderTop() {
        return 17;
    }

    public int getBorderSide() {
        return 7;
    }

    public int getBorderBottom() {
        return 7;
    }

    public int getBufferInventory() {
        return 13;
    }

    public int getBufferHotbar() {
        return 4;
    }

    public int getMaxColumns() {
        return BackpackSize.MAX.getColumns();
    }

    public int getMaxRows() {
        return BackpackSize.MAX.getRows();
    }

    public int getWidth() {
        return Math.max(this.backpackSize.getColumns(), 9) * 18 + this.getBorderSide() * 2;
    }

    public int getHeight() {
        return this.getBorderTop() + this.backpackSize.getRows() * 18 + this.getBufferInventory() + 72 + this.getBufferHotbar() + this.getBorderBottom();
    }

    public int getContainerInvWidth() {
        return this.backpackSize.getColumns() * 18;
    }

    public int getContainerInvHeight() {
        return this.backpackSize.getRows() * 18;
    }

    public int getContainerInvXOffset() {
        return this.getBorderSide() + Math.max(0, (this.getPlayerInvWidth() - this.getContainerInvWidth()) / 2);
    }

    public int getPlayerInvXOffset() {
        return this.getBorderSide() + Math.max(0, (this.getContainerInvWidth() - this.getPlayerInvWidth()) / 2);
    }

    public int getPlayerInvWidth() {
        return 162;
    }

    public int getPlayerInvHeight() {
        return 72 + this.getBufferHotbar();
    }

    @ChestContainer.RowSizeCallback
    public int getRowSize() {
        return Math.max(this.getBackpackSize().getRows(), 9);
    }
}

