/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.util;

import com.google.common.collect.Lists;
import gr8pefish.ironbackpacks.api.backpack.BackpackInfo;
import gr8pefish.ironbackpacks.api.backpack.IBackpack;
import gr8pefish.ironbackpacks.util.Predicates;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class Utils {
    @Nonnull
    public static ActionResult<ItemStack> getBackpack(@Nonnull EntityPlayer player, @Nonnull Predicate<Pair<ItemStack, IBackpack>> requirements) {
        IItemHandler itemHandler = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (itemHandler == null) {
            throw new IllegalArgumentException("Player inventory should never be null.");
        }
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack foundStack = itemHandler.getStackInSlot(slot);
            if (foundStack.func_190926_b() || !(foundStack.func_77973_b() instanceof IBackpack) || !requirements.test((Pair<ItemStack, IBackpack>)Pair.of((Object)foundStack, (Object)((IBackpack)foundStack.func_77973_b())))) continue;
            EnumActionResult result = slot >= 0 && slot < 9 ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
            return ActionResult.newResult((EnumActionResult)result, (Object)foundStack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)ItemStack.field_190927_a);
    }

    @Nonnull
    public static ActionResult<ItemStack> getBackpack(@Nonnull EntityPlayer player) {
        return Utils.getBackpack(player, Predicates.alwaysTrue());
    }

    @Nonnull
    public static List<ActionResult<ItemStack>> getAllBackpacks(@Nonnull EntityPlayer player, @Nonnull Predicate<Pair<ItemStack, IBackpack>> requirements) {
        IItemHandler itemHandler = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (itemHandler == null) {
            throw new IllegalArgumentException("Player inventory should never be null.");
        }
        ArrayList backpacks = Lists.newArrayList();
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack foundStack = itemHandler.getStackInSlot(slot);
            if (foundStack.func_190926_b() || !(foundStack.func_77973_b() instanceof IBackpack) || !requirements.test((Pair<ItemStack, IBackpack>)Pair.of((Object)foundStack, (Object)((IBackpack)foundStack.func_77973_b())))) continue;
            EnumActionResult result = slot >= 0 && slot < 9 ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
            backpacks.add(ActionResult.newResult((EnumActionResult)result, (Object)foundStack));
        }
        return backpacks;
    }

    @Nonnull
    public static List<ActionResult<ItemStack>> getAllBackpacks(@Nonnull EntityPlayer player) {
        return Utils.getAllBackpacks(player, Predicates.alwaysTrue());
    }

    @Nonnull
    public static BackpackInfo getBackpackInfoFromStack(@Nonnull ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IBackpack) {
            return ((IBackpack)stack.func_77973_b()).getBackpackInfo(stack);
        }
        throw new RuntimeException("Tried to get backpack info from an ItemStack that isn't an IBackpack. Wrong item: " + stack);
    }

    @Nonnull
    public static ItemStack getNonequippedBackpackFromInventory(EntityPlayer player, EnumHand hand) {
        ItemStack selected = ItemStack.field_190927_a;
        if (player.func_184586_b(hand).func_77973_b() instanceof IBackpack) {
            selected = player.func_184586_b(hand);
        } else {
            NonNullList offHandInventory = player.field_71071_by.field_184439_c;
            for (ItemStack stack : offHandInventory) {
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IBackpack)) continue;
                selected = stack;
                break;
            }
            NonNullList mainInventory = player.field_71071_by.field_70462_a;
            for (ItemStack stack : mainInventory) {
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IBackpack)) continue;
                selected = stack;
                break;
            }
        }
        return selected;
    }
}

