/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.integration.forestry;

import com.google.common.collect.Maps;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IMutation;
import java.util.HashMap;
import java.util.Map;
import li.cil.oc.api.driver.Converter;

public class ConverterIAlleles
implements Converter {
    @Override
    public void convert(Object value, Map<Object, Object> output) {
        if (value instanceof IMutation) {
            IAlleleSpecies allele2;
            IMutation mutation = (IMutation)value;
            IAlleleSpecies allele1 = mutation.getAllele0();
            if (allele1 != null) {
                HashMap allelMap1 = Maps.newHashMap();
                this.convert(allele1, allelMap1);
                output.put("allele1", allelMap1);
            }
            if ((allele2 = mutation.getAllele1()) != null) {
                HashMap allelMap2 = Maps.newHashMap();
                this.convert(allele2, allelMap2);
                output.put("allele2", allelMap2);
            }
            output.put("chance", Float.valueOf(mutation.getBaseChance()));
            output.put("specialConditions", mutation.getSpecialConditions().toArray());
        }
        if (value instanceof IAlleleSpecies) {
            this.convertAlleleSpecies((IAlleleSpecies)value, output);
        }
    }

    private void convertAlleleSpecies(IAlleleSpecies value, Map<Object, Object> output) {
        output.put("name", value.getAlleleName());
        output.put("uid", value.getUID());
    }
}

