/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.server.driver;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import li.cil.oc.OpenComputers$;
import li.cil.oc.api.detail.DriverAPI;
import li.cil.oc.api.driver.Converter;
import li.cil.oc.api.driver.DriverBlock;
import li.cil.oc.api.driver.DriverItem;
import li.cil.oc.api.driver.EnvironmentProvider;
import li.cil.oc.api.driver.InventoryProvider;
import li.cil.oc.api.driver.item.HostAware;
import li.cil.oc.api.machine.Value;
import li.cil.oc.api.network.EnvironmentHost;
import li.cil.oc.server.driver.CompoundBlockDriver;
import li.cil.oc.server.driver.Registry$;
import li.cil.oc.util.InventoryUtils$;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Unit$;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.convert.WrapAsJava$;
import scala.collection.convert.WrapAsScala$;
import scala.collection.immutable.Iterable$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Set$;
import scala.math.ScalaNumber;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class Registry$
implements DriverAPI {
    public static final Registry$ MODULE$;
    private final ArrayBuffer<DriverBlock> sidedBlocks;
    private final ArrayBuffer<DriverItem> items;
    private final ArrayBuffer<Converter> converters;
    private final ArrayBuffer<EnvironmentProvider> environmentProviders;
    private final ArrayBuffer<InventoryProvider> inventoryProviders;
    private final ArrayBuffer<Tuple2<ItemStack, scala.collection.mutable.Set<Class<?>>>> blacklist;
    private boolean locked;

    static {
        new Registry$();
    }

    public ArrayBuffer<DriverBlock> sidedBlocks() {
        return this.sidedBlocks;
    }

    public ArrayBuffer<DriverItem> items() {
        return this.items;
    }

    public ArrayBuffer<Converter> converters() {
        return this.converters;
    }

    public ArrayBuffer<EnvironmentProvider> environmentProviders() {
        return this.environmentProviders;
    }

    public ArrayBuffer<InventoryProvider> inventoryProviders() {
        return this.inventoryProviders;
    }

    public ArrayBuffer<Tuple2<ItemStack, scala.collection.mutable.Set<Class<?>>>> blacklist() {
        return this.blacklist;
    }

    public boolean locked() {
        return this.locked;
    }

    public void locked_$eq(boolean x$1) {
        this.locked = x$1;
    }

    @Override
    public void add(DriverBlock driver) {
        if (this.locked()) {
            throw new IllegalStateException("Please register all drivers in the init phase.");
        }
        if (!this.sidedBlocks().contains((Object)driver)) {
            OpenComputers$.MODULE$.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Registering block driver ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{driver.getClass().getName()})));
            this.sidedBlocks().$plus$eq((Object)driver);
        }
    }

    @Override
    public void add(DriverItem driver) {
        if (this.locked()) {
            throw new IllegalStateException("Please register all drivers in the init phase.");
        }
        if (!this.items().contains((Object)driver)) {
            OpenComputers$.MODULE$.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Registering item driver ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{driver.getClass().getName()})));
            this.items().$plus$eq((Object)driver);
        }
    }

    @Override
    public void add(Converter converter) {
        if (this.locked()) {
            throw new IllegalStateException("Please register all converters in the init phase.");
        }
        if (!this.converters().contains((Object)converter)) {
            OpenComputers$.MODULE$.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Registering converter ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{converter.getClass().getName()})));
            this.converters().$plus$eq((Object)converter);
        }
    }

    @Override
    public void add(EnvironmentProvider provider) {
        if (this.locked()) {
            throw new IllegalStateException("Please register all environment providers in the init phase.");
        }
        if (!this.environmentProviders().contains((Object)provider)) {
            OpenComputers$.MODULE$.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Registering environment provider ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{provider.getClass().getName()})));
            this.environmentProviders().$plus$eq((Object)provider);
        }
    }

    @Override
    public void add(InventoryProvider provider) {
        if (this.locked()) {
            throw new IllegalStateException("Please register all inventory providers in the init phase.");
        }
        if (!this.inventoryProviders().contains((Object)provider)) {
            OpenComputers$.MODULE$.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Registering inventory provider ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{provider.getClass().getName()})));
            this.inventoryProviders().$plus$eq((Object)provider);
        }
    }

    @Override
    public DriverBlock driverFor(World world, BlockPos pos, EnumFacing side) {
        ArrayBuffer arrayBuffer = (ArrayBuffer)this.sidedBlocks().filter((Function1)new anonfun.2(world, pos, side));
        CompoundBlockDriver compoundBlockDriver = arrayBuffer.nonEmpty() ? new CompoundBlockDriver((DriverBlock[])arrayBuffer.toArray(ClassTag$.MODULE$.apply(DriverBlock.class))) : null;
        return compoundBlockDriver;
    }

    @Override
    public DriverItem driverFor(ItemStack stack, Class<? extends EnvironmentHost> host) {
        ArrayBuffer hostAware;
        return stack.func_190926_b() ? null : ((hostAware = (ArrayBuffer)this.items().collect((PartialFunction)new Serializable(stack){
            private final ItemStack stack$1;

            public final <A1 extends DriverItem, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                HostAware hostAware;
                A1 A1 = x1;
                Object object = A1 instanceof HostAware && (hostAware = (HostAware)A1).worksWith(this.stack$1) ? hostAware : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(DriverItem x1) {
                HostAware hostAware;
                DriverItem driverItem = x1;
                boolean bl = driverItem instanceof HostAware && (hostAware = (HostAware)driverItem).worksWith(this.stack$1);
                return bl;
            }
            {
                this.stack$1 = stack$1;
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).nonEmpty() ? (DriverItem)hostAware.find((Function1)new Serializable(stack, host){
            private final ItemStack stack$1;
            private final Class host$1;

            public final boolean apply(HostAware x$2) {
                return x$2.worksWith(this.stack$1, this.host$1);
            }
            {
                this.stack$1 = stack$1;
                this.host$1 = host$1;
            }
        }).orNull(Predef$.MODULE$.$conforms()) : this.driverFor(stack));
    }

    @Override
    public DriverItem driverFor(ItemStack stack) {
        return stack.func_190926_b() ? null : (DriverItem)this.items().find((Function1)new Serializable(stack){
            private final ItemStack stack$2;

            public final boolean apply(DriverItem x$3) {
                return x$3.worksWith(this.stack$2);
            }
            {
                this.stack$2 = stack$2;
            }
        }).orNull(Predef$.MODULE$.$conforms());
    }

    @Override
    @Deprecated
    public Class<?> environmentFor(ItemStack stack) {
        return (Class)((TraversableOnce)this.environmentProviders().map((Function1)new Serializable(stack){
            private final ItemStack stack$3;

            public final Class<?> apply(EnvironmentProvider provider) {
                return provider.getEnvironment(this.stack$3);
            }
            {
                this.stack$3 = stack$3;
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).collectFirst((PartialFunction)new Serializable(){

            public final <A1 extends Class<?>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1;
                A1 A12 = x2;
                Object object = A12 != null ? (A1 = A12) : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Class<?> x2) {
                Class<?> clazz = x2;
                boolean bl = clazz != null;
                return bl;
            }
        }).orNull(Predef$.MODULE$.$conforms());
    }

    @Override
    public java.util.Set<Class<?>> environmentsFor(ItemStack stack) {
        return WrapAsJava$.MODULE$.setAsJavaSet((Set)((TraversableOnce)((TraversableLike)this.environmentProviders().map((Function1)new Serializable(stack){
            private final ItemStack stack$4;

            public final Class<?> apply(EnvironmentProvider x$4) {
                return x$4.getEnvironment(this.stack$4);
            }
            {
                this.stack$4 = stack$4;
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){

            public final boolean apply(Class<?> x$5) {
                return x$5 != null;
            }
        })).toSet());
    }

    @Override
    public IItemHandler itemHandlerFor(ItemStack stack, EntityPlayer player2) {
        return (IItemHandler)this.inventoryProviders().find((Function1)new Serializable(stack, player2){
            private final ItemStack stack$5;
            private final EntityPlayer player$1;

            public final boolean apply(InventoryProvider provider) {
                return provider.worksWith(this.stack$5, this.player$1);
            }
            {
                this.stack$5 = stack$5;
                this.player$1 = player$1;
            }
        }).map((Function1)new Serializable(stack, player2){
            private final ItemStack stack$5;
            private final EntityPlayer player$1;

            public final IItemHandlerModifiable apply(InventoryProvider provider) {
                return InventoryUtils$.MODULE$.asItemHandler(provider.getInventory(this.stack$5, this.player$1));
            }
            {
                this.stack$5 = stack$5;
                this.player$1 = player$1;
            }
        }).getOrElse((Function0)new Serializable(stack){
            private final ItemStack stack$5;

            public final IItemHandler apply() {
                return this.stack$5.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) ? (IItemHandler)this.stack$5.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) : null;
            }
            {
                this.stack$5 = stack$5;
            }
        });
    }

    public List<DriverItem> itemDrivers() {
        return WrapAsJava$.MODULE$.seqAsJavaList(this.items().toSeq());
    }

    public void blacklistHost(ItemStack stack, Class<?> host) {
        Some some;
        Tuple2 tuple2;
        Option option = this.blacklist().find((Function1)new anonfun.3(stack));
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).x()) != null) {
            scala.collection.mutable.Set hosts2 = (scala.collection.mutable.Set)tuple2._2();
            hosts2.$plus$eq(host);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.blacklist().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)stack, (Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{host})))}));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Object[] convert(Object[] value) {
        return value != null ? (Object[])Predef$.MODULE$.refArrayOps(value).map((Function1)new Serializable(){

            public final Object apply(Object arg) {
                return Registry$.MODULE$.convertRecursively(arg, new IdentityHashMap<Object, Object>(), Registry$.MODULE$.convertRecursively$default$3());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.AnyRef())) : null;
    }

    public Object convertRecursively(Object value, IdentityHashMap<Object, Object> memo, boolean force) {
        Object object;
        Object object2;
        Object object3 = value;
        if (object3 instanceof ScalaNumber) {
            ScalaNumber scalaNumber = (ScalaNumber)object3;
            object2 = scalaNumber.underlying();
        } else {
            Object object4;
            object2 = object3 instanceof Object ? (object4 = object3) : (object3 == null ? null : object3);
        }
        Object valueRef = object2;
        if (!force && memo.containsKey(valueRef)) {
            object = memo.get(valueRef);
        } else {
            Object object5;
            Object object6 = valueRef;
            boolean bl = object6 == null ? true : (Unit$.MODULE$.equals(object6) ? true : None$.MODULE$.equals(object6));
            if (bl) {
                object5 = null;
            } else if (object6 instanceof Boolean) {
                Boolean bl2 = (Boolean)object6;
                object5 = bl2;
            } else if (object6 instanceof Byte) {
                Byte by = (Byte)object6;
                object5 = by;
            } else if (object6 instanceof Character) {
                Character c = (Character)object6;
                object5 = c;
            } else if (object6 instanceof Short) {
                Short s = (Short)object6;
                object5 = s;
            } else if (object6 instanceof Integer) {
                Integer n = (Integer)object6;
                object5 = n;
            } else if (object6 instanceof Long) {
                Long l = (Long)object6;
                object5 = l;
            } else if (object6 instanceof Float) {
                Float f = (Float)object6;
                object5 = f;
            } else if (object6 instanceof Double) {
                Double d = (Double)object6;
                object5 = d;
            } else if (object6 instanceof Number) {
                Number number = (Number)object6;
                object5 = BoxesRunTime.boxToDouble((double)number.doubleValue());
            } else if (object6 instanceof String) {
                String string = (String)object6;
                object5 = string;
            } else if (object6 instanceof boolean[]) {
                boolean[] blArray = (boolean[])object6;
                object5 = blArray;
            } else if (object6 instanceof byte[]) {
                byte[] byArray = (byte[])object6;
                object5 = byArray;
            } else if (object6 instanceof Character[]) {
                Character[] characterArray;
                object5 = characterArray = (Character[])object6;
            } else if (object6 instanceof short[]) {
                short[] sArray = (short[])object6;
                object5 = sArray;
            } else if (object6 instanceof Integer[]) {
                Integer[] integerArray = (Integer[])object6;
                object5 = integerArray;
            } else if (object6 instanceof long[]) {
                long[] lArray = (long[])object6;
                object5 = lArray;
            } else if (object6 instanceof float[]) {
                float[] fArray = (float[])object6;
                object5 = fArray;
            } else if (object6 instanceof double[]) {
                double[] dArray = (double[])object6;
                object5 = dArray;
            } else if (object6 instanceof String[]) {
                String[] stringArray = (String[])object6;
                object5 = stringArray;
            } else if (object6 instanceof Value) {
                Value value2 = (Value)object6;
                object5 = value2;
            } else if (ScalaRunTime$.MODULE$.isArray(object6, 1)) {
                Object object7 = object6;
                object5 = this.convertList(object7, (Iterator<Tuple2<Object, Object>>)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps(object7).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).iterator(), memo);
            } else if (object6 instanceof Product) {
                Object object8 = object6;
                object5 = this.convertList(object8, (Iterator<Tuple2<Object, Object>>)((Product)object8).productIterator().zipWithIndex(), memo);
            } else if (object6 instanceof Seq) {
                Seq seq = (Seq)object6;
                object5 = this.convertList(seq, (Iterator<Tuple2<Object, Object>>)((IterableLike)seq.zipWithIndex(Seq$.MODULE$.canBuildFrom())).iterator(), memo);
            } else if (object6 instanceof scala.collection.immutable.Map) {
                scala.collection.immutable.Map map = (scala.collection.immutable.Map)object6;
                object5 = this.convertMap(map, map, memo);
            } else if (object6 instanceof scala.collection.mutable.Map) {
                scala.collection.mutable.Map map = (scala.collection.mutable.Map)object6;
                object5 = this.convertMap(map, map.toMap(Predef$.MODULE$.$conforms()), memo);
            } else if (object6 instanceof Map) {
                Map map = (Map)object6;
                object5 = this.convertMap(map, WrapAsScala$.MODULE$.mapAsScalaMap(map).toMap(Predef$.MODULE$.$conforms()), memo);
            } else if (object6 instanceof Iterable) {
                Iterable iterable = (Iterable)object6;
                object5 = this.convertList(iterable, (Iterator<Tuple2<Object, Object>>)((IterableLike)iterable.zipWithIndex(scala.collection.Iterable$.MODULE$.canBuildFrom())).toIterator(), memo);
            } else if (object6 instanceof java.lang.Iterable) {
                java.lang.Iterable iterable = (java.lang.Iterable)object6;
                object5 = this.convertList(iterable, (Iterator<Tuple2<Object, Object>>)((IterableLike)WrapAsScala$.MODULE$.iterableAsScalaIterable(iterable).zipWithIndex(scala.collection.Iterable$.MODULE$.canBuildFrom())).iterator(), memo);
            } else {
                Object object9;
                HashMap converted = new HashMap();
                WrapAsScala$.MODULE$.mapAsScalaMap(memo).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(object6), converted));
                this.converters().foreach((Function1)new Serializable(converted, object6){
                    private final HashMap converted$1;
                    private final Object x1$1;

                    public final void apply(Converter converter) {
                        try {
                            converter.convert(this.x1$1, this.converted$1);
                        }
                        catch (Throwable throwable) {
                            OpenComputers$.MODULE$.log().warn("Type converter threw an exception.", throwable);
                        }
                    }
                    {
                        this.converted$1 = converted$1;
                        this.x1$1 = x1$1;
                    }
                });
                if (converted.isEmpty()) {
                    WrapAsScala$.MODULE$.mapAsScalaMap(memo).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(object6), (Object)object6.toString()));
                    object9 = object6.toString();
                } else {
                    WrapAsScala$.MODULE$.mapAsScalaMap(memo).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(converted), converted));
                    this.convertRecursively(converted, memo, true);
                    WrapAsScala$.MODULE$.mapAsScalaMap(memo).$minus$eq(converted);
                    if (converted.size() == 1 && converted.containsKey("oc:flatten")) {
                        Object value3 = converted.get("oc:flatten");
                        WrapAsScala$.MODULE$.mapAsScalaMap(memo).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(object6), value3));
                        object9 = value3;
                    } else {
                        object9 = converted;
                    }
                }
                object5 = object9;
            }
            object = object5;
        }
        return object;
    }

    public boolean convertRecursively$default$3() {
        return false;
    }

    public Object[] convertList(Object obj, Iterator<Tuple2<Object, Object>> list2, IdentityHashMap<Object, Object> memo) {
        ArrayBuffer converted = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        WrapAsScala$.MODULE$.mapAsScalaMap(memo).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(obj), (Object)converted));
        list2.withFilter((Function1)new Serializable(){

            public final boolean apply(Tuple2<Object, Object> check$ifrefutable$1) {
                Tuple2<Object, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(memo, converted){
            private final IdentityHashMap memo$1;
            private final ArrayBuffer converted$2;

            public final ArrayBuffer<Object> apply(Tuple2<Object, Object> x$7) {
                Tuple2<Object, Object> tuple2 = x$7;
                if (tuple2 != null) {
                    Object value = tuple2._1();
                    ArrayBuffer arrayBuffer = this.converted$2.$plus$eq(Registry$.MODULE$.convertRecursively(value, this.memo$1, Registry$.MODULE$.convertRecursively$default$3()));
                    return arrayBuffer;
                }
                throw new MatchError(tuple2);
            }
            {
                this.memo$1 = memo$1;
                this.converted$2 = converted$2;
            }
        });
        return (Object[])converted.toArray(ClassTag$.MODULE$.AnyRef());
    }

    public Object convertMap(Object obj, scala.collection.immutable.Map<?, ?> map, IdentityHashMap<Object, Object> memo) {
        Object object;
        block4: {
            scala.collection.mutable.Map map2;
            block3: {
                block2: {
                    scala.collection.mutable.Map map3;
                    object = WrapAsScala$.MODULE$.mapAsScalaMap(memo).getOrElseUpdate(obj, (Function0)new anonfun.4());
                    if (!(object instanceof scala.collection.mutable.Map)) break block2;
                    map2 = map3 = (scala.collection.mutable.Map)object;
                    break block3;
                }
                if (!(object instanceof Map)) break block4;
                Map map4 = (Map)object;
                map2 = WrapAsScala$.MODULE$.mapAsScalaMap(map4);
            }
            scala.collection.mutable.Map converted = map2;
            map.collect((PartialFunction)new Serializable(memo, converted){
                private final IdentityHashMap memo$2;
                private final scala.collection.mutable.Map converted$3;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Tuple2<Object, Object>, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x3;
                    if (A1 != null) {
                        Object key = A1._1();
                        Object value = A1._2();
                        if (key instanceof Object) {
                            Object object2 = key;
                            if (value instanceof Object) {
                                Object object3 = value;
                                object = this.converted$3.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Registry$.MODULE$.convertRecursively(object2, this.memo$2, Registry$.MODULE$.convertRecursively$default$3())), Registry$.MODULE$.convertRecursively(object3, this.memo$2, Registry$.MODULE$.convertRecursively$default$3())));
                                return (B1)object;
                            }
                        }
                    }
                    object = function1.apply(x3);
                    return (B1)object;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean isDefinedAt(Tuple2<Object, Object> x3) {
                    Tuple2<Object, Object> tuple2 = x3;
                    if (tuple2 == null) return false;
                    Object key = tuple2._1();
                    Object value = tuple2._2();
                    if (!(key instanceof Object)) return false;
                    if (!(value instanceof Object)) return false;
                    return true;
                }
                {
                    this.memo$2 = memo$2;
                    this.converted$3 = converted$3;
                }
            }, Iterable$.MODULE$.canBuildFrom());
            return memo.get(obj);
        }
        throw new MatchError(object);
    }

    private Registry$() {
        MODULE$ = this;
        this.sidedBlocks = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        this.items = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        this.converters = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        this.environmentProviders = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        this.inventoryProviders = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        this.blacklist = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        this.locked = false;
    }
}

