/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.collector;

import java.util.HashSet;
import java.util.Set;
import mcjty.deepresonance.blocks.ModBlocks;
import mcjty.deepresonance.blocks.crystals.ResonatingCrystalTileEntity;
import mcjty.deepresonance.blocks.generator.GeneratorConfiguration;
import mcjty.deepresonance.blocks.generator.GeneratorTileEntity;
import mcjty.deepresonance.config.ConfigMachines;
import mcjty.deepresonance.generatornetwork.DRGeneratorNetwork;
import mcjty.deepresonance.radiation.DRRadiationManager;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.varia.Broadcaster;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EnergyCollectorTileEntity
extends GenericTileEntity
implements ITickable {
    public static final float CRYSTAL_MIN_POWER = 1.0E-5f;
    public static int MAXTICKS = 20;
    private Set<BlockPos> crystals = new HashSet<BlockPos>();
    private boolean lasersActive = false;
    private int laserStartup = 0;
    private int radiationUpdateCount = MAXTICKS;
    private int networkID = -1;
    private static int ERROR_TOOMANYCRYSTALS = -1;
    private static int ERROR_TOOMUCHPOWER = -2;

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        boolean active = false;
        int startup = 0;
        DRGeneratorNetwork.Network network = null;
        TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177977_b());
        if (te instanceof GeneratorTileEntity) {
            GeneratorTileEntity generatorTileEntity = (GeneratorTileEntity)te;
            DRGeneratorNetwork generatorNetwork = DRGeneratorNetwork.getChannels(this.func_145831_w());
            if (this.networkID != generatorTileEntity.getNetworkId()) {
                if (this.networkID != -1) {
                    generatorNetwork.getOrCreateNetwork(this.networkID).decCollectorBlocks();
                }
                this.networkID = generatorTileEntity.getNetworkId();
                generatorTileEntity.getNetwork().incCollectorBlocks();
                generatorNetwork.save(this.func_145831_w());
            }
            if ((network = generatorTileEntity.getNetwork()) != null) {
                if (network.isActive()) {
                    int rfPerTick = this.calculateRF();
                    network.setLastRfPerTick(rfPerTick);
                    int newEnergy = network.getEnergy() + rfPerTick;
                    int maxEnergy = network.getGeneratorBlocks() * GeneratorConfiguration.rfPerGeneratorBlock;
                    if (newEnergy > maxEnergy) {
                        newEnergy = maxEnergy;
                    }
                    if (network.getEnergy() != newEnergy) {
                        network.setEnergy(newEnergy);
                        generatorNetwork.save(this.func_145831_w());
                    }
                    active = true;
                } else {
                    network.setLastRfPerTick(0);
                }
                startup = network.getStartupCounter();
            }
        } else if (this.networkID != -1) {
            this.networkID = -1;
            this.func_70296_d();
        }
        if (active != this.lasersActive || startup != this.laserStartup) {
            boolean doFind = this.lasersActive != active || this.laserStartup > GeneratorConfiguration.startupTime - 5;
            this.lasersActive = active;
            this.laserStartup = startup;
            this.markDirtyClient();
            if (doFind && te instanceof GeneratorTileEntity) {
                this.findCrystals(network);
            }
        }
    }

    public void disableCrystalGlow() {
        for (BlockPos coordinate : this.crystals) {
            TileEntity te = this.func_145831_w().func_175625_s(new BlockPos(this.func_174877_v().func_177958_n() + coordinate.func_177958_n(), this.func_174877_v().func_177956_o() + coordinate.func_177956_o(), this.func_174877_v().func_177952_p() + coordinate.func_177952_p()));
            if (!(te instanceof ResonatingCrystalTileEntity)) continue;
            ResonatingCrystalTileEntity resonatingCrystalTileEntity = (ResonatingCrystalTileEntity)te;
            resonatingCrystalTileEntity.setGlowing(false);
        }
    }

    private int calculateRF() {
        HashSet<BlockPos> tokeep = new HashSet<BlockPos>();
        boolean dirty = false;
        float radiationRadius = 0.0f;
        float radiationStrength = 0.0f;
        boolean doRadiation = false;
        --this.radiationUpdateCount;
        if (this.radiationUpdateCount <= 0) {
            this.radiationUpdateCount = MAXTICKS;
            doRadiation = true;
        }
        int rf = 0;
        for (BlockPos coordinate : this.crystals) {
            TileEntity te = this.func_145831_w().func_175625_s(new BlockPos(this.func_174877_v().func_177958_n() + coordinate.func_177958_n(), this.func_174877_v().func_177956_o() + coordinate.func_177956_o(), this.func_174877_v().func_177952_p() + coordinate.func_177952_p()));
            if (te instanceof ResonatingCrystalTileEntity) {
                ResonatingCrystalTileEntity resonatingCrystalTileEntity = (ResonatingCrystalTileEntity)te;
                if (resonatingCrystalTileEntity.getPower() > 1.0E-5f) {
                    resonatingCrystalTileEntity.setGlowing(this.lasersActive);
                    tokeep.add(coordinate);
                    float power = resonatingCrystalTileEntity.getPower();
                    if (power < resonatingCrystalTileEntity.getPowerPerTick()) {
                        resonatingCrystalTileEntity.setPower(0.0f);
                        continue;
                    }
                    resonatingCrystalTileEntity.setPower(power -= resonatingCrystalTileEntity.getPowerPerTick());
                    int rfPerTick = resonatingCrystalTileEntity.getRfPerTick();
                    rf += rfPerTick;
                    if (!doRadiation) continue;
                    float purity = resonatingCrystalTileEntity.getPurity();
                    float radius = DRRadiationManager.calculateRadiationRadius(resonatingCrystalTileEntity.getStrength(), resonatingCrystalTileEntity.getEfficiency(), purity);
                    if (radius > radiationRadius) {
                        radiationRadius = radius;
                    }
                    float strength = DRRadiationManager.calculateRadiationStrength(resonatingCrystalTileEntity.getStrength(), purity);
                    radiationStrength += strength;
                    continue;
                }
                resonatingCrystalTileEntity.setGlowing(false);
                dirty = true;
                continue;
            }
            dirty = true;
        }
        if (dirty) {
            this.crystals = tokeep;
            this.markDirtyClient();
        }
        if (doRadiation && radiationRadius > 0.1f) {
            GlobalCoordinate thisCoordinate;
            DRRadiationManager radiationManager = DRRadiationManager.getManager(this.func_145831_w());
            if (radiationManager.getRadiationSource(thisCoordinate = new GlobalCoordinate(this.func_174877_v(), this.func_145831_w().field_73011_w.getDimension())) == null) {
                Logging.log((String)("Created radiation source with radius " + radiationRadius + " and strength " + radiationStrength));
            }
            DRRadiationManager.RadiationSource radiationSource = radiationManager.getOrCreateRadiationSource(thisCoordinate);
            radiationSource.update(radiationRadius, radiationStrength, MAXTICKS);
            radiationManager.save(this.func_145831_w());
        }
        return rf;
    }

    public void addCrystal(int x, int y, int z) {
        if (this.networkID == -1) {
            return;
        }
        DRGeneratorNetwork channels = DRGeneratorNetwork.getChannels(this.func_145831_w());
        DRGeneratorNetwork.Network network = channels.getChannel(this.networkID);
        if (network == null) {
            return;
        }
        int maxSupportedRF = network.getGeneratorBlocks() * GeneratorConfiguration.maxRFInputPerBlock;
        for (BlockPos coordinate : this.crystals) {
            ResonatingCrystalTileEntity resonatingCrystalTileEntity;
            TileEntity te = this.func_145831_w().func_175625_s(new BlockPos(this.func_174877_v().func_177958_n() + coordinate.func_177958_n(), this.func_174877_v().func_177956_o() + coordinate.func_177956_o(), this.func_174877_v().func_177952_p() + coordinate.func_177952_p()));
            if (!(te instanceof ResonatingCrystalTileEntity) || !((resonatingCrystalTileEntity = (ResonatingCrystalTileEntity)te).getPower() > 1.0E-5f)) continue;
            maxSupportedRF -= resonatingCrystalTileEntity.getRfPerTick();
        }
        if (this.addCrystal(x, y, z, network, this.crystals, this.crystals, maxSupportedRF) >= 0) {
            this.markDirtyClient();
        }
    }

    private int addCrystal(int x, int y, int z, DRGeneratorNetwork.Network network, Set<BlockPos> newCrystals, Set<BlockPos> oldCrystals, int maxSupportedRF) {
        int maxSupportedCrystals = network.getGeneratorBlocks() * GeneratorConfiguration.maxCrystalsPerBlock;
        TileEntity te = this.func_145831_w().func_175625_s(new BlockPos(x, y, z));
        if (te instanceof ResonatingCrystalTileEntity) {
            ResonatingCrystalTileEntity resonatingCrystalTileEntity = (ResonatingCrystalTileEntity)te;
            if (resonatingCrystalTileEntity.getPower() > 1.0E-5f) {
                BlockPos crystalCoordinate = new BlockPos(x - this.func_174877_v().func_177958_n(), y - this.func_174877_v().func_177956_o(), z - this.func_174877_v().func_177952_p());
                if (resonatingCrystalTileEntity.isGlowing() && !oldCrystals.contains(crystalCoordinate)) {
                    return maxSupportedRF;
                }
                if (newCrystals.size() >= maxSupportedCrystals) {
                    resonatingCrystalTileEntity.setGlowing(false);
                    return ERROR_TOOMANYCRYSTALS;
                }
                if (resonatingCrystalTileEntity.getRfPerTick() > maxSupportedRF) {
                    resonatingCrystalTileEntity.setGlowing(false);
                    return ERROR_TOOMUCHPOWER;
                }
                maxSupportedRF -= resonatingCrystalTileEntity.getRfPerTick();
                newCrystals.add(crystalCoordinate);
                resonatingCrystalTileEntity.setGlowing(this.lasersActive);
            } else {
                resonatingCrystalTileEntity.setGlowing(false);
            }
        }
        return maxSupportedRF;
    }

    private void findCrystals(DRGeneratorNetwork.Network network) {
        HashSet<BlockPos> newCrystals = new HashSet<BlockPos>();
        int maxSupportedRF = network.getGeneratorBlocks() * GeneratorConfiguration.maxRFInputPerBlock;
        boolean tooManyCrystals = false;
        boolean tooMuchPower = false;
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        for (int y = yCoord - ConfigMachines.Collector.maxVerticalCrystalDistance; y <= yCoord + ConfigMachines.Collector.maxVerticalCrystalDistance; ++y) {
            if (y < 0 || y >= this.func_145831_w().func_72800_K()) continue;
            int maxhordist = ConfigMachines.Collector.maxHorizontalCrystalDistance;
            for (int x = xCoord - maxhordist; x <= xCoord + maxhordist; ++x) {
                for (int z = zCoord - maxhordist; z <= zCoord + maxhordist; ++z) {
                    if (this.func_145831_w().func_180495_p(new BlockPos(x, y, z)).func_177230_c() != ModBlocks.resonatingCrystalBlock) continue;
                    if ((maxSupportedRF = this.addCrystal(x, y, z, network, newCrystals, this.crystals, maxSupportedRF)) == ERROR_TOOMANYCRYSTALS) {
                        tooManyCrystals = true;
                        continue;
                    }
                    if (maxSupportedRF != ERROR_TOOMUCHPOWER) continue;
                    tooMuchPower = true;
                }
            }
        }
        if (!newCrystals.equals(this.crystals)) {
            this.crystals = newCrystals;
            this.markDirtyClient();
        }
        if (this.lasersActive && (tooManyCrystals || tooMuchPower)) {
            if (tooManyCrystals) {
                Broadcaster.broadcast((World)this.func_145831_w(), (int)xCoord, (int)yCoord, (int)zCoord, (String)"There are too many crystals for this size generator!", (float)100.0f);
            }
            if (tooMuchPower) {
                Broadcaster.broadcast((World)this.func_145831_w(), (int)xCoord, (int)yCoord, (int)zCoord, (String)"Some crystals are too powerful for this size generator!!", (float)100.0f);
            }
        }
    }

    public Set<BlockPos> getCrystals() {
        return this.crystals;
    }

    public boolean areLasersActive() {
        return this.lasersActive;
    }

    public int getLaserStartup() {
        return this.laserStartup;
    }

    public int getNetworkID() {
        return this.networkID;
    }

    public void setNetworkID(int networkID) {
        this.networkID = networkID;
        this.func_70296_d();
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        byte[] crystalX = tagCompound.func_74770_j("crystalsX");
        byte[] crystalY = tagCompound.func_74770_j("crystalsY");
        byte[] crystalZ = tagCompound.func_74770_j("crystalsZ");
        this.crystals.clear();
        for (int i = 0; i < crystalX.length; ++i) {
            this.crystals.add(new BlockPos((int)crystalX[i], (int)crystalY[i], (int)crystalZ[i]));
        }
        this.lasersActive = tagCompound.func_74767_n("lasersActive");
        this.laserStartup = tagCompound.func_74762_e("laserStartup");
        this.networkID = tagCompound.func_74764_b("networkId") ? tagCompound.func_74762_e("networkId") : -1;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        byte[] crystalX = new byte[this.crystals.size()];
        byte[] crystalY = new byte[this.crystals.size()];
        byte[] crystalZ = new byte[this.crystals.size()];
        int i = 0;
        for (BlockPos crystal : this.crystals) {
            crystalX[i] = (byte)crystal.func_177958_n();
            crystalY[i] = (byte)crystal.func_177956_o();
            crystalZ[i] = (byte)crystal.func_177952_p();
            ++i;
        }
        tagCompound.func_74773_a("crystalsX", crystalX);
        tagCompound.func_74773_a("crystalsY", crystalY);
        tagCompound.func_74773_a("crystalsZ", crystalZ);
        tagCompound.func_74757_a("lasersActive", this.lasersActive);
        tagCompound.func_74768_a("laserStartup", this.laserStartup);
        tagCompound.func_74768_a("networkId", this.networkID);
        return tagCompound;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        return new AxisAlignedBB((double)(xCoord - 7), (double)(yCoord - 1), (double)(zCoord - 7), (double)(xCoord + 8), (double)(yCoord + 2), (double)(zCoord + 8));
    }
}

