/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.laser;

import elec332.core.world.WorldHelper;
import java.util.HashMap;
import java.util.Map;
import mcjty.deepresonance.DeepResonance;
import mcjty.deepresonance.blocks.ModBlocks;
import mcjty.deepresonance.blocks.laser.InfusingBonus;
import mcjty.deepresonance.blocks.laser.LaserBlock;
import mcjty.deepresonance.blocks.laser.LaserContainer;
import mcjty.deepresonance.blocks.lens.LensSetup;
import mcjty.deepresonance.blocks.tank.TileTank;
import mcjty.deepresonance.config.ConfigMachines;
import mcjty.deepresonance.fluid.DRFluidRegistry;
import mcjty.deepresonance.fluid.LiquidCrystalFluidTagData;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.entity.GenericEnergyReceiverTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.network.PacketRequestIntegerFromServer;
import mcjty.lib.varia.OrientationTools;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LaserTileEntity
extends GenericEnergyReceiverTileEntity
implements DefaultSidedInventory,
ITickable {
    public static final String CMD_GETLIQUID = "getLiquid";
    public static final String CLIENTCMD_GETLIQUID = "getLiquid";
    public static final int COLOR_BLUE = 1;
    public static final int COLOR_RED = 2;
    public static final int COLOR_GREEN = 3;
    public static final int COLOR_YELLOW = 4;
    private int tickCounter = 10;
    private int progressCounter = 0;
    private int color = 0;
    private int crystalLiquid = 0;
    private static int crystalLiquidClient = 0;
    public static Map<String, InfusingBonus> infusingBonusMap = null;
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, LaserContainer.factory, 2);

    public LaserTileEntity() {
        super(ConfigMachines.Laser.rfMaximum, ConfigMachines.Laser.rfPerTick);
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    public void setPowerInput(int powered) {
        boolean changed = this.powerLevel != powered;
        super.setPowerInput(powered);
        if (changed) {
            IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
            this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.checkStateServer();
        }
    }

    protected void checkStateServer() {
        --this.tickCounter;
        if (this.tickCounter > 0) {
            return;
        }
        this.tickCounter = 10;
        this.checkCrystal();
        if (this.powerLevel == 0) {
            this.changeColor(0);
            return;
        }
        ItemStack stack = this.inventoryHelper.getStackInSlot(1);
        InfusingBonus bonus = LaserTileEntity.getInfusingBonus(stack);
        if (bonus == null) {
            this.changeColor(0);
            return;
        }
        if (this.getEnergyStored() < ConfigMachines.Laser.rfUsePerCatalyst) {
            this.changeColor(0);
            return;
        }
        if (this.crystalLiquid < ConfigMachines.Laser.crystalLiquidPerCatalyst) {
            this.changeColor(0);
            return;
        }
        BlockPos tankCoordinate = this.findLens();
        if (tankCoordinate == null) {
            this.changeColor(0);
            return;
        }
        this.changeColor(bonus.getColor());
        --this.progressCounter;
        this.func_70296_d();
        if (this.progressCounter > 0) {
            return;
        }
        this.progressCounter = ConfigMachines.Laser.ticks10PerCatalyst;
        this.infuseLiquid(tankCoordinate, bonus);
    }

    private boolean validRCLTank(TileTank tank) {
        Fluid fluid = DRFluidRegistry.getFluidFromStack(tank.getFluid());
        return fluid == null || fluid == DRFluidRegistry.liquidCrystal;
    }

    private void infuseLiquid(BlockPos tankCoordinate, InfusingBonus bonus) {
        FluidStack stack;
        TileTank tileTank;
        this.func_70298_a(1, 1);
        this.consumeEnergy(ConfigMachines.Laser.rfUsePerCatalyst);
        this.crystalLiquid -= ConfigMachines.Laser.crystalLiquidPerCatalyst;
        TileEntity te = WorldHelper.getTileAt((IBlockAccess)this.func_145831_w(), (BlockPos)tankCoordinate);
        if (te instanceof TileTank && this.validRCLTank(tileTank = (TileTank)te) && (stack = tileTank.getTank().drain(16000, false)) != null) {
            stack = tileTank.getTank().drain(16000, true);
            LiquidCrystalFluidTagData fluidData = LiquidCrystalFluidTagData.fromStack(stack);
            float factor = (float)ConfigMachines.Laser.rclPerCatalyst / (float)stack.amount;
            float purity = bonus.getPurityModifier().modify(fluidData.getPurity(), fluidData.getQuality(), factor);
            float strength = bonus.getStrengthModifier().modify(fluidData.getStrength(), fluidData.getQuality(), factor);
            float efficiency = bonus.getEfficiencyModifier().modify(fluidData.getEfficiency(), fluidData.getQuality(), factor);
            fluidData.setPurity(purity);
            fluidData.setStrength(strength);
            fluidData.setEfficiency(efficiency);
            FluidStack newStack = fluidData.makeLiquidCrystalStack();
            if ((double)Math.abs(purity) < 0.01) {
                newStack.amount -= 200;
                if (newStack.amount < 0) {
                    newStack.amount = 0;
                }
            }
            if (newStack.amount > 0) {
                tileTank.getTank().fill(newStack, true);
            }
        }
    }

    private void changeColor(int newcolor) {
        if (newcolor != this.color) {
            int mcolor = this.color = newcolor;
            if (this.color == 4) {
                mcolor = 2;
            } else if (this.color == 0) {
                mcolor = 0;
            }
            this.func_145831_w().func_180501_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()).func_177226_a((IProperty)LaserBlock.COLOR, (Comparable)Integer.valueOf(mcolor)), 3);
            this.func_70296_d();
        }
    }

    public int getColor() {
        return this.color;
    }

    private void checkCrystal() {
        ItemStack stack = this.inventoryHelper.getStackInSlot(0);
        if (!stack.func_190926_b()) {
            NBTTagCompound tagCompound = stack.func_77978_p();
            float strength = tagCompound == null ? 0.0f : tagCompound.func_74760_g("strength") / 100.0f;
            int addAmount = (int)((float)ConfigMachines.Laser.minCrystalLiquidPerCrystal + strength * (float)(ConfigMachines.Laser.maxCrystalLiquidPerCrystal - ConfigMachines.Laser.minCrystalLiquidPerCrystal));
            int newAmount = this.crystalLiquid + addAmount;
            if (newAmount > ConfigMachines.Laser.crystalLiquidMaximum) {
                return;
            }
            this.inventoryHelper.decrStackSize(0, 1);
            this.crystalLiquid = newAmount;
            this.func_70296_d();
        }
    }

    public static InfusingBonus getInfusingBonus(ItemStack item) {
        if (item.func_190926_b()) {
            return null;
        }
        String name = item.func_77973_b().getRegistryName().toString();
        return infusingBonusMap.get(name);
    }

    public static void createDefaultInfusionBonusMap() {
        infusingBonusMap = new HashMap<String, InfusingBonus>();
        infusingBonusMap.put(Items.field_151045_i.getRegistryName().toString(), new InfusingBonus(1, new InfusingBonus.Modifier(5.0f, 100.0f), InfusingBonus.Modifier.NONE, InfusingBonus.Modifier.NONE));
        infusingBonusMap.put(Items.field_151166_bC.getRegistryName().toString(), new InfusingBonus(3, new InfusingBonus.Modifier(8.0f, 100.0f), InfusingBonus.Modifier.NONE, InfusingBonus.Modifier.NONE));
        infusingBonusMap.put(Items.field_151079_bi.getRegistryName().toString(), new InfusingBonus(3, new InfusingBonus.Modifier(2.0f, 100.0f), InfusingBonus.Modifier.NONE, InfusingBonus.Modifier.NONE));
        infusingBonusMap.put(Items.field_151137_ax.getRegistryName().toString(), new InfusingBonus(2, new InfusingBonus.Modifier(-1.0f, 0.0f), new InfusingBonus.Modifier(5.0f, 60.0f), InfusingBonus.Modifier.NONE));
        infusingBonusMap.put(Items.field_151016_H.getRegistryName().toString(), new InfusingBonus(2, new InfusingBonus.Modifier(-5.0f, 0.0f), new InfusingBonus.Modifier(8.0f, 70.0f), new InfusingBonus.Modifier(4.0f, 60.0f)));
        infusingBonusMap.put(Items.field_151114_aO.getRegistryName().toString(), new InfusingBonus(4, new InfusingBonus.Modifier(-2.0f, 0.0f), new InfusingBonus.Modifier(6.0f, 50.0f), new InfusingBonus.Modifier(3.0f, 50.0f)));
        infusingBonusMap.put(Items.field_151065_br.getRegistryName().toString(), new InfusingBonus(4, new InfusingBonus.Modifier(-6.0f, 0.0f), new InfusingBonus.Modifier(5.0f, 70.0f), new InfusingBonus.Modifier(5.0f, 70.0f)));
        infusingBonusMap.put(Items.field_151128_bU.getRegistryName().toString(), new InfusingBonus(1, new InfusingBonus.Modifier(-1.0f, 0.0f), InfusingBonus.Modifier.NONE, new InfusingBonus.Modifier(7.0f, 80.0f)));
        infusingBonusMap.put(Items.field_151156_bN.getRegistryName().toString(), new InfusingBonus(2, new InfusingBonus.Modifier(-60.0f, 0.0f), new InfusingBonus.Modifier(90.0f, 100.0f), new InfusingBonus.Modifier(90.0f, 100.0f)));
        infusingBonusMap.put(Items.field_151073_bk.getRegistryName().toString(), new InfusingBonus(4, new InfusingBonus.Modifier(-20.0f, 0.0f), new InfusingBonus.Modifier(25.0f, 100.0f), new InfusingBonus.Modifier(15.0f, 100.0f)));
        infusingBonusMap.put(Items.field_179562_cC.getRegistryName().toString(), new InfusingBonus(4, InfusingBonus.Modifier.NONE, new InfusingBonus.Modifier(3.0f, 30.0f), new InfusingBonus.Modifier(3.0f, 30.0f)));
        infusingBonusMap.put(Items.field_179563_cD.getRegistryName().toString(), new InfusingBonus(4, InfusingBonus.Modifier.NONE, new InfusingBonus.Modifier(4.0f, 35.0f), new InfusingBonus.Modifier(4.0f, 35.0f)));
        infusingBonusMap.put(Items.field_151123_aH.getRegistryName().toString(), new InfusingBonus(3, InfusingBonus.Modifier.NONE, InfusingBonus.Modifier.NONE, new InfusingBonus.Modifier(-10.0f, 1.0f)));
        infusingBonusMap.put(Items.field_151044_h.getRegistryName().toString(), new InfusingBonus(2, new InfusingBonus.Modifier(-1.0f, 0.0f), new InfusingBonus.Modifier(-10.0f, 0.0f), InfusingBonus.Modifier.NONE));
        infusingBonusMap.put(Items.field_151075_bm.getRegistryName().toString(), new InfusingBonus(2, new InfusingBonus.Modifier(-3.0f, 0.0f), new InfusingBonus.Modifier(2.0f, 35.0f), new InfusingBonus.Modifier(-2.0f, 1.0f)));
        infusingBonusMap.put(Items.field_151043_k.getRegistryName().toString(), new InfusingBonus(2, InfusingBonus.Modifier.NONE, new InfusingBonus.Modifier(-1.0f, 0.0f), new InfusingBonus.Modifier(1.0f, 30.0f)));
        infusingBonusMap.put(Items.field_151042_j.getRegistryName().toString(), new InfusingBonus(2, InfusingBonus.Modifier.NONE, new InfusingBonus.Modifier(-2.0f, 0.0f), new InfusingBonus.Modifier(1.0f, 20.0f)));
        infusingBonusMap.put(Items.field_151126_ay.getRegistryName().toString(), new InfusingBonus(2, new InfusingBonus.Modifier(1.0f, 30.0f), InfusingBonus.Modifier.NONE, new InfusingBonus.Modifier(1.0f, 40.0f)));
        if (DeepResonance.instance.rftools) {
            infusingBonusMap.put(new ResourceLocation("rftools", "dimensional_shard").toString(), new InfusingBonus(1, new InfusingBonus.Modifier(1.0f, 100.0f), new InfusingBonus.Modifier(8.0f, 80.0f), new InfusingBonus.Modifier(8.0f, 80.0f)));
        }
    }

    private BlockPos findLens() {
        if (!this.func_145831_w().func_175667_e(this.func_174877_v())) {
            return null;
        }
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        EnumFacing direction = OrientationTools.getOrientationHoriz((IBlockState)state);
        BlockPos shouldBeAir = this.func_174877_v().func_177972_a(direction);
        if (!this.func_145831_w().func_175623_d(shouldBeAir)) {
            return null;
        }
        BlockPos shouldBeLens = shouldBeAir.func_177972_a(direction);
        Block lensBlock = WorldHelper.getBlockAt((IBlockAccess)this.func_145831_w(), (BlockPos)shouldBeLens);
        if (lensBlock != LensSetup.lensBlock) {
            return null;
        }
        EnumFacing lensDirection = OrientationTools.getOrientationHoriz((IBlockState)this.func_145831_w().func_180495_p(shouldBeLens));
        if (lensDirection != direction) {
            return null;
        }
        return shouldBeLens.func_177972_a(direction);
    }

    public void requestCrystalLiquidFromServer() {
        DeepResonance.networkHandler.sendToServer((IMessage)new PacketRequestIntegerFromServer("deepresonance", this.field_174879_c, "getLiquid", "getLiquid", new Argument[0]));
    }

    public int getCrystalLiquid() {
        return this.crystalLiquid;
    }

    @SideOnly(value=Side.CLIENT)
    public static int getCrystalLiquidClient() {
        return crystalLiquidClient;
    }

    public Integer executeWithResultInteger(String command, Map<String, Argument> args) {
        Integer rc = super.executeWithResultInteger(command, args);
        if (rc != null) {
            return rc;
        }
        if ("getLiquid".equals(command)) {
            return this.crystalLiquid;
        }
        return null;
    }

    public boolean execute(String command, Integer result) {
        boolean rc = super.execute(command, result);
        if (rc) {
            return true;
        }
        if ("getLiquid".equals(command)) {
            crystalLiquidClient = result;
            return true;
        }
        return false;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.color = tagCompound.func_74762_e("color");
        this.progressCounter = tagCompound.func_74762_e("progress");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.crystalLiquid = tagCompound.func_74762_e("liquid");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("color", this.color);
        tagCompound.func_74768_a("progress", this.progressCounter);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        tagCompound.func_74768_a("liquid", this.crystalLiquid);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - 3), (double)(this.func_174877_v().func_177956_o() - 1), (double)(this.func_174877_v().func_177952_p() - 3), (double)(this.func_174877_v().func_177958_n() + 4), (double)(this.func_174877_v().func_177956_o() + 2), (double)(this.func_174877_v().func_177952_p() + 4));
    }

    public boolean func_180461_b(int index, ItemStack item, EnumFacing side) {
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{1, 0};
    }

    public boolean func_180462_a(int index, ItemStack item, EnumFacing side) {
        switch (index) {
            case 0: {
                return item.func_77969_a(new ItemStack((Block)ModBlocks.resonatingCrystalBlock));
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0) {
            return stack.func_77973_b() == Item.func_150898_a((Block)ModBlocks.resonatingCrystalBlock);
        }
        return true;
    }
}

