/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.purifier;

import elec332.core.world.WorldHelper;
import java.util.Random;
import mcjty.deepresonance.blocks.purifier.PurifierContainer;
import mcjty.deepresonance.blocks.tank.ITankHook;
import mcjty.deepresonance.blocks.tank.TileTank;
import mcjty.deepresonance.config.ConfigMachines;
import mcjty.deepresonance.fluid.DRFluidRegistry;
import mcjty.deepresonance.fluid.LiquidCrystalFluidTagData;
import mcjty.deepresonance.items.ModItems;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.container.InventoryLocator;
import mcjty.lib.entity.GenericTileEntity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class PurifierTileEntity
extends GenericTileEntity
implements ITankHook,
DefaultSidedInventory,
ITickable {
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, PurifierContainer.factory, 1);
    private TileTank bottomTank;
    private TileTank topTank;
    private int progress = 0;
    private InventoryLocator inventoryLocator = new InventoryLocator();
    private static Random random = new Random();
    private static EnumFacing[] directions = new EnumFacing[]{null, EnumFacing.EAST, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.SOUTH};

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        if (this.progress > 0) {
            --this.progress;
            if (this.progress == 0) {
                this.progress = 1;
                if (this.getOutputTank() != null && this.canWork()) {
                    LiquidCrystalFluidTagData fluidData = LiquidCrystalFluidTagData.fromStack(this.getInputTank().getTank().drain(ConfigMachines.Purifier.rclPerPurify, true));
                    if (fluidData != null && random.nextInt(this.doPurify(fluidData)) == 0) {
                        this.consumeFilter();
                    }
                    this.progress = 0;
                }
            }
            this.func_70296_d();
        } else if (this.canWork()) {
            this.progress = ConfigMachines.Purifier.ticksPerPurify;
            this.func_70296_d();
        }
    }

    private void consumeFilter() {
        this.inventoryHelper.decrStackSize(0, 1);
        ItemStack spentMaterial = new ItemStack((Item)ModItems.spentFilterMaterialItem, 1);
        this.inventoryLocator.ejectStack(this.func_145831_w(), this.field_174879_c, spentMaterial, this.field_174879_c, directions);
    }

    private int doPurify(LiquidCrystalFluidTagData fluidData) {
        float maxPurityToAdd;
        float purity = fluidData.getPurity();
        float addedPurity = maxPurityToAdd = (float)ConfigMachines.Purifier.addedPurity / 100.0f;
        float maxPurity = ((float)ConfigMachines.Purifier.maxPurity + 0.1f) / 100.0f;
        if (purity + addedPurity > (maxPurity *= fluidData.getQuality()) && (addedPurity = maxPurity - purity) < 1.0E-4f) {
            FluidStack stack = fluidData.makeLiquidCrystalStack();
            this.getOutputTank().fill(stack, true);
            return 1000000;
        }
        fluidData.setPurity(purity += addedPurity);
        FluidStack stack = fluidData.makeLiquidCrystalStack();
        this.getOutputTank().fill(stack, true);
        return (int)((maxPurityToAdd - addedPurity) * 40.0f / maxPurityToAdd + 1.0f);
    }

    private boolean testFillOutputTank() {
        return this.getOutputTank().fill(new FluidStack(DRFluidRegistry.liquidCrystal, ConfigMachines.Purifier.rclPerPurify), false) == ConfigMachines.Purifier.rclPerPurify;
    }

    private TileTank getInputTank() {
        if (this.topTank == null || this.topTank.getTank() == null) {
            if (this.bottomTank != null && this.bottomTank.getTank() != null) {
                return this.bottomTank;
            }
            return null;
        }
        return this.topTank;
    }

    private IFluidHandler getOutputTank() {
        if (this.bottomTank == null || this.bottomTank.getTank() == null) {
            if (this.topTank != null && this.topTank.getTank() != null) {
                return this.topTank.getTank();
            }
            return null;
        }
        return this.bottomTank.getTank();
    }

    private boolean canWork() {
        if (!(this.bottomTank != null && this.bottomTank.getTank() != null || this.topTank != null && this.topTank.getTank() != null)) {
            return false;
        }
        if (this.getInputTank().getFluidAmount() < ConfigMachines.Purifier.rclPerPurify) {
            return false;
        }
        if (!this.validSlot()) {
            return false;
        }
        return this.getInputTank().getTank().equals(this.getOutputTank()) || this.testFillOutputTank();
    }

    private boolean validSlot() {
        return !this.inventoryHelper.getStackInSlot(0).func_190926_b() && this.inventoryHelper.getStackInSlot(0).func_77973_b() == ModItems.filterMaterialItem;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("progress", this.progress);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.progress = tagCompound.func_74762_e("progress");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
    }

    @Override
    public void hook(TileTank tank, EnumFacing direction) {
        if (direction == EnumFacing.DOWN) {
            if (this.validRCLTank(tank)) {
                this.bottomTank = tank;
            }
        } else if (this.topTank == null && this.validRCLTank(tank)) {
            this.topTank = tank;
        }
    }

    @Override
    public void unHook(TileTank tank, EnumFacing direction) {
        if (this.tilesEqual(this.bottomTank, tank)) {
            this.bottomTank = null;
            this.notifyAndMarkDirty();
        } else if (this.tilesEqual(this.topTank, tank)) {
            this.topTank = null;
            this.notifyAndMarkDirty();
        }
    }

    @Override
    public void onContentChanged(TileTank tank, EnumFacing direction) {
        if (this.tilesEqual(this.topTank, tank) && !this.validRCLTank(tank)) {
            this.topTank = null;
        }
        if (this.tilesEqual(this.bottomTank, tank) && !this.validRCLTank(tank)) {
            this.bottomTank = null;
        }
    }

    private boolean validRCLTank(TileTank tank) {
        Fluid fluid = DRFluidRegistry.getFluidFromStack(tank.getFluid());
        return fluid == null || fluid == DRFluidRegistry.liquidCrystal;
    }

    private boolean tilesEqual(TileTank first, TileTank second) {
        return first != null && second != null && first.func_174877_v().equals((Object)second.func_174877_v()) && WorldHelper.getDimID((World)first.func_145831_w()) == WorldHelper.getDimID((World)second.func_145831_w());
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }

    public boolean func_180462_a(int index, ItemStack item, EnumFacing side) {
        if (!this.func_94041_b(index, item)) {
            return false;
        }
        return PurifierContainer.factory.isInputSlot(index) || PurifierContainer.factory.isSpecificItemSlot(index);
    }

    public boolean func_180461_b(int index, ItemStack item, EnumFacing side) {
        return PurifierContainer.factory.isOutputSlot(index);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() == ModItems.filterMaterialItem;
    }

    protected void notifyAndMarkDirty() {
        if (WorldHelper.chunkLoaded((World)this.func_145831_w(), (BlockPos)this.field_174879_c)) {
            this.func_70296_d();
            this.func_145831_w().func_175685_c(this.field_174879_c, this.field_145854_h, false);
        }
    }
}

