/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.valve;

import elec332.core.world.WorldHelper;
import java.util.Map;
import mcjty.deepresonance.blocks.tank.ITankHook;
import mcjty.deepresonance.blocks.tank.TileTank;
import mcjty.deepresonance.config.ConfigMachines;
import mcjty.deepresonance.fluid.DRFluidRegistry;
import mcjty.deepresonance.fluid.LiquidCrystalFluidTagData;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.varia.RedstoneMode;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class ValveTileEntity
extends GenericTileEntity
implements ITankHook,
ITickable {
    public static String CMD_SETTINGS = "settings";
    public static final String CMD_RSMODE = "rsMode";
    private TileTank bottomTank;
    private TileTank topTank;
    private int progress = 0;
    private float minPurity = 1.0f;
    private float minStrength = 1.0f;
    private float minEfficiency = 1.0f;
    private int maxMb = 0;

    protected boolean needsRedstoneMode() {
        return true;
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        if (!this.isMachineEnabled()) {
            return;
        }
        --this.progress;
        this.func_70296_d();
        if (this.progress > 0) {
            return;
        }
        this.progress = ConfigMachines.Valve.ticksPerOperation;
        if (this.topTank == null || this.bottomTank == null || this.topTank.getTank() == null || this.bottomTank.getTank() == null) {
            return;
        }
        FluidStack fluidStack = this.topTank.getTank().drain(ConfigMachines.Valve.rclPerOperation, false);
        if (fluidStack != null && this.fillBottomTank(fluidStack.amount)) {
            LiquidCrystalFluidTagData data = LiquidCrystalFluidTagData.fromStack(fluidStack);
            if (data == null) {
                return;
            }
            if (data.getPurity() < this.minPurity) {
                return;
            }
            if (data.getStrength() < this.minStrength) {
                return;
            }
            if (data.getEfficiency() < this.minEfficiency) {
                return;
            }
            if (this.maxMb > 0) {
                int fluidAmount = this.bottomTank.getFluidAmount();
                if (fluidAmount < this.maxMb) {
                    int toDrain = Math.min(this.maxMb - fluidAmount, ConfigMachines.Valve.rclPerOperation);
                    fluidStack = this.topTank.getTank().drain(toDrain, true);
                    this.bottomTank.getTank().fill(fluidStack, true);
                }
            } else {
                fluidStack = this.topTank.getTank().drain(ConfigMachines.Valve.rclPerOperation, true);
                this.bottomTank.getTank().fill(fluidStack, true);
            }
        }
    }

    public int getMaxMb() {
        return this.maxMb;
    }

    public void setMaxMb(int maxMb) {
        this.maxMb = maxMb;
        this.func_70296_d();
    }

    public float getMinEfficiency() {
        return this.minEfficiency;
    }

    public void setMinEfficiency(float minEfficiency) {
        this.minEfficiency = minEfficiency;
        this.func_70296_d();
    }

    public float getMinPurity() {
        return this.minPurity;
    }

    public void setMinPurity(float minPurity) {
        this.minPurity = minPurity;
        this.func_70296_d();
    }

    public float getMinStrength() {
        return this.minStrength;
    }

    public void setMinStrength(float minStrength) {
        this.minStrength = minStrength;
        this.func_70296_d();
    }

    private boolean fillBottomTank(int amount) {
        return this.bottomTank.getTank().fill(new FluidStack(DRFluidRegistry.liquidCrystal, amount), false) == amount;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("progress", this.progress);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74776_a("minPurity", this.minPurity);
        tagCompound.func_74776_a("minStrength", this.minStrength);
        tagCompound.func_74776_a("minEfficiency", this.minEfficiency);
        tagCompound.func_74768_a("maxMb", this.maxMb);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.progress = tagCompound.func_74762_e("progress");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.minPurity = tagCompound.func_74760_g("minPurity");
        this.minStrength = tagCompound.func_74760_g("minStrength");
        this.minEfficiency = tagCompound.func_74760_g("minEfficiency");
        this.maxMb = tagCompound.func_74762_e("maxMb");
    }

    @Override
    public void hook(TileTank tank, EnumFacing direction) {
        if (direction == EnumFacing.DOWN) {
            if (this.validRCLTank(tank)) {
                this.bottomTank = tank;
            }
        } else if (this.topTank == null && this.validRCLTank(tank)) {
            this.topTank = tank;
        }
    }

    @Override
    public void unHook(TileTank tank, EnumFacing direction) {
        if (this.tilesEqual(this.bottomTank, tank)) {
            this.bottomTank = null;
            this.notifyAndMarkDirty();
        } else if (this.tilesEqual(this.topTank, tank)) {
            this.topTank = null;
            this.notifyAndMarkDirty();
        }
    }

    @Override
    public void onContentChanged(TileTank tank, EnumFacing direction) {
        if (this.tilesEqual(this.topTank, tank) && !this.validRCLTank(tank)) {
            this.topTank = null;
        }
        if (this.tilesEqual(this.bottomTank, tank) && !this.validRCLTank(tank)) {
            this.bottomTank = null;
        }
    }

    private boolean validRCLTank(TileTank tank) {
        Fluid fluid = DRFluidRegistry.getFluidFromStack(tank.getFluid());
        return fluid == null || fluid == DRFluidRegistry.liquidCrystal;
    }

    private boolean tilesEqual(TileTank first, TileTank second) {
        return first != null && second != null && first.func_174877_v().equals((Object)second.func_174877_v()) && WorldHelper.getDimID((World)first.func_145831_w()) == WorldHelper.getDimID((World)second.func_145831_w());
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_RSMODE.equals(command)) {
            String m = args.get("rs").getString();
            this.setRSMode(RedstoneMode.getMode((String)m));
            return true;
        }
        if (CMD_SETTINGS.equals(command)) {
            double purity = args.get("purity").getDouble();
            double strength = args.get("strength").getDouble();
            double efficiency = args.get("efficiency").getDouble();
            int maxMb = args.get("maxMb").getInteger();
            this.setMinPurity((float)purity);
            this.setMinStrength((float)strength);
            this.setMinEfficiency((float)efficiency);
            this.setMaxMb(maxMb);
            return true;
        }
        return false;
    }

    protected void notifyAndMarkDirty() {
        if (WorldHelper.chunkLoaded((World)this.func_145831_w(), (BlockPos)this.field_174879_c)) {
            this.func_70296_d();
            this.func_145831_w().func_175685_c(this.field_174879_c, this.field_145854_h, false);
        }
    }
}

