/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.items;

import elec332.core.world.WorldHelper;
import java.util.List;
import java.util.Map;
import mcjty.deepresonance.DeepResonance;
import mcjty.deepresonance.items.GenericDRItem;
import mcjty.deepresonance.network.PacketGetRadiationLevel;
import mcjty.deepresonance.radiation.DRRadiationManager;
import mcjty.deepresonance.radiation.RadiationConfiguration;
import mcjty.deepresonance.varia.QuadTree;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RadiationMonitorItem
extends GenericDRItem {
    private static long lastTime = 0L;
    public static float radiationStrength = 0.0f;

    public RadiationMonitorItem() {
        super("radiation_monitor");
        this.func_77625_d(1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        for (int i = 0; i <= 9; ++i) {
            String domain = this.getRegistryName().func_110624_b();
            String path = this.getRegistryName().func_110623_a();
            ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(new ResourceLocation(domain, path + i), "inventory")});
        }
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                RadiationMonitorItem.fetchRadiation((EntityPlayer)player);
                int level = (int)(10.0f * radiationStrength / RadiationConfiguration.maxRadiationMeter);
                if (level < 0) {
                    level = 0;
                } else if (level > 9) {
                    level = 9;
                }
                String domain = RadiationMonitorItem.this.getRegistryName().func_110624_b();
                String path = RadiationMonitorItem.this.getRegistryName().func_110623_a();
                return new ModelResourceLocation(new ResourceLocation(domain, path + level), "inventory");
            }
        });
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            GlobalCoordinate c = new GlobalCoordinate(player.func_180425_c(), WorldHelper.getDimID((World)world));
            float maxStrength = RadiationMonitorItem.calculateRadiationStrength(world, c);
            if (maxStrength <= 0.0f) {
                Logging.message((EntityPlayer)player, (String)(TextFormatting.GREEN + "No radiation detected"));
            } else {
                Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "Strength of Radiation " + new Float(maxStrength).intValue() + "!"));
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public static float calculateRadiationStrength(World world, GlobalCoordinate player) {
        int id = player.getDimension();
        DRRadiationManager radiationManager = DRRadiationManager.getManager(world);
        float maxStrength = -1.0f;
        for (Map.Entry<GlobalCoordinate, DRRadiationManager.RadiationSource> source : radiationManager.getRadiationSources().entrySet()) {
            int cz;
            int cy;
            GlobalCoordinate coordinate = source.getKey();
            if (coordinate.getDimension() != id) continue;
            DRRadiationManager.RadiationSource radiationSource = source.getValue();
            float radius = radiationSource.getRadius();
            float radiusSq = radius * radius;
            double distanceSq = player.getCoordinate().func_177951_i((Vec3i)coordinate.getCoordinate());
            if (!(distanceSq < (double)radiusSq)) continue;
            double distance = Math.sqrt(distanceSq);
            float strength = (float)((double)radiationSource.getStrength() * ((double)radius - distance) / (double)radius);
            int cx = coordinate.getCoordinate().func_177958_n();
            QuadTree radiationTree = radiationSource.getRadiationTree(world, cx, cy = coordinate.getCoordinate().func_177956_o(), cz = coordinate.getCoordinate().func_177952_p());
            if (!((strength *= (float)radiationTree.factor2(cx, cy, cz, player.getCoordinate().func_177958_n(), player.getCoordinate().func_177956_o() + 1, player.getCoordinate().func_177952_p())) > maxStrength)) continue;
            maxStrength = strength;
        }
        return maxStrength;
    }

    public void func_77624_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag advancedToolTip) {
        super.func_77624_a(itemStack, player, list, advancedToolTip);
        RadiationMonitorItem.fetchRadiation(DeepResonance.proxy.getClientPlayer());
        if (radiationStrength <= 0.0f) {
            list.add(TextFormatting.GREEN + "No radiation detected");
        } else {
            list.add(TextFormatting.RED + "Radiation: " + new Float(radiationStrength).intValue() + "!");
        }
    }

    public static void fetchRadiation(EntityPlayer player) {
        if (player == null) {
            return;
        }
        if (System.currentTimeMillis() - lastTime > 250L) {
            int id = WorldHelper.getDimID((World)player.func_130014_f_());
            lastTime = System.currentTimeMillis();
            GlobalCoordinate c = new GlobalCoordinate(player.func_180425_c(), id);
            DeepResonance.networkHandler.sendToServer((IMessage)new PacketGetRadiationLevel(c));
        }
    }
}

