/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.items.armor;

import java.util.List;
import mcjty.deepresonance.DeepResonance;
import mcjty.deepresonance.api.IRadiationArmor;
import mcjty.deepresonance.items.armor.RadiationSuitModel;
import mcjty.deepresonance.radiation.RadiationConfiguration;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRadiationSuit
extends ItemArmor
implements IRadiationArmor {
    private final String textureSuffix;

    public ItemRadiationSuit(ItemArmor.ArmorMaterial material, int renderIndex, EntityEquipmentSlot armorType, String name) {
        super(material, renderIndex, armorType);
        this.func_77655_b("deepresonance." + name);
        this.setRegistryName(name);
        this.textureSuffix = name;
        this.func_77637_a(DeepResonance.tabDeepResonance);
    }

    public void func_77624_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag advancedToolTip) {
        super.func_77624_a(itemStack, player, list, advancedToolTip);
        list.add("Every piece of the radiation suit");
        list.add("adds a bit of protection for radiation");
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "deepresonance:textures/items/texture" + this.textureSuffix + ".png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        return RadiationSuitModel.getModel(entityLiving, itemStack);
    }

    public boolean func_82789_a(ItemStack p_82789_1_, ItemStack p_82789_2_) {
        return false;
    }

    public static int countSuitPieces(EntityLivingBase entity) {
        int cnt = 0;
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            ItemStack stack;
            if (slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR || (stack = entity.func_184582_a(slot)).func_190926_b() || !(stack.func_77973_b() instanceof IRadiationArmor)) continue;
            ++cnt;
        }
        return cnt;
    }

    public static float getRadiationProtection(EntityLivingBase entity) {
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            ItemStack stack;
            if (slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR || (stack = entity.func_184582_a(slot)).func_190926_b()) continue;
            if (stack.func_77973_b() instanceof IRadiationArmor) {
                return ((IRadiationArmor)stack.func_77973_b()).protection()[ItemRadiationSuit.countSuitPieces(entity)];
            }
            if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("AntiRadiationArmor")) continue;
            return RadiationConfiguration.suitProtection[ItemRadiationSuit.countSuitPieces(entity)];
        }
        return 0.0f;
    }

    @Override
    public float[] protection() {
        return RadiationConfiguration.suitProtection;
    }
}

