/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.radiation;

import com.google.common.collect.Sets;
import elec332.core.world.WorldHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mcjty.deepresonance.blocks.ModBlocks;
import mcjty.deepresonance.items.armor.ItemRadiationSuit;
import mcjty.deepresonance.radiation.DRRadiationManager;
import mcjty.deepresonance.radiation.RadiationConfiguration;
import mcjty.deepresonance.varia.QuadTree;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class RadiationTickEvent {
    public static final int MAXTICKS = 10;
    private int counter = 10;
    private static Random random = new Random();
    private static final int EFFECTS_MAX = 18;
    private int counterEffects = 18;
    public static Potion harm;
    public static Potion hunger;
    public static Potion moveSlowdown;
    public static Potion weakness;
    public static Potion poison;
    public static Potion wither;

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent evt) {
        if (evt.phase == TickEvent.Phase.START) {
            return;
        }
        if (evt.world.field_73011_w.getDimension() != 0) {
            return;
        }
        --this.counter;
        if (this.counter <= 0) {
            this.counter = 10;
            --this.counterEffects;
            boolean doEffects = false;
            if (this.counterEffects <= 0) {
                this.counterEffects = 18;
                doEffects = true;
            }
            this.serverTick(evt.world, doEffects);
        }
    }

    private void serverTick(World entityWorld, boolean doEffects) {
        DRRadiationManager radiationManager = DRRadiationManager.getManager(entityWorld);
        HashSet toRemove = Sets.newHashSet();
        boolean dirty = false;
        for (Map.Entry<GlobalCoordinate, DRRadiationManager.RadiationSource> source : radiationManager.getRadiationSources().entrySet()) {
            GlobalCoordinate coordinate = source.getKey();
            WorldServer world = DimensionManager.getWorld((int)coordinate.getDimension());
            if (world == null || !WorldHelper.chunkLoaded((World)world, (BlockPos)coordinate.getCoordinate())) continue;
            DRRadiationManager.RadiationSource radiationSource = source.getValue();
            float strength = radiationSource.getStrength();
            strength -= RadiationConfiguration.strengthDecreasePerTick * 10.0f;
            dirty = true;
            if (strength <= 0.0f) {
                toRemove.add(coordinate);
                continue;
            }
            radiationSource.setStrength(strength);
            if (doEffects) {
                this.handleRadiationEffects((World)world, coordinate, radiationSource);
            }
            if (!(strength > RadiationConfiguration.radiationDestructionEventLevel) || !(random.nextFloat() < RadiationConfiguration.destructionEventChance)) continue;
            this.handleDestructionEvent((World)world, coordinate, radiationSource);
        }
        if (dirty) {
            for (GlobalCoordinate coordinate : toRemove) {
                radiationManager.deleteRadiationSource(coordinate);
                Logging.logDebug((String)("Removed radiation source at: " + coordinate.getCoordinate().toString() + " (" + coordinate.getDimension() + ")"));
            }
            radiationManager.save(entityWorld);
        }
    }

    private void handleDestructionEvent(World world, GlobalCoordinate coordinate, DRRadiationManager.RadiationSource radiationSource) {
        float setOnFireChance;
        float removeLeafChance;
        float poisonBlockChance;
        int damage;
        int cx = coordinate.getCoordinate().func_177958_n();
        int cy = coordinate.getCoordinate().func_177956_o();
        int cz = coordinate.getCoordinate().func_177952_p();
        double centerx = cx;
        double centery = cy;
        double centerz = cz;
        double radius = radiationSource.getRadius();
        double theta = random.nextDouble() * Math.PI * 2.0;
        double phi = random.nextDouble() * Math.PI - 1.5707963267948966;
        double dist = random.nextDouble() * radius;
        double cosphi = Math.cos(phi);
        double destx = centerx + dist * Math.cos(theta) * cosphi;
        double destz = centerz + dist * Math.sin(theta) * cosphi;
        double desty = random.nextFloat() > 0.5f ? (double)world.func_175672_r(new BlockPos((int)destx, world.func_72940_L(), (int)destz)).func_177956_o() : centery + dist * Math.sin(phi);
        Logging.logDebug((String)("Destruction event at: " + destx + "," + desty + "," + destz));
        float baseStrength = radiationSource.getStrength();
        double distanceSq = (centerx - destx) * (centerx - destx) + (centery - desty) * (centery - desty) + (centerz - destz) * (centerz - destz);
        double distance = Math.sqrt(distanceSq);
        float strength = (float)((double)baseStrength * (radius - distance) / radius);
        QuadTree radiationTree = radiationSource.getRadiationTree(world, cx, cy, cz);
        strength *= (float)radiationTree.factor(cx, cy, cz, (int)destx, (int)desty, (int)destz);
        int eventradius = 8;
        if (strength > RadiationConfiguration.radiationDestructionEventLevel / 2.0f) {
            damage = 30;
            poisonBlockChance = 0.9f;
            removeLeafChance = 9.0f;
            setOnFireChance = 0.03f;
        } else if (strength > RadiationConfiguration.radiationDestructionEventLevel / 3.0f) {
            damage = 5;
            poisonBlockChance = 0.6f;
            removeLeafChance = 4.0f;
            setOnFireChance = 0.001f;
        } else if (strength > RadiationConfiguration.radiationDestructionEventLevel / 4.0f) {
            damage = 1;
            poisonBlockChance = 0.3f;
            removeLeafChance = 1.2f;
            setOnFireChance = 0.0f;
        } else {
            return;
        }
        List list = world.func_175647_a(EntityLivingBase.class, new AxisAlignedBB(destx - (double)eventradius, desty - (double)eventradius, destz - (double)eventradius, destx + (double)eventradius, desty + (double)eventradius, destz + (double)eventradius), null);
        for (EntityLivingBase entityLivingBase : list) {
            RadiationTickEvent.getPotions();
            entityLivingBase.func_70690_d(new PotionEffect(harm, 10, damage));
        }
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos();
        int x = (int)(destx - (double)eventradius);
        while ((double)x <= destx + (double)eventradius) {
            int y = (int)(desty - (double)eventradius);
            while ((double)y <= desty + (double)eventradius) {
                int z = (int)(destz - (double)eventradius);
                while ((double)z <= destz + (double)eventradius) {
                    double dSq = ((double)x - destx) * ((double)x - destx) + ((double)y - desty) * ((double)y - desty) + ((double)z - destz) * ((double)z - destz);
                    double d = Math.sqrt(dSq);
                    double str = ((double)eventradius - d) / (double)eventradius;
                    Block block = WorldHelper.getBlockAt((IBlockAccess)world, (BlockPos)(currentPos = currentPos.func_181079_c(x, y, z)));
                    if (block == Blocks.field_150346_d || block == Blocks.field_150458_ak || block == Blocks.field_150349_c) {
                        if ((double)random.nextFloat() < (double)poisonBlockChance * str) {
                            WorldHelper.setBlockState((World)world, (BlockPos)currentPos, (IBlockState)ModBlocks.poisonedDirtBlock.func_176223_P(), (int)2);
                        }
                    } else if ((block.isLeaves(world.func_180495_p((BlockPos)currentPos), (IBlockAccess)world, (BlockPos)currentPos) || block instanceof IPlantable) && (double)random.nextFloat() < (double)removeLeafChance * str) {
                        world.func_175698_g((BlockPos)currentPos);
                    }
                    if ((double)random.nextFloat() < (double)setOnFireChance * str) {
                        // empty if block
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    private static void getPotions() {
        IForgeRegistry potionRegistry = ForgeRegistries.POTIONS;
        if (harm == null) {
            harm = (Potion)potionRegistry.getValue(new ResourceLocation("instant_damage"));
            hunger = (Potion)potionRegistry.getValue(new ResourceLocation("hunger"));
            moveSlowdown = (Potion)potionRegistry.getValue(new ResourceLocation("slowness"));
            weakness = (Potion)potionRegistry.getValue(new ResourceLocation("weakness"));
            poison = (Potion)potionRegistry.getValue(new ResourceLocation("poison"));
            wither = (Potion)potionRegistry.getValue(new ResourceLocation("wither"));
        }
    }

    private void handleRadiationEffects(World world, GlobalCoordinate coordinate, DRRadiationManager.RadiationSource radiationSource) {
        int cx = coordinate.getCoordinate().func_177958_n();
        int cy = coordinate.getCoordinate().func_177956_o();
        int cz = coordinate.getCoordinate().func_177952_p();
        double centerx = cx;
        double centery = cy;
        double centerz = cz;
        double radius = radiationSource.getRadius();
        double radiusSq = radius * radius;
        float baseStrength = radiationSource.getStrength();
        List list = world.func_175647_a(EntityLivingBase.class, new AxisAlignedBB(centerx - radius, centery - radius, centerz - radius, centerx + radius, centery + radius, centerz + radius), null);
        for (EntityLivingBase entityLivingBase : list) {
            float protection = ItemRadiationSuit.getRadiationProtection(entityLivingBase);
            double distanceSq = entityLivingBase.func_70092_e(centerx, centery, centerz);
            if (!(distanceSq < radiusSq)) continue;
            double distance = Math.sqrt(distanceSq);
            QuadTree radiationTree = radiationSource.getRadiationTree(world, cx, cy, cz);
            float strength = (float)((double)baseStrength * (radius - distance) / radius);
            strength *= 1.0f - protection;
            RadiationTickEvent.getPotions();
            if ((strength *= (float)radiationTree.factor2(cx, cy, cz, (int)entityLivingBase.field_70165_t, (int)entityLivingBase.field_70163_u + 1, (int)entityLivingBase.field_70161_v)) < RadiationConfiguration.radiationEffectLevelNone) continue;
            if (strength < RadiationConfiguration.radiationEffectLevel0) {
                entityLivingBase.func_70690_d(new PotionEffect(hunger, 180, 0, true, true));
                continue;
            }
            if (strength < RadiationConfiguration.radiationEffectLevel1) {
                entityLivingBase.func_70690_d(new PotionEffect(hunger, 180, 1, true, true));
                continue;
            }
            if (strength < RadiationConfiguration.radiationEffectLevel2) {
                entityLivingBase.func_70690_d(new PotionEffect(hunger, 180, 2, true, true));
                entityLivingBase.func_70690_d(new PotionEffect(moveSlowdown, 180, 1, true, true));
                continue;
            }
            if (strength < RadiationConfiguration.radiationEffectLevel3) {
                entityLivingBase.func_70690_d(new PotionEffect(hunger, 180, 2, true, true));
                entityLivingBase.func_70690_d(new PotionEffect(moveSlowdown, 180, 2, true, true));
                entityLivingBase.func_70690_d(new PotionEffect(weakness, 180, 1, true, true));
                continue;
            }
            if (strength < RadiationConfiguration.radiationEffectLevel4) {
                entityLivingBase.func_70690_d(new PotionEffect(hunger, 180, 2, true, true));
                entityLivingBase.func_70690_d(new PotionEffect(moveSlowdown, 180, 2, true, true));
                entityLivingBase.func_70690_d(new PotionEffect(weakness, 180, 2, true, true));
                entityLivingBase.func_70690_d(new PotionEffect(poison, 180, 1, true, true));
                continue;
            }
            if (strength < RadiationConfiguration.radiationEffectLevel5) {
                entityLivingBase.func_70690_d(new PotionEffect(hunger, 180, 2, true, true));
                entityLivingBase.func_70690_d(new PotionEffect(moveSlowdown, 180, 2, true, true));
                entityLivingBase.func_70690_d(new PotionEffect(weakness, 180, 3, true, true));
                entityLivingBase.func_70690_d(new PotionEffect(poison, 180, 2, true, true));
                continue;
            }
            entityLivingBase.func_70690_d(new PotionEffect(hunger, 180, 2, true, true));
            entityLivingBase.func_70690_d(new PotionEffect(moveSlowdown, 180, 2, true, true));
            entityLivingBase.func_70690_d(new PotionEffect(weakness, 180, 3, true, true));
            entityLivingBase.func_70690_d(new PotionEffect(poison, 180, 3, true, true));
            entityLivingBase.func_70690_d(new PotionEffect(wither, 180, 2, true, true));
        }
    }
}

