/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting;

import com.blakebr0.mysticalagriculture.items.armor.ItemSupremiumArmor;
import com.blakebr0.mysticalagriculture.util.NBTHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.OreDictionary;

public class TinkeringTableRecipe
implements IRecipe {
    private ItemStack output = null;
    private Object[] input = null;
    public int width = 0;
    public int height = 0;
    private boolean mirrored = false;
    private Item resultItem;
    private int resultMeta;

    public TinkeringTableRecipe(Block result, Object ... recipe) {
        this(new ItemStack(result), recipe);
    }

    public TinkeringTableRecipe(Item result, Object ... recipe) {
        this(new ItemStack(result), recipe);
    }

    public TinkeringTableRecipe(ItemStack result, Object ... recipe) {
        this.output = result.func_77946_l();
        this.resultItem = result.func_77973_b();
        this.resultMeta = result.func_77952_i();
        result.func_77986_q();
        String shape = "";
        int idx = 0;
        if (recipe[idx] instanceof Boolean) {
            this.mirrored = (Boolean)recipe[idx];
            if (recipe[idx + 1] instanceof Object[]) {
                recipe = (Object[])recipe[idx + 1];
            } else {
                idx = 1;
            }
        }
        if (recipe[idx] instanceof String[]) {
            String[] parts = (String[])recipe[idx++];
            for (String s : parts) {
                this.width = s.length();
                shape = shape + (String)s;
            }
            this.height = parts.length;
        } else {
            while (recipe[idx] instanceof String) {
                String s = (String)recipe[idx++];
                shape = shape + s;
                this.width = s.length();
                ++this.height;
            }
        }
        if (this.width * this.height != shape.length()) {
            String ret = "Invalid Tinkering Table recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
        HashMap<Character, Object> itemMap = new HashMap<Character, Object>();
        while (idx < recipe.length) {
            Character chr = (Character)recipe[idx];
            Object in = recipe[idx + 1];
            if (in instanceof ItemStack) {
                itemMap.put(chr, ((ItemStack)in).func_77946_l());
            } else if (in instanceof Item) {
                itemMap.put(chr, new ItemStack((Item)in));
            } else if (in instanceof Block) {
                itemMap.put(chr, new ItemStack((Block)in, 1, Short.MAX_VALUE));
            } else if (in instanceof String) {
                itemMap.put(chr, OreDictionary.getOres((String)((String)in)));
            } else {
                String ret = "Invalid Tinkering Table recipe: ";
                for (Object tmp : recipe) {
                    ret = ret + tmp + ", ";
                }
                ret = ret + this.output;
                throw new RuntimeException(ret);
            }
            idx += 2;
        }
        this.input = new Object[this.width * this.height];
        int x = 0;
        for (char chr : shape.toCharArray()) {
            this.input[x++] = itemMap.get(Character.valueOf(chr));
        }
    }

    TinkeringTableRecipe(ShapedRecipes recipe, Map<ItemStack, String> replacements) {
        this.output = recipe.func_77571_b();
        this.width = recipe.field_77576_b;
        this.height = recipe.field_77577_c;
        this.input = new Object[recipe.field_77574_d.length];
        block0: for (int i = 0; i < this.input.length; ++i) {
            ItemStack ingred = recipe.field_77574_d[i];
            if (ingred == null) continue;
            this.input[i] = recipe.field_77574_d[i];
            for (Map.Entry<ItemStack, String> replace : replacements.entrySet()) {
                if (!OreDictionary.itemMatches((ItemStack)replace.getKey(), (ItemStack)ingred, (boolean)true)) continue;
                this.input[i] = OreDictionary.getOres((String)replace.getValue());
                continue block0;
            }
        }
    }

    public TinkeringTableRecipe(ItemStack result, Object[] ingredients, int wid, int hei) {
        this.width = wid;
        this.height = hei;
        this.output = result;
        this.input = ingredients;
        this.resultItem = result.func_77973_b();
        this.resultMeta = result.func_77952_i();
        result.func_77986_q();
    }

    public ItemStack func_77572_b(InventoryCrafting inventoryCrafting) {
        NBTTagCompound tags = null;
        ItemStack result = new ItemStack(this.resultItem, 1, this.resultMeta);
        for (int i = 0; i < inventoryCrafting.func_70302_i_(); ++i) {
            ItemStack slotStack = inventoryCrafting.func_70301_a(i);
            if (slotStack == null || slotStack.func_77973_b() == null || !(slotStack.func_77973_b() instanceof ItemSupremiumArmor)) continue;
            tags = NBTHelper.getDataMap(slotStack).func_74737_b();
            int newDamage = MathHelper.clamp_int((int)slotStack.func_77952_i(), (int)0, (int)result.func_77958_k());
            result.func_77964_b(newDamage);
            break;
        }
        if (tags != null) {
            result.func_77982_d(tags);
        }
        return result;
    }

    public int getRecipeSize() {
        return this.input.length;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public ItemStack[] getRemainingItems(InventoryCrafting inv) {
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting inv, @Nonnull World world) {
        for (int x = 0; x <= 3 - this.width; ++x) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                if (this.checkMatch(inv, x, y, false)) {
                    return true;
                }
                if (!this.mirrored || !this.checkMatch(inv, x, y, true)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Object target = null;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? this.input[this.width - subX - 1 + subY * this.width] : this.input[subX + subY * this.width];
                }
                ItemStack slot = inv.func_70463_b(x, y);
                if (target instanceof ItemStack) {
                    if (OreDictionary.itemMatches((ItemStack)((ItemStack)target), (ItemStack)slot, (boolean)false)) continue;
                    return false;
                }
                if (target instanceof List) {
                    boolean matched = false;
                    Iterator itr = ((List)target).iterator();
                    while (itr.hasNext() && !matched) {
                        matched = OreDictionary.itemMatches((ItemStack)((ItemStack)itr.next()), (ItemStack)slot, (boolean)false);
                    }
                    if (matched) continue;
                    return false;
                }
                if (target != null || slot == null) continue;
                return false;
            }
        }
        return true;
    }

    public TinkeringTableRecipe setMirrored(boolean mirror) {
        this.mirrored = mirror;
        return this;
    }

    public Object[] getInput() {
        return this.input;
    }
}

