/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.items.tools;

import com.blakebr0.cucumber.iface.IRepairMaterial;
import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.items.ItemCrafting;
import com.blakebr0.mysticalagriculture.items.ModItems;
import com.blakebr0.mysticalagriculture.items.tools.ToolType;
import com.blakebr0.mysticalagriculture.lib.Tooltips;
import com.blakebr0.mysticalagriculture.util.NBTHelper;
import com.blakebr0.mysticalagriculture.util.ToolTools;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemEssenceAxe
extends ItemAxe
implements IRepairMaterial {
    public ItemStack repairMaterial;
    public TextFormatting color;

    public ItemEssenceAxe(String name, Item.ToolMaterial material, float damage, TextFormatting color) {
        super(material, damage, -3.2f);
        this.func_77655_b("ma." + name);
        this.func_77637_a(MysticalAgriculture.tabMysticalAgriculture);
        this.color = color;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        int damage = stack.func_77958_k() - stack.func_77952_i();
        tooltip.add(Tooltips.DURABILITY + this.color + (damage > -1 ? Integer.valueOf(damage) : Tooltips.UNLIMITED));
        if (OreDictionary.itemMatches((ItemStack)this.getRepairMaterial(), (ItemStack)ItemCrafting.itemSupremiumIngot, (boolean)false)) {
            NBTTagCompound tag = NBTHelper.getDataMap(stack);
            if (tag.func_74764_b("ToolType")) {
                tooltip.add(Tooltips.CHARM_SLOT + "\u00a7c" + ToolType.byIndex(tag.func_74762_e("ToolType")).getLocalizedName());
            } else {
                tooltip.add(Tooltips.CHARM_SLOT + "\u00a7c" + Tooltips.EMPTY);
            }
        }
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return OreDictionary.itemMatches((ItemStack)this.getRepairMaterial(), (ItemStack)repair, (boolean)false);
    }

    public void setRepairMaterial(ItemStack stack) {
        this.repairMaterial = stack;
    }

    public ItemStack getRepairMaterial() {
        return this.repairMaterial;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        NBTTagCompound tag;
        if (stack.func_77973_b() == ModItems.itemSupremiumAxe && (tag = NBTHelper.getDataMap(stack)).func_74764_b("ToolType") && tag.func_74762_e("ToolType") == ToolType.MINING_AOE.getIndex()) {
            boolean blocks = false;
            RayTraceResult ray = ToolTools.getBlockWithinReach(player.func_130014_f_(), player);
            if (ray != null) {
                int side = ray.field_178784_b.ordinal();
                blocks = this.harvest(stack, 1, player.func_130014_f_(), pos, side, player);
            }
            return blocks;
        }
        return super.onBlockStartBreak(stack, pos, player);
    }

    public boolean harvest(ItemStack stack, int radius, World world, BlockPos pos, int side, EntityPlayer player) {
        int xRange = radius;
        int yRange = radius;
        int zRange = 0;
        if (side == 0 || side == 1) {
            zRange = radius;
            yRange = 0;
        }
        if (side == 4 || side == 5) {
            xRange = 0;
            zRange = radius;
        }
        IBlockState state = world.func_180495_p(pos);
        float hardness = state.func_185887_b(world, pos);
        if (!this.canHarvest(world, pos, false, stack, player)) {
            return false;
        }
        if (radius > 0 && hardness >= 0.2f && state.func_177230_c().isToolEffective("axe", state)) {
            Iterable blocks = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-xRange, -yRange, -zRange), (BlockPos)pos.func_177982_a(xRange, yRange, zRange));
            for (BlockPos aoePos : blocks) {
                if (aoePos == pos) continue;
                IBlockState aoeState = world.func_180495_p(aoePos);
                if (aoeState.func_185887_b(world, aoePos) <= hardness + 5.0f) {
                    if (!aoeState.func_177230_c().isToolEffective("axe", aoeState)) continue;
                    this.canHarvest(world, aoePos, true, stack, player);
                    continue;
                }
                return false;
            }
        }
        return true;
    }

    private boolean canHarvest(World world, BlockPos pos, boolean extra, ItemStack stack, EntityPlayer player) {
        boolean harvest;
        IBlockState state = world.func_180495_p(pos);
        float hardness = state.func_185887_b(world, pos);
        Block block = state.func_177230_c();
        boolean bl = harvest = !(!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos) && !this.canHarvestBlock(state, stack) || extra && !(this.func_150893_a(stack, world.func_180495_p(pos)) > 1.0f));
        if (hardness >= 0.0f && (!extra || harvest)) {
            return ToolTools.breakBlocksAOE(stack, world, player, pos);
        }
        return false;
    }
}

