/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.items.tools;

import com.blakebr0.cucumber.iface.IRepairMaterial;
import com.blakebr0.cucumber.item.ItemBase;
import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.items.ItemCrafting;
import com.blakebr0.mysticalagriculture.items.ModItems;
import com.blakebr0.mysticalagriculture.items.tools.ToolType;
import com.blakebr0.mysticalagriculture.lib.Tooltips;
import com.blakebr0.mysticalagriculture.util.NBTHelper;
import com.blakebr0.mysticalagriculture.util.ToolTools;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemEssenceSickle
extends ItemBase
implements IRepairMaterial {
    public int range;
    public Item.ToolMaterial toolMaterial;
    public ItemStack repairMaterial;
    public TextFormatting color;

    public ItemEssenceSickle(String name, int range, Item.ToolMaterial material, TextFormatting color) {
        super("ma." + name);
        this.func_77625_d(1);
        this.func_77656_e(material.func_77997_a());
        this.func_77637_a(MysticalAgriculture.tabMysticalAgriculture);
        this.range = range;
        this.toolMaterial = material;
        this.color = color;
    }

    public int getRange(ItemStack stack) {
        NBTTagCompound tag;
        if (stack.func_77973_b() == ModItems.itemSupremiumSickle && (tag = NBTHelper.getDataMap(stack)).func_74764_b("ToolType") && tag.func_74762_e("ToolType") == ToolType.REAPING_AOE.getIndex()) {
            return this.range + 1;
        }
        return this.range;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return state.func_185904_a() == Material.field_151584_j || state.func_185904_a() == Material.field_151585_k || state.func_185904_a() == Material.field_151582_l ? this.toolMaterial.func_77998_b() / 2.0f : super.func_150893_a(stack, state);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        this.harvest(stack, this.getRange(stack), player.func_130014_f_(), pos, player);
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        int damage = stack.func_77958_k() - stack.func_77952_i();
        tooltip.add(Tooltips.DURABILITY + this.color + (damage > -1 ? Integer.valueOf(damage) : Tooltips.UNLIMITED));
        if (OreDictionary.itemMatches((ItemStack)this.getRepairMaterial(), (ItemStack)ItemCrafting.itemSupremiumIngot, (boolean)false)) {
            NBTTagCompound tag = NBTHelper.getDataMap(stack);
            if (tag.func_74764_b("ToolType")) {
                tooltip.add(Tooltips.CHARM_SLOT + "\u00a7c" + ToolType.byIndex(tag.func_74762_e("ToolType")).getLocalizedName());
            } else {
                tooltip.add(Tooltips.CHARM_SLOT + "\u00a7c" + Tooltips.EMPTY);
            }
        }
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return OreDictionary.itemMatches((ItemStack)this.getRepairMaterial(), (ItemStack)repair, (boolean)false);
    }

    public void setRepairMaterial(ItemStack stack) {
        this.repairMaterial = stack;
    }

    public ItemStack getRepairMaterial() {
        return this.repairMaterial;
    }

    public boolean harvest(ItemStack stack, int radius, World world, BlockPos pos, EntityPlayer player) {
        IBlockState state = world.func_180495_p(pos);
        float hardness = state.func_185887_b(world, pos);
        if (!this.canHarvest(world, pos, false, stack, player) || state.func_185904_a() != Material.field_151584_j && state.func_185904_a() != Material.field_151585_k && state.func_185904_a() != Material.field_151582_l) {
            stack.func_77972_a(1, (EntityLivingBase)player);
            return false;
        }
        if (radius > 0) {
            int used = 0;
            Iterable blocks = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-radius, -radius, -radius), (BlockPos)pos.func_177982_a(radius, radius, radius));
            for (BlockPos aoePos : blocks) {
                if (aoePos == pos) continue;
                IBlockState aoeState = world.func_180495_p(aoePos);
                if (aoeState.func_185887_b(world, aoePos) <= hardness + 5.0f) {
                    int usesLeft;
                    if (aoeState.func_185904_a() != Material.field_151584_j && aoeState.func_185904_a() != Material.field_151585_k && aoeState.func_185904_a() != Material.field_151582_l || used >= (usesLeft = stack.func_77958_k() - stack.func_77952_i() + 1) && stack.func_77958_k() != -1 || !this.canHarvest(world, aoePos, true, stack, player)) continue;
                    if (aoeState.func_185887_b(world, aoePos) <= 0.0f) {
                        if (Utils.randInt((int)1, (int)3) != 1) continue;
                        ++used;
                        continue;
                    }
                    ++used;
                    continue;
                }
                return false;
            }
            if (used > 0 && !player.field_71075_bZ.field_75098_d) {
                stack.func_77972_a(used, (EntityLivingBase)player);
            }
        }
        return true;
    }

    private boolean canHarvest(World world, BlockPos pos, boolean extra, ItemStack stack, EntityPlayer player) {
        boolean harvest;
        IBlockState state = world.func_180495_p(pos);
        float hardness = state.func_185887_b(world, pos);
        Block block = state.func_177230_c();
        boolean bl = harvest = !(!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos) && !this.canHarvestBlock(state, stack) || extra && !(this.func_150893_a(stack, world.func_180495_p(pos)) > 1.0f));
        if (hardness >= 0.0f && (!extra || harvest)) {
            return ToolTools.breakBlocksAOE(stack, world, player, pos);
        }
        return false;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.toolMaterial.func_78000_c(), 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -2.5, 0));
        }
        return multimap;
    }
}

