/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.crafting.cauldron;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import pl.asie.charset.lib.notify.Notice;
import pl.asie.charset.lib.notify.component.NotificationComponent;
import pl.asie.charset.lib.notify.component.NotificationComponentFluidStack;
import pl.asie.charset.lib.notify.component.NotificationComponentTextComponent;
import pl.asie.charset.lib.utils.FluidUtils;
import pl.asie.charset.lib.utils.ItemUtils;
import pl.asie.charset.module.crafting.cauldron.CharsetCraftingCauldron;
import pl.asie.charset.module.crafting.cauldron.TileCauldronCharset;
import pl.asie.charset.module.crafting.cauldron.api.CauldronContents;
import pl.asie.charset.module.crafting.cauldron.api.ICauldron;

public class BlockCauldronCharset
extends BlockCauldron
implements ITileEntityProvider {
    protected static final AxisAlignedBB AABB_INSIDE = new AxisAlignedBB(0.125, 0.3125, 0.125, 0.875, 1.0, 0.875);

    public BlockCauldronCharset() {
        this.func_149663_c("cauldron");
        this.func_149711_c(2.0f);
    }

    private boolean isEmptyOrWater(IBlockAccess access, BlockPos pos) {
        TileEntity tile = access.func_175625_s(pos);
        if (tile instanceof TileCauldronCharset) {
            return ((TileCauldronCharset)tile).isEmptyOrWater();
        }
        return true;
    }

    protected void onVanillaMethodCalled(IBlockAccess access, BlockPos pos, IBlockState state) {
        TileEntity tile = access.func_175625_s(pos);
        if (tile instanceof TileCauldronCharset) {
            ((TileCauldronCharset)tile).rebuildFromVanillaLevel(state);
        }
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        TileEntity tile;
        if (!worldIn.field_72995_K && (tile = worldIn.func_175625_s(pos)) instanceof TileCauldronCharset) {
            FluidStack stack = ((TileCauldronCharset)tile).getContents();
            float height = (float)pos.func_177956_o() + ((TileCauldronCharset)tile).getFluidHeight() / 16.0f;
            if (stack != null && stack.amount > 0 && entityIn.func_174813_aQ().field_72338_b <= (double)height) {
                EntityItem entityItem;
                ItemStack heldItem;
                if (stack.getFluid() == FluidRegistry.LAVA) {
                    if (!entityIn.func_70027_ad() && stack.amount >= 100 && !entityIn.func_70045_F()) {
                        entityIn.func_70015_d(stack.amount / 100);
                        return;
                    }
                } else if (stack.getFluid() == FluidRegistry.WATER && entityIn.func_70027_ad() && stack.amount >= 250) {
                    entityIn.func_70066_B();
                    ((TileCauldronCharset)tile).drain(250, true);
                    return;
                }
                if (entityIn instanceof EntityItem && !(heldItem = (entityItem = (EntityItem)entityIn).func_92059_d()).func_190926_b()) {
                    ItemStack heldItemOne = heldItem.func_77946_l();
                    heldItemOne.func_190920_e(1);
                    Optional<Object> contentsNew = Optional.empty();
                    Optional fluidResult = FluidUtils.handleTank((IFluidHandler)((IFluidHandler)tile), (FluidStack)stack, (World)worldIn, (BlockPos)pos, (ItemStack)heldItemOne, (boolean)false, (boolean)true, (boolean)false);
                    if (fluidResult.isPresent()) {
                        contentsNew = Optional.of(new CauldronContents(((TileCauldronCharset)tile).getContents(), (ItemStack)fluidResult.get()));
                    }
                    if (!contentsNew.isPresent()) {
                        contentsNew = CharsetCraftingCauldron.craft((ICauldron)tile, new CauldronContents(CauldronContents.Source.ENTITY, stack, heldItemOne));
                    }
                    if (contentsNew.isPresent()) {
                        CauldronContents cc = (CauldronContents)contentsNew.get();
                        if (cc.hasResponse()) {
                            new Notice((Object)tile, (NotificationComponent)new NotificationComponentTextComponent(cc.getResponse())).sendToAll();
                        } else {
                            if (cc.getHeldItem().func_190926_b()) {
                                heldItem.func_190918_g(1);
                            } else if (cc.getHeldItem().func_190916_E() != 1 || !ItemUtils.canMerge((ItemStack)cc.getHeldItem(), (ItemStack)heldItem)) {
                                heldItem.func_190918_g(1);
                                ItemUtils.spawnItemEntity((World)worldIn, (Vec3d)entityItem.func_174791_d(), (ItemStack)cc.getHeldItem(), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                            }
                            ((TileCauldronCharset)tile).setContents(cc.getFluidStack());
                        }
                    }
                }
            }
        }
    }

    private void notice(World worldIn, TileEntity tankEntity, EntityPlayer playerIn) {
        if (!worldIn.field_72995_K && tankEntity instanceof TileCauldronCharset) {
            FluidStack stack = ((TileCauldronCharset)tankEntity).getContents();
            new Notice((Object)tankEntity, (NotificationComponent)new NotificationComponentFluidStack(stack, true)).sendTo(playerIn);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tankEntity = worldIn.func_175625_s(pos);
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (heldItem.func_190926_b()) {
            this.notice(worldIn, tankEntity, playerIn);
            return true;
        }
        if (this.isEmptyOrWater((IBlockAccess)worldIn, pos) && super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ)) {
            return true;
        }
        if (hand != EnumHand.MAIN_HAND) {
            return false;
        }
        if (tankEntity instanceof TileCauldronCharset) {
            if (FluidUtils.handleTank((IFluidHandler)((IFluidHandler)tankEntity), (FluidStack)((TileCauldronCharset)tankEntity).getContents(), (World)worldIn, (BlockPos)pos, (EntityPlayer)playerIn, (EnumHand)hand)) {
                return true;
            }
            if (!heldItem.func_190926_b()) {
                FluidStack stack = ((TileCauldronCharset)tankEntity).getContents();
                ItemStack heldItemOne = heldItem.func_77946_l();
                heldItemOne.func_190920_e(1);
                Optional<CauldronContents> contentsNew = CharsetCraftingCauldron.craft((ICauldron)tankEntity, new CauldronContents(CauldronContents.Source.HAND, stack, heldItemOne));
                if (contentsNew.isPresent()) {
                    if (!worldIn.field_72995_K) {
                        boolean success = false;
                        CauldronContents cc = contentsNew.get();
                        if (cc.hasResponse()) {
                            new Notice((Object)tankEntity, (NotificationComponent)new NotificationComponentTextComponent(cc.getResponse())).sendTo(playerIn);
                        } else {
                            if (cc.getHeldItem().func_190926_b()) {
                                if (!playerIn.func_184812_l_()) {
                                    heldItem.func_190918_g(1);
                                }
                                success = true;
                            } else if (cc.getHeldItem().func_190916_E() == 1 && ItemUtils.canMerge((ItemStack)cc.getHeldItem(), (ItemStack)heldItem)) {
                                success = true;
                            } else if (heldItem.func_190916_E() > 1) {
                                if (playerIn.field_71071_by.func_70441_a(cc.getHeldItem())) {
                                    heldItem.func_190918_g(1);
                                    success = true;
                                }
                            } else if (heldItem.func_190916_E() == 1) {
                                playerIn.func_184611_a(hand, cc.getHeldItem());
                                success = true;
                            }
                            if (success) {
                                ((TileCauldronCharset)tankEntity).setContents(cc.getFluidStack());
                            }
                        }
                    }
                    return true;
                }
            }
        }
        if (!playerIn.func_70093_af()) {
            this.notice(worldIn, tankEntity, playerIn);
            return true;
        }
        return false;
    }

    public void func_176224_k(World worldIn, BlockPos pos) {
        FluidStack stack;
        TileEntity tile;
        float f = worldIn.func_180494_b(pos).func_180626_a(pos);
        if (worldIn.func_72959_q().func_76939_a(f, pos.func_177956_o()) >= 0.15f && (tile = worldIn.func_175625_s(pos)) instanceof TileCauldronCharset && ((stack = ((TileCauldronCharset)tile).getContents()) == null || stack.getFluid() == FluidRegistry.WATER || stack.getFluid() == CharsetCraftingCauldron.dyedWater) && (stack == null || stack.amount < 667)) {
            ((TileCauldronCharset)tile).fill(new FluidStack(FluidRegistry.WATER, Math.min(40, 667 - (stack == null ? 0 : stack.amount))), true);
        }
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileCauldronCharset) {
            return ((TileCauldronCharset)tile).getComparatorValue();
        }
        return (Integer)blockState.func_177229_b((IProperty)field_176591_a);
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileCauldronCharset();
    }
}

