/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.crafting.cauldron;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorldEventListener;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.lib.config.CharsetLoadConfigEvent;
import pl.asie.charset.lib.config.ConfigUtils;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.render.sprite.TextureWhitener;
import pl.asie.charset.lib.utils.RegistryUtils;
import pl.asie.charset.module.crafting.cauldron.BlockCauldronCharset;
import pl.asie.charset.module.crafting.cauldron.CauldronLevelUpdateListener;
import pl.asie.charset.module.crafting.cauldron.TileCauldronCharset;
import pl.asie.charset.module.crafting.cauldron.TileRendererCauldronCharset;
import pl.asie.charset.module.crafting.cauldron.api.CauldronContents;
import pl.asie.charset.module.crafting.cauldron.api.ICauldron;
import pl.asie.charset.module.crafting.cauldron.api.ICauldronRecipe;
import pl.asie.charset.module.crafting.cauldron.fluid.FluidDyedWater;
import pl.asie.charset.module.crafting.cauldron.recipe.RecipeBucketCraft;
import pl.asie.charset.module.crafting.cauldron.recipe.RecipeDyeItem;
import pl.asie.charset.module.crafting.cauldron.recipe.RecipeDyeItemPure;
import pl.asie.charset.module.crafting.cauldron.recipe.RecipeDyeWater;
import pl.asie.charset.module.crafting.cauldron.recipe.RecipeWashDyedWater;

@CharsetModule(name="crafting.cauldron", description="Improved Cauldron!", profile=ModuleProfile.FORCED, antidependencies={"mod:inspirations"})
public class CharsetCraftingCauldron {
    public static int waterBottleSize = 0;
    public static int waterAlpha = 180;
    public static BlockCauldronCharset blockCauldron;
    public static FluidDyedWater dyedWater;
    private static List<ICauldronRecipe> recipeList;
    @CharsetModule.Configuration
    public static Configuration config;
    private static final ResourceLocation WATER_STILL;
    private static final ResourceLocation WATER_FLOWING;

    public static void add(ICauldronRecipe recipe) {
        recipeList.add(recipe);
    }

    public static Optional<CauldronContents> craft(ICauldron cauldronCharset, CauldronContents contents) {
        for (ICauldronRecipe recipe : recipeList) {
            Optional<CauldronContents> contentsNew;
            if (!recipe.matches(contents.getSource()) || !(contentsNew = recipe.apply(cauldronCharset, contents)).isPresent()) continue;
            return contentsNew;
        }
        return Optional.empty();
    }

    @Mod.EventHandler
    public void onLoadConfig(CharsetLoadConfigEvent event) {
        waterBottleSize = ConfigUtils.getInt((Configuration)config, (String)"balance", (String)"waterBottleSize", (int)0, (int)0, (int)1000, (String)"Set the amount of water contained in one water bottle for Cauldron usage. The default, 0, will approximate between 333 and 334 mB to mimic vanilla. A recommended value is 250.", (boolean)true);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        blockCauldron = new BlockCauldronCharset();
        dyedWater = new FluidDyedWater("dyed_water");
        FluidRegistry.registerFluid((Fluid)dyedWater);
        dyedWater.setUnlocalizedName("charset.dyed_water");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        recipeList.add(new RecipeDyeWater());
        recipeList.add(new RecipeDyeItem());
        recipeList.add(new RecipeDyeItemPure());
        recipeList.add(new RecipeWashDyedWater());
        recipeList.add(new RecipeBucketCraft());
        RegistryUtils.register(TileCauldronCharset.class, (String)"improved_cauldron");
        FMLInterModComms.sendMessage((String)"charset", (String)"addLock", (String)"minecraft:cauldron");
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void initClient(FMLInitializationEvent event) {
        ClientRegistry.bindTileEntitySpecialRenderer(TileCauldronCharset.class, (TileEntitySpecialRenderer)new TileRendererCauldronCharset());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onTextureStitchPre(TextureStitchEvent.Pre event) {
        TextureWhitener.INSTANCE.remap(event.getMap(), WATER_STILL, FluidDyedWater.TEXTURE_STILL, WATER_STILL);
        TextureWhitener.INSTANCE.remap(event.getMap(), WATER_FLOWING, FluidDyedWater.TEXTURE_FLOWING, WATER_STILL);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    @SideOnly(value=Side.CLIENT)
    public void onModelBake(ModelBakeEvent event) {
        IBakedModel l0 = (IBakedModel)event.getModelRegistry().func_82594_a((Object)new ModelResourceLocation("minecraft:cauldron#level=0"));
        if (l0 != null) {
            event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("minecraft:cauldron#level=1"), (Object)l0);
            event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("minecraft:cauldron#level=2"), (Object)l0);
            event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("minecraft:cauldron#level=3"), (Object)l0);
        }
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().register(blockCauldron.setRegistryName("minecraft:cauldron"));
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K) {
            event.getWorld().func_72954_a((IWorldEventListener)CauldronLevelUpdateListener.INSTANCE);
        }
    }

    static {
        recipeList = new ArrayList<ICauldronRecipe>();
        WATER_STILL = new ResourceLocation("minecraft:blocks/water_still");
        WATER_FLOWING = new ResourceLocation("minecraft:blocks/water_flow");
    }
}

