/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.crafting.compression;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import pl.asie.charset.ModCharset;
import pl.asie.charset.api.lib.IItemInsertionHandler;
import pl.asie.charset.lib.Properties;
import pl.asie.charset.lib.capability.Capabilities;
import pl.asie.charset.lib.capability.CapabilityHelper;
import pl.asie.charset.lib.material.FastRecipeLookup;
import pl.asie.charset.lib.notify.Notice;
import pl.asie.charset.lib.notify.component.NotificationComponent;
import pl.asie.charset.lib.notify.component.NotificationComponentString;
import pl.asie.charset.lib.utils.ItemUtils;
import pl.asie.charset.lib.utils.Orientation;
import pl.asie.charset.lib.utils.RecipeUtils;
import pl.asie.charset.module.crafting.compression.BlockCompressionCrafter;
import pl.asie.charset.module.crafting.compression.CharsetCraftingCompression;
import pl.asie.charset.module.crafting.compression.TileCompressionCrafter;
import pl.asie.charset.module.crafting.compression.grid.GridEntry;
import pl.asie.charset.module.crafting.compression.grid.GridEntryBarrel;
import pl.asie.charset.module.storage.barrels.TileEntityDayBarrel;

public class CompressionShape {
    private static final int MAX_WIDTH = 3;
    private static final int MAX_HEIGHT = 3;
    protected final World world;
    protected final Multimap<EnumFacing, BlockPos> expectedFacings = MultimapBuilder.enumKeys(EnumFacing.class).arrayListValues().build();
    protected final List<TileCompressionCrafter> compressionCrafters = new ArrayList<TileCompressionCrafter>();
    protected final List<GridEntry> grid = new ArrayList<GridEntry>();
    protected int width;
    protected int height;
    protected BlockPos topLeft;
    protected EnumFacing topDir;
    protected EnumFacing leftDir;
    protected EnumFacing bottomDir;
    protected EnumFacing rightDir;
    protected Orientation barrelOrientation;
    private boolean invalid = false;
    private final boolean[] lastRedstoneLevels = new boolean[6];
    protected long lastTickChecked = -1L;
    protected long craftingTickStart = -1L;
    protected long craftingTickEnd = -1L;
    protected int craftingCount = 0;
    protected Set<EnumFacing> craftingDirections;
    protected BlockPos craftingSourcePos;
    protected EnumFacing craftingSourceDir;

    private CompressionShape(World world) {
        this.world = world;
    }

    protected float getRenderProgress(float partialTicks) {
        if (this.craftingTickStart < 0L || this.craftingTickEnd < 0L) {
            return -1.0f;
        }
        double duration = (float)(this.craftingTickEnd - this.craftingTickStart) / 2.0f;
        double currTime = (float)(this.world.func_82737_E() - this.craftingTickStart) + partialTicks;
        if (currTime >= duration * 2.0) {
            return -1.0f;
        }
        if (currTime <= 0.0) {
            return 0.0f;
        }
        if (currTime >= duration) {
            currTime = duration * 2.0 - currTime;
        }
        float progress = (float)Math.sin((float)(currTime * Math.PI / 2.0 / duration));
        return progress * ((float)(this.width + this.height) / 2.0f + 1.0f) * 0.06f;
    }

    protected Set<EnumFacing> checkPowerLevels(boolean clearOnly) {
        EnumSet<EnumFacing> set = EnumSet.noneOf(EnumFacing.class);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            boolean lastLevel = this.lastRedstoneLevels[facing.ordinal()];
            boolean currLevel = this.isFacePowered(facing);
            if (currLevel && !lastLevel) {
                set.add(facing);
            }
            if (clearOnly && currLevel) continue;
            this.lastRedstoneLevels[facing.ordinal()] = !ModCharset.isModuleLoaded((String)"power.mechanical") ? currLevel : false;
        }
        return set;
    }

    private boolean isFacePowered(EnumFacing side) {
        for (TileCompressionCrafter tile : this.compressionCrafters) {
            if (!this.expectedFacings.get((Object)side).contains(tile.func_174877_v()) || !tile.isCraftingReady()) continue;
            return true;
        }
        return false;
    }

    public Orientation getBarrelOrientation() {
        return this.barrelOrientation;
    }

    public boolean isInvalid() {
        if (this.invalid) {
            return true;
        }
        if (!this.world.field_72995_K) {
            boolean hasPower = false;
            for (TileCompressionCrafter crafter : this.compressionCrafters) {
                if (!crafter.isCraftingReady()) continue;
                hasPower = true;
                break;
            }
            if (!hasPower) {
                return true;
            }
        }
        for (Map.Entry entry : this.expectedFacings.entries()) {
            if (this.getCrafterDirection((BlockPos)entry.getValue()) == entry.getKey()) continue;
            this.invalid = true;
            return true;
        }
        for (GridEntry gridEntry : this.grid) {
            if (!gridEntry.isInvalid()) continue;
            this.invalid = true;
            return true;
        }
        return false;
    }

    private void addItemHandlers(Collection<IItemInsertionHandler> outputs, EnumFacing sourceDir, Collection<BlockPos> positions) {
        for (BlockPos sourcePos : positions) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                IItemInsertionHandler output;
                BlockPos spos;
                if (facing == sourceDir || positions.contains(spos = sourcePos.func_177972_a(facing)) || (output = (IItemInsertionHandler)CapabilityHelper.get((IBlockAccess)this.world, (BlockPos)spos, (Capability)Capabilities.ITEM_INSERTION_HANDLER, (EnumFacing)facing.func_176734_d(), (boolean)false, (boolean)true, (boolean)false)) == null) continue;
                outputs.add(output);
            }
        }
    }

    private boolean outputStack(ItemStack stack, Collection<IItemInsertionHandler> outputs, boolean simulate) {
        for (IItemInsertionHandler output : outputs) {
            if (stack.func_190926_b()) break;
            stack = output.insertItem(stack, simulate);
        }
        if (!stack.func_190926_b()) {
            if (!simulate) {
                TileEntity tile = this.world.func_175625_s(this.craftingSourcePos);
                if (tile instanceof TileCompressionCrafter && ((TileCompressionCrafter)tile).backstuff(stack)) {
                    stack = ItemStack.field_190927_a;
                }
                if (!stack.func_190926_b()) {
                    for (TileCompressionCrafter crafter : this.compressionCrafters) {
                        boolean f = false;
                        for (EnumFacing facing : this.craftingDirections) {
                            if (!this.expectedFacings.containsEntry((Object)facing, (Object)crafter.func_174877_v())) continue;
                            f = true;
                            break;
                        }
                        if (!f || !crafter.backstuff(stack)) continue;
                        stack = ItemStack.field_190927_a;
                        break;
                    }
                }
                if (!stack.func_190926_b()) {
                    ModCharset.logger.error("Compression Crafter dropping item at " + this.craftingSourcePos + " - this should NOT happen!");
                    ItemUtils.spawnItemEntity((World)this.world, (Vec3d)new Vec3d((Vec3i)this.craftingSourcePos.func_177972_a(this.craftingSourceDir.func_176734_d())).func_72441_c(0.5, 0.5, 0.5), (ItemStack)stack, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean craftBegin(TileCompressionCrafter sender, EnumFacing sourceDir) {
        if (this.craftingTickEnd >= this.world.func_82737_E()) {
            return false;
        }
        Set<EnumFacing> validSides = this.checkPowerLevels(false);
        if (validSides.isEmpty()) {
            return false;
        }
        double speed = 0.0;
        double torque = 0.0;
        for (TileCompressionCrafter crafter : this.compressionCrafters) {
            if (crafter.isBackstuffed()) {
                new Notice((Object)crafter, (NotificationComponent)NotificationComponentString.translated((String)"notice.charset.compression.backstuffed", (NotificationComponent[])new NotificationComponent[0]));
                return false;
            }
            speed = Math.max(speed, crafter.getSpeed());
            torque += crafter.getTorque();
        }
        if (speed <= 0.0 || torque < 1.0) {
            return false;
        }
        this.craftingDirections = validSides;
        this.craftingSourcePos = sender.func_174877_v();
        this.craftingSourceDir = sourceDir;
        Optional<String> error = this.craftEnd(true);
        if (!error.isPresent()) {
            this.craftingTickStart = this.world.func_82737_E();
            this.craftingTickEnd = this.world.func_82737_E() + Math.round(20.0 / speed);
            this.craftingCount = (int)Math.floor(torque);
            CharsetCraftingCompression.proxy.markShapeRender(sender, this);
            return true;
        }
        if (error.get().length() > 0) {
            new Notice((Object)sender, (NotificationComponent)NotificationComponentString.translated((String)error.get(), (NotificationComponent[])new NotificationComponent[0])).sendToAll();
        }
        return false;
    }

    public Optional<String> craftEnd(boolean simulate) {
        InventoryCrafting crafting = RecipeUtils.getCraftingInventory((int)this.width, (int)this.height);
        IRecipe recipe = null;
        Set<EnumFacing> validSides = this.craftingDirections;
        ArrayList<IItemInsertionHandler> outputs = new ArrayList<IItemInsertionHandler>();
        for (EnumFacing facing : validSides) {
            this.addItemHandlers(outputs, facing, this.expectedFacings.get((Object)facing));
        }
        if (outputs.isEmpty()) {
            return Optional.of("notice.charset.compression.need_output");
        }
        for (int c = 0; c < this.craftingCount; ++c) {
            boolean hasNonEmpty = false;
            for (int i = 0; i < this.width * this.height; ++i) {
                ItemStack stack = this.grid.get(i).getCraftingStack();
                if (!stack.func_190926_b()) {
                    hasNonEmpty = true;
                }
                crafting.func_70299_a(i, stack);
            }
            if (!hasNonEmpty) {
                return Optional.of("");
            }
            if (c == 0 && (recipe = FastRecipeLookup.findMatchingRecipe((InventoryCrafting)crafting, (World)this.world)) == null) {
                return Optional.of("notice.charset.compression.cannot_craft");
            }
            ItemStack stack = recipe.func_77572_b(crafting);
            if (stack.func_190926_b()) {
                if (c == 0) {
                    return Optional.of("notice.charset.compression.cannot_craft");
                }
                return Optional.empty();
            }
            if (!this.outputStack(stack.func_77946_l(), outputs, simulate)) {
                return Optional.of("notice.charset.compression.need_output_room");
            }
            NonNullList remainingItems = recipe.func_179532_b(crafting);
            for (int i = 0; i < this.width * this.height; ++i) {
                ItemStack rem = this.grid.get(i).mergeRemainingItem((ItemStack)remainingItems.get(i), simulate);
                if (rem.func_190926_b() || this.outputStack(rem, outputs, simulate) || !simulate) continue;
                return Optional.of("notice.charset.compression.need_output_room");
            }
        }
        return Optional.empty();
    }

    private boolean setCrafterShapeIfMatchesDirection(BlockPos pos, EnumFacing facing) {
        TileEntity tile;
        if (!this.world.func_175668_a(pos, true)) {
            return false;
        }
        IBlockState state = this.world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockCompressionCrafter && state.func_177229_b((IProperty)Properties.FACING) == facing && (tile = this.world.func_175625_s(pos)) instanceof TileCompressionCrafter) {
            ((TileCompressionCrafter)tile).shape = this;
            this.compressionCrafters.add((TileCompressionCrafter)tile);
            this.expectedFacings.put((Object)facing, (Object)pos);
            return true;
        }
        return false;
    }

    @Nullable
    private EnumFacing getCrafterDirection(BlockPos pos) {
        if (!this.world.func_175668_a(pos, true)) {
            return null;
        }
        IBlockState state = this.world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockCompressionCrafter) {
            return (EnumFacing)state.func_177229_b((IProperty)Properties.FACING);
        }
        return null;
    }

    private TileEntityDayBarrel getBarrel(BlockPos pos) {
        if (!this.world.func_175668_a(pos, true)) {
            return null;
        }
        TileEntity tile = this.world.func_175625_s(pos);
        return tile instanceof TileEntityDayBarrel ? (TileEntityDayBarrel)tile : null;
    }

    public static CompressionShape build(World world, BlockPos start) {
        int height;
        BlockPos tmp;
        int width;
        EnumFacing leftDir;
        EnumFacing topDir;
        BlockPos topLeft;
        CompressionShape shape;
        block15: {
            shape = new CompressionShape(world);
            EnumFacing firstBarrelFacing = shape.getCrafterDirection(start);
            if (firstBarrelFacing == null) {
                return null;
            }
            BlockPos firstBarrelPos = start.func_177972_a(firstBarrelFacing);
            TileEntity tile = world.func_175625_s(firstBarrelPos);
            if (!(tile instanceof TileEntityDayBarrel)) {
                return null;
            }
            shape.barrelOrientation = ((TileEntityDayBarrel)tile).orientation;
            topLeft = firstBarrelPos;
            topDir = shape.barrelOrientation.top;
            while (shape.getBarrel(topLeft.func_177972_a(topDir)) != null) {
                topLeft = topLeft.func_177972_a(topDir);
            }
            leftDir = shape.barrelOrientation.getPrevRotationOnFace().top;
            while (shape.getBarrel(topLeft.func_177972_a(leftDir)) != null) {
                topLeft = topLeft.func_177972_a(leftDir);
            }
            width = 1;
            tmp = topLeft;
            while (shape.getBarrel(tmp.func_177972_a(leftDir.func_176734_d())) != null) {
                tmp = tmp.func_177972_a(leftDir.func_176734_d());
                if (++width <= 3) continue;
                return null;
            }
            height = 1;
            do {
                tmp = topLeft.func_177967_a(topDir.func_176734_d(), height);
                int wDetected = 0;
                while (shape.getBarrel(tmp) != null) {
                    tmp = tmp.func_177972_a(leftDir.func_176734_d());
                    ++wDetected;
                }
                if (wDetected == 0) break block15;
                if (wDetected == width) continue;
                return null;
            } while (++height <= 3);
            return null;
        }
        shape.width = width;
        shape.height = height;
        shape.topDir = topDir;
        shape.leftDir = leftDir;
        shape.bottomDir = topDir.func_176734_d();
        shape.rightDir = leftDir.func_176734_d();
        shape.topLeft = topLeft;
        for (int yPos = 0; yPos < height; ++yPos) {
            tmp = topLeft.func_177967_a(shape.bottomDir, yPos);
            for (int xPos = 0; xPos < width; ++xPos) {
                TileEntityDayBarrel barrel = shape.getBarrel(tmp);
                if (barrel == null) {
                    ModCharset.logger.warn("Should never happen!", new Throwable());
                    return null;
                }
                if (barrel.orientation != shape.barrelOrientation) {
                    return null;
                }
                shape.grid.add(new GridEntryBarrel(barrel));
                if (xPos == 0 && !shape.setCrafterShapeIfMatchesDirection(tmp.func_177972_a(leftDir), shape.rightDir)) {
                    return null;
                }
                if (xPos == width - 1 && !shape.setCrafterShapeIfMatchesDirection(tmp.func_177972_a(shape.rightDir), leftDir)) {
                    return null;
                }
                if (yPos == 0 && !shape.setCrafterShapeIfMatchesDirection(tmp.func_177972_a(topDir), shape.bottomDir)) {
                    return null;
                }
                if (yPos == height - 1 && !shape.setCrafterShapeIfMatchesDirection(tmp.func_177972_a(shape.bottomDir), topDir)) {
                    return null;
                }
                tmp = tmp.func_177972_a(shape.rightDir);
            }
        }
        return shape;
    }

    public void tick() {
        long time = this.world.func_82737_E();
        if (this.lastTickChecked == time) {
            return;
        }
        if (this.craftingTickStart >= 0L) {
            if (this.isInvalid()) {
                this.craftingTickEnd = -1L;
                this.craftingTickStart = -1L;
            }
            if (time >= this.craftingTickStart && time < this.craftingTickEnd) {
                this.checkPowerLevels(true);
            } else if (time >= this.craftingTickEnd) {
                this.craftingTickEnd = -1L;
                this.craftingTickStart = -1L;
                if (!this.world.field_72995_K) {
                    this.craftEnd(false);
                }
            }
        }
        this.lastTickChecked = time;
    }
}

