/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.crafting.compression;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pl.asie.charset.lib.utils.RenderUtils;
import pl.asie.charset.module.crafting.compression.CTMTextureFactory;
import pl.asie.charset.module.crafting.compression.CharsetCraftingCompression;
import pl.asie.charset.module.crafting.compression.CompressionShape;
import pl.asie.charset.module.crafting.compression.CompressionShapeRenderer;
import pl.asie.charset.module.crafting.compression.ModelCompressionCrafter;
import pl.asie.charset.module.crafting.compression.ProxyCommon;
import pl.asie.charset.module.crafting.compression.TileCompressionCrafter;
import pl.asie.charset.module.crafting.compression.TileCompressionCrafterRenderer;

public class ProxyClient
extends ProxyCommon {
    private static final ModelResourceLocation bmLoc = new ModelResourceLocation("charset:compression_crafter", "normal");
    private static final ModelRotation[] ROTATIONS = new ModelRotation[]{ModelRotation.X180_Y0, ModelRotation.X0_Y0, ModelRotation.X90_Y0, ModelRotation.X90_Y180, ModelRotation.X90_Y270, ModelRotation.X90_Y90};
    protected static final IBakedModel[] rodModels = new IBakedModel[6];

    @Override
    public void init() {
        super.init();
        ClientRegistry.bindTileEntitySpecialRenderer(TileCompressionCrafter.class, (TileEntitySpecialRenderer)new TileCompressionCrafterRenderer());
        MinecraftForge.EVENT_BUS.register((Object)CompressionShapeRenderer.INSTANCE);
    }

    @Override
    public void markShapeRender(TileCompressionCrafter sender, CompressionShape shape) {
        if (shape.world.field_72995_K) {
            CompressionShapeRenderer.INSTANCE.addShape(shape);
        } else {
            super.markShapeRender(sender, shape);
        }
    }

    @SubscribeEvent
    public void onModelRegistry(ModelRegistryEvent event) {
        ModelLoader.setCustomStateMapper((Block)CharsetCraftingCompression.blockCompressionCrafter, blockIn -> {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (IBlockState state : blockIn.func_176194_O().func_177619_a()) {
                builder.put((Object)state, (Object)bmLoc);
            }
            return builder.build();
        });
    }

    @SubscribeEvent
    public void onTextureStitchPre(TextureStitchEvent.Pre event) {
        CTMTextureFactory.register(event.getMap(), new ResourceLocation("charset:blocks/compact/compact_bottom"));
        CTMTextureFactory.register(event.getMap(), new ResourceLocation("charset:blocks/compact/compact_top"));
        CTMTextureFactory.register(event.getMap(), new ResourceLocation("charset:blocks/compact/compact_side"));
        CTMTextureFactory.register(event.getMap(), new ResourceLocation("charset:blocks/compact/compact_inner"));
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        IBakedModel origModel = (IBakedModel)event.getModelRegistry().func_82594_a((Object)bmLoc);
        ModelCompressionCrafter result = new ModelCompressionCrafter(origModel);
        event.getModelRegistry().func_82595_a((Object)bmLoc, (Object)result);
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"Compression Crafter", (int)54);
        IModel modelRod = RenderUtils.getModel((ResourceLocation)new ResourceLocation("charset:block/compression_crafter_rod"));
        for (EnumFacing side : EnumFacing.field_82609_l) {
            bar.step("rod " + side.name());
            ProxyClient.rodModels[side.ordinal()] = modelRod.bake((IModelState)ROTATIONS[side.ordinal()], DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter());
        }
        IModel model = RenderUtils.getModel((ResourceLocation)new ResourceLocation("charset:block/compression_crafter_block"));
        IBlockState defState = CharsetCraftingCompression.blockCompressionCrafter.func_176223_P();
        for (int i = 0; i < 4; ++i) {
            IModel retexModel = model.retexture(ImmutableMap.of((Object)"top", (Object)("charset:blocks/compact/compact_inner#" + i), (Object)"bottom", (Object)("charset:blocks/compact/compact_bottom#" + i), (Object)"side_x", (Object)("charset:blocks/compact/compact_side#" + i), (Object)"side_z", (Object)("charset:blocks/compact/compact_side#" + i)));
            for (int k = 0; k < 12; ++k) {
                bar.step("crafter " + (i * 4 + k + 1) + "/48");
                if (i == 0 && k >= 6) {
                    for (EnumFacing side : EnumFacing.field_82609_l) {
                        result.quads[k][side.ordinal()][i] = result.quads[k - 6][side.ordinal()][i];
                    }
                    continue;
                }
                EnumFacing facing = EnumFacing.func_82600_a((int)(k % 6));
                ModelRotation modelState = ROTATIONS[k % 6];
                if (k >= 6) {
                    modelState = new ModelStateComposition((IModelState)modelState, (IModelState)ModelRotation.X0_Y90);
                }
                IBakedModel bakedModel = retexModel.bake((IModelState)modelState, DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter());
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    List list = bakedModel.func_188616_a(defState, side, 0L);
                    int j = i;
                    if (facing == EnumFacing.DOWN && (side == EnumFacing.SOUTH || side == EnumFacing.WEST) || facing == EnumFacing.UP && (side == EnumFacing.NORTH || side == EnumFacing.EAST) || (facing == EnumFacing.SOUTH || facing == EnumFacing.WEST) && (side.func_176740_k() == EnumFacing.Axis.Y || side.func_176740_k() == facing.func_176740_k() && k < 8) || facing == EnumFacing.DOWN && side == EnumFacing.UP && k >= 6 || facing.func_176740_k() != EnumFacing.Axis.Y && k >= 8 && side == facing.func_176746_e()) {
                        if (j == 1) {
                            j = 2;
                        } else if (j == 2) {
                            j = 1;
                        }
                    }
                    result.quads[k][side.ordinal()][j] = (BakedQuad)list.get(0);
                }
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
    }
}

