/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.crafting.compression.grid;

import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import pl.asie.charset.lib.utils.ItemUtils;
import pl.asie.charset.lib.utils.Orientation;
import pl.asie.charset.module.crafting.compression.grid.GridEntry;
import pl.asie.charset.module.storage.barrels.BarrelUpgrade;
import pl.asie.charset.module.storage.barrels.TileEntityDayBarrel;

public class GridEntryBarrel
extends GridEntry {
    private final TileEntityDayBarrel barrel;
    private final Orientation orientation;

    public GridEntryBarrel(TileEntityDayBarrel barrel) {
        super(barrel.func_145831_w(), barrel.func_174877_v());
        this.barrel = barrel;
        this.orientation = barrel.orientation;
    }

    @Override
    public ItemStack getCraftingStack() {
        ItemStack stack = this.barrel.item;
        if (!stack.func_190926_b()) {
            boolean copied = false;
            if (this.barrel.upgrades.contains(BarrelUpgrade.STICKY)) {
                stack = stack.func_77946_l();
                stack.func_190918_g(1);
                copied = true;
            }
            if (stack.func_190916_E() > 1) {
                if (!copied) {
                    stack = stack.func_77946_l();
                    copied = true;
                }
                stack.func_190920_e(1);
            }
        }
        return stack;
    }

    @Override
    public ItemStack mergeRemainingItem(ItemStack target, boolean simulate) {
        ItemStack source;
        ItemStack sourceOrig = source = this.barrel.item;
        if (!source.func_190926_b() && !this.barrel.upgrades.contains(BarrelUpgrade.INFINITE)) {
            sourceOrig = source.func_77946_l();
            if (!simulate) {
                source.func_190918_g(1);
                this.barrel.setItem(source);
            }
        }
        if (target.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (ItemUtils.canMerge((ItemStack)sourceOrig, (ItemStack)target)) {
            int maxGrow = Math.min(this.barrel.getMaxItemCount() - source.func_190916_E(), target.func_190916_E());
            if (maxGrow > 0) {
                if (!simulate) {
                    source.func_190917_f(maxGrow);
                    this.barrel.setItem(source);
                }
                if (maxGrow == target.func_190916_E()) {
                    return ItemStack.field_190927_a;
                }
                ItemStack targetCopy = target.func_77946_l();
                targetCopy.func_190918_g(maxGrow);
                return targetCopy;
            }
            return target;
        }
        return target;
    }

    @Override
    public boolean isInvalid() {
        return this.barrel.func_145837_r() || this.barrel.orientation != this.orientation;
    }

    @Override
    public TileEntity getTileEntity() {
        return this.barrel;
    }
}

