/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.block;

import cofh.core.block.BlockCore;
import cofh.core.render.IModelRegister;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.DamageHelper;
import cofh.core.util.helpers.EnergyHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.redstonearsenal.RedstoneArsenal;
import cofh.redstonearsenal.block.ItemBlockStorage;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockStorage
extends BlockCore
implements IInitializer,
IModelRegister {
    public static final PropertyEnum<Type> VARIANT = PropertyEnum.func_177709_a((String)"type", Type.class);
    static final AxisAlignedBB COLLISION_AABB = new AxisAlignedBB(0.00390625, 0.00390625, 0.00390625, 0.99609375, 0.99609375, 0.99609375);
    public static ItemStack blockElectrumFlux;
    public static ItemStack blockCrystalFlux;

    public BlockStorage() {
        super(Material.field_151573_f, "redstonearsenal");
        this.func_149663_c("storage");
        this.func_149647_a(RedstoneArsenal.tabCommon);
        this.func_149711_c(25.0f);
        this.func_149752_b(120.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Type.ELECTRUM_FLUX)));
        this.setHarvestLevel("pickaxe", 2);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (int i = 0; i < Type.METADATA_LOOKUP.length; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int func_180651_a(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        EntityPlayerMP player;
        entity.func_70097_a((DamageSource)DamageHelper.FLUX, 2.0f);
        if (entity instanceof EntityPlayerMP && EnergyHelper.isPlayerHoldingEnergyContainerItem((EntityPlayer)(player = (EntityPlayerMP)entity))) {
            EnergyHelper.insertEnergyIntoHeldContainer((EntityPlayer)player, (int)100, (boolean)false);
        }
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public boolean isBeaconBase(IBlockAccess worldObj, BlockPos pos, BlockPos beacon) {
        return true;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getLight();
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getHardness();
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        IBlockState state = world.func_180495_p(pos);
        return ((Type)((Object)state.func_177229_b(VARIANT))).getResistance();
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return COLLISION_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (int i = 0; i < Type.values().length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)i, (ModelResourceLocation)new ModelResourceLocation(this.modName + ":" + this.name, "type=" + Type.byMetadata(i).func_176610_l()));
        }
    }

    public boolean preInit() {
        this.setRegistryName("storage");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        ItemBlockStorage itemBlock = new ItemBlockStorage((Block)this);
        itemBlock.setRegistryName(this.getRegistryName());
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        blockElectrumFlux = new ItemStack((Block)this, 1, Type.ELECTRUM_FLUX.getMetadata());
        blockCrystalFlux = new ItemStack((Block)this, 1, Type.CRYSTAL_FLUX.getMetadata());
        ItemHelper.registerWithHandlers((String)"blockElectrumFlux", (ItemStack)blockElectrumFlux);
        ItemHelper.registerWithHandlers((String)"blockCrystalFlux", (ItemStack)blockCrystalFlux);
        RedstoneArsenal.proxy.addIModelRegister(this);
        return true;
    }

    public boolean initialize() {
        RecipeHelper.addStorageRecipe((ItemStack)blockElectrumFlux, (String)"ingotElectrumFlux");
        RecipeHelper.addStorageRecipe((ItemStack)blockCrystalFlux, (String)"gemCrystalFlux");
        return true;
    }

    public static enum Type implements IStringSerializable
    {
        ELECTRUM_FLUX(0, "electrumFlux", blockElectrumFlux, 7),
        CRYSTAL_FLUX(1, "crystalFlux", blockCrystalFlux, 7);

        private static final Type[] METADATA_LOOKUP;
        private final int metadata;
        private final String name;
        private final ItemStack stack;
        private final int light;
        private final float hardness;
        private final float resistance;
        private final EnumRarity rarity;

        private Type(int metadata, String name, ItemStack stack, int light, float hardness, float resistance, EnumRarity rarity) {
            this.metadata = metadata;
            this.name = name;
            this.stack = stack;
            this.light = light;
            this.hardness = hardness;
            this.resistance = resistance;
            this.rarity = rarity;
        }

        private Type(int metadata, String name, ItemStack stack, int light, float hardness, float resistance) {
            this(metadata, name, stack, light, hardness, resistance, EnumRarity.UNCOMMON);
        }

        private Type(int metadata, String name, ItemStack stack, float hardness, float resistance) {
            this(metadata, name, stack, 0, hardness, resistance, EnumRarity.UNCOMMON);
        }

        private Type(int metadata, String name, ItemStack stack, int light) {
            this(metadata, name, stack, light, 25.0f, 120.0f, EnumRarity.UNCOMMON);
        }

        private Type(int metadata, String name, ItemStack stack) {
            this(metadata, name, stack, 0, 25.0f, 120.0f, EnumRarity.UNCOMMON);
        }

        public int getMetadata() {
            return this.metadata;
        }

        public String func_176610_l() {
            return this.name.toLowerCase(Locale.US);
        }

        public String getNameRaw() {
            return this.name;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public int getLight() {
            return this.light;
        }

        public float getHardness() {
            return this.hardness;
        }

        public float getResistance() {
            return this.resistance;
        }

        public EnumRarity getRarity() {
            return this.rarity;
        }

        public static Type byMetadata(int metadata) {
            if (metadata < 0 || metadata >= METADATA_LOOKUP.length) {
                metadata = 0;
            }
            return METADATA_LOOKUP[metadata];
        }

        static {
            METADATA_LOOKUP = new Type[Type.values().length];
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type type;
                Type.METADATA_LOOKUP[type.getMetadata()] = type = typeArray[i];
            }
        }
    }
}

