/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tablet;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Mouse;
import pl.asie.charset.module.tablet.format.ClientTypesetter;
import pl.asie.charset.module.tablet.format.api.IPrintingContextMinecraft;
import pl.asie.charset.module.tablet.format.api.IStyle;
import pl.asie.charset.module.tablet.format.api.TabletAPI;

public class GuiTablet
extends GuiScreen
implements IPrintingContextMinecraft {
    private static final boolean ENABLE_HIGHLIGHT = false;
    private static final int[] PALETTE = new int[]{0, 0x1C000000, 0x30000000, 0x48000000, 0x60000000, 0x78000000, -1711276032, -1140850688};
    private static final ResourceLocation TEXTURE = new ResourceLocation("charset", "textures/gui/tabletgui.png");
    private static final int X_SIZE = 142;
    private static final int Y_SIZE = 180;
    private static final int offsetLeft = 12;
    private static final int offsetTop = 10;
    private int guiLeft;
    private int guiTop;
    private float glScale = 1.0f;
    private int buttonState = 1;
    private int heightStart = 0;
    private int heightEnd = 0;
    private int heightPos = 0;
    private int pageWidth = 240;
    private int pageHeight = 300;
    private Deque<URI> uriQueue = new LinkedBlockingDeque<URI>();
    private URI currentURI = null;
    private Future<String> currentFuture;
    private ClientTypesetter typesetter;
    private List<IStyle> currentStyle;

    public GuiTablet(EntityPlayer player) {
    }

    protected final boolean insideRect(int x, int y, int x0, int y0, int w, int h) {
        return x >= x0 && y >= y0 && x < x0 + w && y < y0 + h;
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        ScaledResolution realRes = new ScaledResolution(this.field_146297_k);
        int scaleFactor = 1;
        int margin = 4;
        while (this.field_146297_k.field_71443_c / scaleFactor >= 142 + margin && this.field_146297_k.field_71440_d / scaleFactor >= 180 + margin) {
            if (++scaleFactor < 2 || (scaleFactor & 1) != 1) continue;
            ++scaleFactor;
        }
        if (--scaleFactor > 2 && (scaleFactor & 1) == 1) {
            --scaleFactor;
        }
        double scaledWidth = (double)this.field_146297_k.field_71443_c / (double)scaleFactor;
        double scaledHeight = (double)this.field_146297_k.field_71440_d / (double)scaleFactor;
        this.glScale = (float)(scaledWidth / realRes.func_78327_c());
        this.guiLeft = (MathHelper.func_76143_f((double)scaledWidth) - 142) / 2;
        this.guiTop = (MathHelper.func_76143_f((double)scaledHeight) - 180) / 2;
        if (this.currentFuture == null && this.currentURI == null) {
            try {
                this.openURI(new URI("about://index"));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.closePreviousFuture();
    }

    private void closePreviousFuture() {
        if (this.currentFuture != null) {
            this.currentFuture.cancel(true);
            this.currentFuture = null;
        }
    }

    private void load(String text) {
        this.typesetter = new ClientTypesetter(this.field_146289_q, this.pageWidth);
        try {
            this.typesetter.write(text);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.heightStart = 0;
        this.heightPos = 0;
        this.heightEnd = 10;
        for (int i = 0; i < this.typesetter.lines.size(); ++i) {
            ClientTypesetter.Line l = this.typesetter.lines.get(i);
            this.heightEnd += l.height;
            if (i <= 0) continue;
            this.heightEnd += l.paddingAbove;
        }
        this.heightEnd -= this.pageHeight;
        this.heightEnd -= this.heightEnd % this.field_146289_q.field_78288_b + 1;
        if (this.heightEnd < 0) {
            this.heightEnd = 0;
        }
    }

    public void bindTexture(ResourceLocation texture) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.currentFuture != null && this.currentFuture.isDone()) {
            try {
                this.load(this.currentFuture.get());
                this.currentFuture = null;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.currentFuture = null;
                this.load("\\b{Error!} " + e.getMessage());
            }
        }
    }

    private boolean isButton(int mx, int my) {
        return mx >= this.guiLeft + 65 && my >= this.guiTop + 167 && mx < this.guiLeft + 65 + 18 && my < this.guiTop + 167 + 8;
    }

    private void checkTypesetterClicked(int mx, int my) {
        mx = (mx - this.guiLeft - 12) * 2;
        my = (my - this.guiTop - 10) * 2;
        int y = 0;
        for (int i = 0; i < this.typesetter.lines.size(); ++i) {
            ClientTypesetter.Line nextLine;
            ClientTypesetter.Line line = this.typesetter.lines.get(i);
            ClientTypesetter.Line line2 = nextLine = i < this.typesetter.lines.size() - 1 ? this.typesetter.lines.get(i + 1) : null;
            if (y >= this.heightPos) {
                int x = 0;
                for (ClientTypesetter.WordContainer word : line.words) {
                    this.currentStyle = word.styles;
                    int hOff = (line.height - word.printer.getHeight(this, word.word)) / 3;
                    if (this.insideRect(mx, my, x, y - this.heightPos + hOff, word.printer.getWidth(this, word.word), word.printer.getHeight(this, word.word)) && word.printer.onClick(this, word.word)) {
                        return;
                    }
                    x += word.printer.getWidth(this, word.word);
                }
            }
            y += line.height;
            if (nextLine == null) continue;
            y += nextLine.paddingAbove;
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        switch (keyCode) {
            case 199: {
                this.heightPos = this.heightStart;
                break;
            }
            case 207: {
                this.heightPos = this.heightEnd;
                break;
            }
            case 201: {
                this.heightPos -= this.pageHeight - 32;
                break;
            }
            case 209: {
                this.heightPos += this.pageHeight - 32;
                break;
            }
            case 14: {
                if (!this.uriQueue.isEmpty()) {
                    this.openURI(this.uriQueue.removeFirst());
                    this.uriQueue.removeFirst();
                    break;
                }
                try {
                    this.openURI(new URI("about://index"));
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 63: {
                if (this.currentURI == null) break;
                this.openURI(this.currentURI);
                this.uriQueue.removeFirst();
            }
        }
        this.heightPos = Math.max(Math.min(this.heightEnd, this.heightPos), this.heightStart);
    }

    public void func_146274_d() {
        int x = (int)((float)(Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c) * this.glScale);
        int y = (int)((float)(this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1) * this.glScale);
        int k = Mouse.getEventButton();
        int w = Mouse.getEventDWheel();
        int oldButtonState = this.buttonState;
        if (w != 0) {
            this.heightPos = w < 0 ? (this.heightPos += this.field_146289_q.field_78288_b + 1) : (this.heightPos -= this.field_146289_q.field_78288_b + 1);
            this.heightPos = Math.max(Math.min(this.heightEnd, this.heightPos), this.heightStart);
        }
        if (k == 0) {
            if (Mouse.getEventButtonState()) {
                if (this.isButton(x, y)) {
                    this.buttonState = 2;
                } else if (this.typesetter != null) {
                    this.checkTypesetterClicked(x, y);
                }
            } else if (this.buttonState == 2) {
                this.buttonState = this.isButton(x, y) ? 1 : 1;
            }
        }
        if (oldButtonState != this.buttonState && this.buttonState == 2) {
            if (!this.uriQueue.isEmpty()) {
                this.openURI(this.uriQueue.removeFirst());
                this.uriQueue.removeFirst();
            } else {
                try {
                    this.openURI(new URI("about://index"));
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void func_73863_a(int fmx, int fmy, float p) {
        int mx = (fmx - this.guiLeft - 12) * 2;
        int my = (fmy - this.guiTop - 10) * 2;
        this.func_146276_q_();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)(1.0f / this.glScale), (float)(1.0f / this.glScale), (float)(1.0f / this.glScale));
        this.bindTexture(TEXTURE);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, 142, 180);
        this.func_73729_b(this.guiLeft + 65, this.guiTop + 167, 142, 147 + this.buttonState * 10, 18, 8);
        int ledColor = -16777216;
        if (this.currentFuture != null && System.currentTimeMillis() % 250L >= 125L) {
            ledColor = -16711936;
        }
        GuiTablet.func_73734_a((int)(this.guiLeft + 127), (int)(this.guiTop + 4), (int)(this.guiLeft + 127 + 4), (int)(this.guiTop + 4 + 1), (int)ledColor);
        GlStateManager.func_179147_l();
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.func_179109_b((float)((this.guiLeft + 12) * 2), (float)((this.guiTop + 10) * 2), (float)0.0f);
        if (this.typesetter != null) {
            int y = 0;
            for (int i = 0; i < this.typesetter.lines.size(); ++i) {
                ClientTypesetter.Line nextLine;
                ClientTypesetter.Line line = this.typesetter.lines.get(i);
                ClientTypesetter.Line line2 = nextLine = i < this.typesetter.lines.size() - 1 ? this.typesetter.lines.get(i + 1) : null;
                if (y >= this.heightPos) {
                    int x = 0;
                    for (ClientTypesetter.WordContainer word : line.words) {
                        this.currentStyle = word.styles;
                        int wwidth = word.printer.getWidth(this, word.word);
                        int wheight = word.printer.getHeight(this, word.word);
                        int hOff = (line.height - wheight) / 3;
                        boolean isHovering = this.insideRect(mx, my, x, y - this.heightPos + hOff, wwidth, wheight);
                        word.printer.draw(this, word.word, x, y - this.heightPos + hOff, isHovering);
                        if (isHovering) {
                            word.printer.drawTooltip(this, word.word, mx, my);
                        }
                        x += word.printer.getWidth(this, word.word);
                        if (line.words.size() <= 1) continue;
                    }
                }
                y += line.height;
                if (nextLine != null) {
                    y += nextLine.paddingAbove;
                }
                if (y + (nextLine != null ? nextLine.height : 0) >= this.heightPos + this.pageHeight) break;
            }
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    @Override
    public FontRenderer getFontRenderer() {
        return this.typesetter.getFontRenderer();
    }

    @Override
    public boolean openURI(URI uri) {
        if (uri == null) {
            return false;
        }
        URI uRI = uri = this.currentURI == null ? uri : this.currentURI.resolve(uri);
        if (!TabletAPI.INSTANCE.matchesRoute(uri)) {
            return false;
        }
        this.closePreviousFuture();
        if (this.currentURI != null) {
            this.uriQueue.addFirst(this.currentURI);
        }
        this.currentURI = uri;
        this.currentFuture = TabletAPI.INSTANCE.getRoute(this.currentURI);
        return true;
    }

    @Override
    public List<IStyle> getStyleList() {
        return this.currentStyle;
    }
}

