/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tablet.format;

import com.google.common.base.Strings;
import java.util.Locale;
import pl.asie.charset.module.tablet.format.ITokenizer;
import pl.asie.charset.module.tablet.format.Tokenizer;
import pl.asie.charset.module.tablet.format.api.ICommand;
import pl.asie.charset.module.tablet.format.api.ITypesetter;
import pl.asie.charset.module.tablet.format.api.TabletAPI;
import pl.asie.charset.module.tablet.format.api.TruthError;
import pl.asie.charset.module.tablet.format.words.WordText;

public abstract class AbstractTypesetter
implements ITypesetter {
    @Override
    public void write(String text) throws TruthError {
        if (Strings.isNullOrEmpty((String)text)) {
            return;
        }
        Tokenizer tokenizer = new Tokenizer(text);
        block5: while (tokenizer.nextToken()) {
            String token = tokenizer.getToken();
            if (token.isEmpty()) continue;
            switch (tokenizer.getType()) {
                default: {
                    throw new TruthError("Unknown tokentype: " + tokenizer.getToken());
                }
                case WORD: {
                    this.write(new WordText(token));
                    continue block5;
                }
                case PARAMETER: {
                    this.write(token);
                    continue block5;
                }
                case COMMAND: 
            }
            String cmdName = token.toLowerCase(Locale.ROOT);
            ICommand cmd = TabletAPI.INSTANCE.getCommand(cmdName);
            if (cmd == null) {
                throw new TruthError("Unknown command: " + cmdName);
            }
            this.runCommand(cmd, tokenizer);
        }
    }

    public abstract void writeErrorMessage(String var1);

    protected abstract void runCommand(ICommand var1, ITokenizer var2) throws TruthError;
}

