/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tablet.format;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import pl.asie.charset.module.tablet.format.AbstractTypesetter;
import pl.asie.charset.module.tablet.format.ITokenizer;
import pl.asie.charset.module.tablet.format.api.ICommand;
import pl.asie.charset.module.tablet.format.api.IPrintingContextMinecraft;
import pl.asie.charset.module.tablet.format.api.IStyle;
import pl.asie.charset.module.tablet.format.api.TabletAPIClient;
import pl.asie.charset.module.tablet.format.api.TruthError;
import pl.asie.charset.module.tablet.format.api.Word;
import pl.asie.charset.module.tablet.format.api.WordPrinterMinecraft;
import pl.asie.charset.module.tablet.format.words.WordText;

public class ClientTypesetter
extends AbstractTypesetter
implements IPrintingContextMinecraft {
    final FontRenderer font;
    final int pageWidth;
    final List<IStyle> styles;
    public final List<Line> lines;

    public ClientTypesetter(FontRenderer font, int pageWidth) {
        this.font = font;
        this.pageWidth = pageWidth;
        this.styles = new ArrayList<IStyle>();
        this.lines = new ArrayList<Line>();
        this.clear();
    }

    public void clear() {
        this.lines.clear();
        this.lines.add(new Line());
    }

    @Override
    public List<IStyle> getStyleList() {
        return this.styles;
    }

    @Override
    public boolean hasFixedWidth() {
        return true;
    }

    @Override
    public int getWidth() {
        return this.pageWidth;
    }

    @Override
    public void pushStyle(IStyle ... styles) throws TruthError {
        this.styles.addAll(Arrays.asList(styles));
    }

    @Override
    public void popStyle(int cnt) throws TruthError {
        for (int i = 0; i < cnt; ++i) {
            if (this.styles.size() == 0) {
                throw new TruthError("Tried to pop style when there wasn't one on the stack!");
            }
            this.styles.remove(this.styles.size() - 1);
        }
    }

    @Override
    public void write(Word w) {
        if (!this.lines.get(this.lines.size() - 1).add(w, false)) {
            Line line = new Line();
            this.lines.add(line);
            line.add(w, true);
        }
    }

    @Override
    public void writeErrorMessage(String msg) {
    }

    @Override
    protected void runCommand(ICommand cmd, ITokenizer tokenizer) throws TruthError {
        cmd.call(this, tokenizer);
    }

    @Override
    public FontRenderer getFontRenderer() {
        return this.font;
    }

    @Override
    public boolean openURI(URI uri) {
        return false;
    }

    public class Line {
        public List<WordContainer> words = new ArrayList<WordContainer>();
        public int length = 0;
        public int paddingAbove = 0;
        public int height = 0;

        public boolean add(Word word, boolean force) {
            WordPrinterMinecraft printer = TabletAPIClient.INSTANCE.getPrinterMinecraft(word);
            if (printer == null) {
                return false;
            }
            int len = printer.getWidth(ClientTypesetter.this, word);
            if (!force) {
                if (printer.getDisplayType() == WordPrinterMinecraft.DisplayType.BLOCK && this.length > 0) {
                    return false;
                }
                if (this.length + len > ClientTypesetter.this.pageWidth) {
                    return false;
                }
            }
            if (this.length == 0 && word instanceof WordText && ((WordText)word).getText().equals(" ")) {
                return true;
            }
            this.words.add(new WordContainer(word, printer, ClientTypesetter.this.styles));
            this.length += len;
            this.height = Math.max(this.height, printer.getHeight(ClientTypesetter.this, word));
            this.paddingAbove = Math.max(this.paddingAbove, printer.getPaddingAbove(ClientTypesetter.this, word));
            return true;
        }
    }

    public static class WordContainer {
        public final Word word;
        public final WordPrinterMinecraft<Word> printer;
        public final List<IStyle> styles;

        public WordContainer(Word word, WordPrinterMinecraft<Word> printer, List<IStyle> styles) {
            this.word = word;
            this.printer = printer;
            this.styles = ImmutableList.copyOf(styles);
        }
    }
}

