/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tablet.format;

import pl.asie.charset.module.tablet.format.ITokenizer;
import pl.asie.charset.module.tablet.format.api.TruthError;

public class Tokenizer
implements ITokenizer {
    private static final String NL = "\\p";
    private static final String WS = "\\ ";
    private final String src;
    private int scan = 0;
    private int prevScan = -1;
    private TokenType type;
    private String token = "";
    private int contigLines = 0;
    private int contigSpaces = 0;

    @Override
    public String getParameter(String info) throws TruthError {
        if (!this.nextToken()) {
            throw new TruthError("EOF while reading parameter: " + info);
        }
        if (this.type != TokenType.PARAMETER) {
            throw new TruthError("Expected parameter, not " + (Object)((Object)this.type) + ": " + info);
        }
        return this.token;
    }

    @Override
    public String getOptionalParameter() {
        if (!this.nextToken()) {
            return null;
        }
        if (this.type != TokenType.PARAMETER) {
            this.prevToken();
            return null;
        }
        return this.token;
    }

    public Tokenizer(String src) {
        this.src = src;
    }

    public String getToken() {
        return this.token;
    }

    public TokenType getType() {
        return this.type;
    }

    public boolean nextToken() {
        block12: {
            char c;
            this.prevScan = this.scan;
            block0: while (true) {
                if (this.scan >= this.src.length()) {
                    return false;
                }
                c = this.src.charAt(this.scan);
                if (c == '\n') {
                    ++this.scan;
                    ++this.contigLines;
                    if (this.contigLines != 2) continue;
                    this.type = TokenType.COMMAND;
                    this.token = NL;
                    this.contigSpaces = 0;
                    this.contigLines = 0;
                    return true;
                }
                if (c == '\r') {
                    ++this.scan;
                    continue;
                }
                if (Character.isWhitespace(c)) {
                    ++this.scan;
                    ++this.contigSpaces;
                    continue;
                }
                if (c != '%') break;
                while (this.scan < this.src.length()) {
                    if ((c = this.src.charAt(this.scan++)) != '\n') continue;
                    continue block0;
                }
                break block12;
                break;
            }
            if (this.contigLines >= 1 || this.contigSpaces >= 1) {
                this.type = TokenType.COMMAND;
                this.token = WS;
            } else if (c == '\\') {
                this.readCommand();
            } else if (c == '{') {
                this.readParameter();
            } else {
                this.readWord();
            }
        }
        this.contigSpaces = 0;
        this.contigLines = 0;
        return true;
    }

    public void prevToken() {
        if (this.prevScan == -1) {
            throw new IllegalStateException("No previous token available");
        }
        this.scan = this.prevScan;
        this.prevScan = -1;
    }

    private void emit(TokenType type, int start, int end) {
        this.type = type;
        this.token = this.src.substring(start, end);
    }

    private void readWord() {
        int start;
        block1: {
            char peak;
            char c;
            start = this.scan;
            do {
                ++this.scan;
                if (this.scan >= this.src.length() || Character.isWhitespace(c = this.src.charAt(this.scan)) || c == '\\' || c == '{') break block1;
            } while (c != '.' && c != '-' && c != '_' || this.scan + 1 >= this.src.length() || !Character.isLetterOrDigit(peak = this.src.charAt(this.scan + 1)));
            ++this.scan;
        }
        this.emit(TokenType.WORD, start, this.scan);
    }

    private void readParameter() {
        int start = this.scan;
        int count = 0;
        while (this.scan < this.src.length()) {
            char c;
            if ((c = this.src.charAt(this.scan++)) == '{') {
                ++count;
            } else if (c == '}') {
                --count;
            }
            if (count > 0) continue;
            break;
        }
        this.emit(TokenType.PARAMETER, start + 1, this.scan - 1);
    }

    private void readCommand() {
        this.readWord();
        this.type = TokenType.COMMAND;
        if (this.scan < this.src.length() - 1 && Character.isWhitespace(this.src.charAt(this.scan))) {
            ++this.scan;
        }
    }

    public static enum TokenType {
        WORD,
        COMMAND,
        PARAMETER;

    }
}

