/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tablet.format.api;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.Pair;
import pl.asie.charset.module.tablet.format.api.ICommand;
import pl.asie.charset.module.tablet.format.api.IRouter;
import pl.asie.charset.module.tablet.format.api.IStyle;
import pl.asie.charset.module.tablet.format.api.StylePrinterText;
import pl.asie.charset.module.tablet.format.api.TextPrinterFormat;
import pl.asie.charset.module.tablet.format.api.Word;
import pl.asie.charset.module.tablet.format.api.WordPrinterText;

public class TabletAPI {
    public static final TabletAPI INSTANCE = new TabletAPI();
    private final Map<String, ICommand> commandMap = new HashMap<String, ICommand>();
    private final Table<TextPrinterFormat, Class<? extends Word>, WordPrinterText> textOutputPrinterTable = HashBasedTable.create();
    private final Table<TextPrinterFormat, Class<? extends IStyle>, StylePrinterText> styleOutputPrinterTable = HashBasedTable.create();
    private final List<Pair<String, String>> books = new ArrayList<Pair<String, String>>();
    private final List<IRouter> routes = new ArrayList<IRouter>();
    private final ExecutorService service = new ThreadPoolExecutor(1, 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());

    protected TabletAPI() {
    }

    public void addBook(String name, String url) {
        this.books.add((Pair<String, String>)Pair.of((Object)name, (Object)url));
    }

    public Collection<Pair<String, String>> getBooks() {
        return this.books;
    }

    public void registerRouter(IRouter route) {
        this.routes.add(route);
    }

    public Collection<IRouter> getRouters() {
        return Collections.unmodifiableCollection(this.routes);
    }

    public boolean matchesRoute(URI path) {
        for (IRouter routerPair : this.routes) {
            if (!routerPair.matches(path)) continue;
            return true;
        }
        return false;
    }

    public Future<String> getRoute(URI path) {
        ArrayList<IRouter> routers = new ArrayList<IRouter>();
        for (IRouter routerPair : this.routes) {
            if (!routerPair.matches(path)) continue;
            routers.add(routerPair);
        }
        return this.service.submit(() -> {
            for (IRouter router : routers) {
                String out = router.get(path);
                if (out == null) continue;
                return out;
            }
            return null;
        });
    }

    public void registerPrinterStyle(TextPrinterFormat format, Class<? extends IStyle> c, StylePrinterText<? extends IStyle> printerText) {
        this.styleOutputPrinterTable.put((Object)format, c, printerText);
    }

    public StylePrinterText getPrinterStyle(TextPrinterFormat format, IStyle w) {
        Class<?> c;
        for (c = w.getClass(); c != IStyle.class && c != Object.class && c != null && !this.styleOutputPrinterTable.contains((Object)format, c); c = c.getSuperclass()) {
        }
        return (StylePrinterText)this.styleOutputPrinterTable.get((Object)format, c);
    }

    public void registerPrinterText(TextPrinterFormat format, Class<? extends Word> c, WordPrinterText<? extends Word> printerText) {
        this.textOutputPrinterTable.put((Object)format, c, printerText);
    }

    public WordPrinterText getPrinterText(TextPrinterFormat format, Word w) {
        Class<?> c;
        for (c = w.getClass(); c != Word.class && c != Object.class && c != null && !this.textOutputPrinterTable.contains((Object)format, c); c = c.getSuperclass()) {
        }
        return (WordPrinterText)this.textOutputPrinterTable.get((Object)format, c);
    }

    public ICommand getCommand(String name) {
        return this.commandMap.get(name);
    }

    public void registerCommand(String name, ICommand command) {
        this.commandMap.put(name, command);
    }
}

